/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.VocabularySummary;
import software.amazon.awssdk.services.connect.model.VocabularySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchVocabulariesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchVocabulariesResponse> {
    private static final SdkField<List<VocabularySummary>> VOCABULARY_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VocabularySummaryList").getter(SearchVocabulariesResponse.getter(SearchVocabulariesResponse::vocabularySummaryList)).setter(SearchVocabulariesResponse.setter(Builder::vocabularySummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularySummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VocabularySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchVocabulariesResponse.getter(SearchVocabulariesResponse::nextToken)).setter(SearchVocabulariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VocabularySummaryList", VOCABULARY_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<VocabularySummary> vocabularySummaryList;
    private final String nextToken;

    private SearchVocabulariesResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularySummaryList = builder.vocabularySummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVocabularySummaryList() {
        return this.vocabularySummaryList != null && !(this.vocabularySummaryList instanceof SdkAutoConstructList);
    }

    public final List<VocabularySummary> vocabularySummaryList() {
        return this.vocabularySummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVocabularySummaryList() ? this.vocabularySummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVocabulariesResponse)) {
            return false;
        }
        SearchVocabulariesResponse other = (SearchVocabulariesResponse)((Object)obj);
        return this.hasVocabularySummaryList() == other.hasVocabularySummaryList() && Objects.equals(this.vocabularySummaryList(), other.vocabularySummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchVocabulariesResponse").add("VocabularySummaryList", this.hasVocabularySummaryList() ? this.vocabularySummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularySummaryList": {
                return Optional.ofNullable(clazz.cast(this.vocabularySummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchVocabulariesResponse, T> g) {
        return obj -> g.apply((SearchVocabulariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<VocabularySummary> vocabularySummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVocabulariesResponse model) {
            super(model);
            this.vocabularySummaryList(model.vocabularySummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<VocabularySummary.Builder> getVocabularySummaryList() {
            List<VocabularySummary.Builder> result = VocabularySummaryListCopier.copyToBuilder(this.vocabularySummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVocabularySummaryList(Collection<VocabularySummary.BuilderImpl> vocabularySummaryList) {
            this.vocabularySummaryList = VocabularySummaryListCopier.copyFromBuilder(vocabularySummaryList);
        }

        @Override
        public final Builder vocabularySummaryList(Collection<VocabularySummary> vocabularySummaryList) {
            this.vocabularySummaryList = VocabularySummaryListCopier.copy(vocabularySummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularySummaryList(VocabularySummary ... vocabularySummaryList) {
            this.vocabularySummaryList(Arrays.asList(vocabularySummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularySummaryList(Consumer<VocabularySummary.Builder> ... vocabularySummaryList) {
            this.vocabularySummaryList(Stream.of(vocabularySummaryList).map(c -> (VocabularySummary)((VocabularySummary.Builder)VocabularySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchVocabulariesResponse build() {
            return new SearchVocabulariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchVocabulariesResponse> {
        public Builder vocabularySummaryList(Collection<VocabularySummary> var1);

        public Builder vocabularySummaryList(VocabularySummary ... var1);

        public Builder vocabularySummaryList(Consumer<VocabularySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

