/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentAttributeValue> {
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueString").getter(SegmentAttributeValue.getter(SegmentAttributeValue::valueString)).setter(SegmentAttributeValue.setter(Builder::valueString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueString").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> VALUE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ValueMap").getter(SegmentAttributeValue.getter(SegmentAttributeValue::valueMap)).setter(SegmentAttributeValue.setter(Builder::valueMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> VALUE_INTEGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValueInteger").getter(SegmentAttributeValue.getter(SegmentAttributeValue::valueInteger)).setter(SegmentAttributeValue.setter(Builder::valueInteger)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInteger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_STRING_FIELD, VALUE_MAP_FIELD, VALUE_INTEGER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ValueString", VALUE_STRING_FIELD);
            this.put("ValueMap", VALUE_MAP_FIELD);
            this.put("ValueInteger", VALUE_INTEGER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String valueString;
    private final Map<String, SegmentAttributeValue> valueMap;
    private final Integer valueInteger;

    private SegmentAttributeValue(BuilderImpl builder) {
        this.valueString = builder.valueString;
        this.valueMap = builder.valueMap;
        this.valueInteger = builder.valueInteger;
    }

    public final String valueString() {
        return this.valueString;
    }

    public final boolean hasValueMap() {
        return this.valueMap != null && !(this.valueMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> valueMap() {
        return this.valueMap;
    }

    public final Integer valueInteger() {
        return this.valueInteger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueMap() ? this.valueMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.valueInteger());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentAttributeValue)) {
            return false;
        }
        SegmentAttributeValue other = (SegmentAttributeValue)obj;
        return Objects.equals(this.valueString(), other.valueString()) && this.hasValueMap() == other.hasValueMap() && Objects.equals(this.valueMap(), other.valueMap()) && Objects.equals(this.valueInteger(), other.valueInteger());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentAttributeValue").add("ValueString", (Object)this.valueString()).add("ValueMap", this.hasValueMap() ? this.valueMap() : null).add("ValueInteger", (Object)this.valueInteger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueString": {
                return Optional.ofNullable(clazz.cast(this.valueString()));
            }
            case "ValueMap": {
                return Optional.ofNullable(clazz.cast(this.valueMap()));
            }
            case "ValueInteger": {
                return Optional.ofNullable(clazz.cast(this.valueInteger()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SegmentAttributeValue, T> g) {
        return obj -> g.apply((SegmentAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String valueString;
        private Map<String, SegmentAttributeValue> valueMap = DefaultSdkAutoConstructMap.getInstance();
        private Integer valueInteger;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentAttributeValue model) {
            this.valueString(model.valueString);
            this.valueMap(model.valueMap);
            this.valueInteger(model.valueInteger);
        }

        public final String getValueString() {
            return this.valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public final Map<String, Builder> getValueMap() {
            Map<String, Builder> result = SegmentAttributeValueMapCopier.copyToBuilder(this.valueMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueMap(Map<String, BuilderImpl> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copyFromBuilder(valueMap);
        }

        @Override
        public final Builder valueMap(Map<String, SegmentAttributeValue> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copy(valueMap);
            return this;
        }

        public final Integer getValueInteger() {
            return this.valueInteger;
        }

        public final void setValueInteger(Integer valueInteger) {
            this.valueInteger = valueInteger;
        }

        @Override
        public final Builder valueInteger(Integer valueInteger) {
            this.valueInteger = valueInteger;
            return this;
        }

        public SegmentAttributeValue build() {
            return new SegmentAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentAttributeValue> {
        public Builder valueString(String var1);

        public Builder valueMap(Map<String, SegmentAttributeValue> var1);

        public Builder valueInteger(Integer var1);
    }
}

