/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.UserProficiency;

public class ListUserProficienciesIterable
implements SdkIterable<ListUserProficienciesResponse> {
    private final ConnectClient client;
    private final ListUserProficienciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserProficienciesIterable(ConnectClient client, ListUserProficienciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserProficienciesResponseFetcher();
    }

    public Iterator<ListUserProficienciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserProficiency> userProficiencyList() {
        Function<ListUserProficienciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.userProficiencyList() != null) {
                return response.userProficiencyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserProficienciesResponseFetcher
    implements SyncPageFetcher<ListUserProficienciesResponse> {
        private ListUserProficienciesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserProficienciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserProficienciesResponse nextPage(ListUserProficienciesResponse previousPage) {
            if (previousPage == null) {
                return ListUserProficienciesIterable.this.client.listUserProficiencies(ListUserProficienciesIterable.this.firstRequest);
            }
            return ListUserProficienciesIterable.this.client.listUserProficiencies((ListUserProficienciesRequest)((Object)ListUserProficienciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

