/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Prompt;
import software.amazon.awssdk.services.connect.model.SearchPromptsRequest;
import software.amazon.awssdk.services.connect.model.SearchPromptsResponse;

public class SearchPromptsPublisher
implements SdkPublisher<SearchPromptsResponse> {
    private final ConnectAsyncClient client;
    private final SearchPromptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchPromptsPublisher(ConnectAsyncClient client, SearchPromptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchPromptsPublisher(ConnectAsyncClient client, SearchPromptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchPromptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchPromptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Prompt> prompts() {
        Function<SearchPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prompts() != null) {
                return response.prompts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchPromptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchPromptsResponseFetcher
    implements AsyncPageFetcher<SearchPromptsResponse> {
        private SearchPromptsResponseFetcher() {
        }

        public boolean hasNextPage(SearchPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchPromptsResponse> nextPage(SearchPromptsResponse previousPage) {
            if (previousPage == null) {
                return SearchPromptsPublisher.this.client.searchPrompts(SearchPromptsPublisher.this.firstRequest);
            }
            return SearchPromptsPublisher.this.client.searchPrompts((SearchPromptsRequest)((Object)SearchPromptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

