/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EmailRecipient;
import software.amazon.awssdk.services.connect.model.EmailRecipientsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalEmailRecipients
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalEmailRecipients> {
    private static final SdkField<List<EmailRecipient>> TO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ToList").getter(AdditionalEmailRecipients.getter(AdditionalEmailRecipients::toList)).setter(AdditionalEmailRecipients.setter(Builder::toList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailRecipient::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EmailRecipient>> CC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CcList").getter(AdditionalEmailRecipients.getter(AdditionalEmailRecipients::ccList)).setter(AdditionalEmailRecipients.setter(Builder::ccList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailRecipient::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_LIST_FIELD, CC_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdditionalEmailRecipients.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EmailRecipient> toList;
    private final List<EmailRecipient> ccList;

    private AdditionalEmailRecipients(BuilderImpl builder) {
        this.toList = builder.toList;
        this.ccList = builder.ccList;
    }

    public final boolean hasToList() {
        return this.toList != null && !(this.toList instanceof SdkAutoConstructList);
    }

    public final List<EmailRecipient> toList() {
        return this.toList;
    }

    public final boolean hasCcList() {
        return this.ccList != null && !(this.ccList instanceof SdkAutoConstructList);
    }

    public final List<EmailRecipient> ccList() {
        return this.ccList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToList() ? this.toList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCcList() ? this.ccList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalEmailRecipients)) {
            return false;
        }
        AdditionalEmailRecipients other = (AdditionalEmailRecipients)obj;
        return this.hasToList() == other.hasToList() && Objects.equals(this.toList(), other.toList()) && this.hasCcList() == other.hasCcList() && Objects.equals(this.ccList(), other.ccList());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalEmailRecipients").add("ToList", this.hasToList() ? this.toList() : null).add("CcList", this.hasCcList() ? this.ccList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToList": {
                return Optional.ofNullable(clazz.cast(this.toList()));
            }
            case "CcList": {
                return Optional.ofNullable(clazz.cast(this.ccList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<EmailRecipient>>> map = new HashMap<String, SdkField<List<EmailRecipient>>>();
        map.put("ToList", TO_LIST_FIELD);
        map.put("CcList", CC_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalEmailRecipients, T> g) {
        return obj -> g.apply((AdditionalEmailRecipients)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EmailRecipient> toList = DefaultSdkAutoConstructList.getInstance();
        private List<EmailRecipient> ccList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalEmailRecipients model) {
            this.toList(model.toList);
            this.ccList(model.ccList);
        }

        public final List<EmailRecipient.Builder> getToList() {
            List<EmailRecipient.Builder> result = EmailRecipientsListCopier.copyToBuilder(this.toList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToList(Collection<EmailRecipient.BuilderImpl> toList) {
            this.toList = EmailRecipientsListCopier.copyFromBuilder(toList);
        }

        @Override
        public final Builder toList(Collection<EmailRecipient> toList) {
            this.toList = EmailRecipientsListCopier.copy(toList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toList(EmailRecipient ... toList) {
            this.toList(Arrays.asList(toList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toList(Consumer<EmailRecipient.Builder> ... toList) {
            this.toList(Stream.of(toList).map(c -> (EmailRecipient)((EmailRecipient.Builder)EmailRecipient.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailRecipient.Builder> getCcList() {
            List<EmailRecipient.Builder> result = EmailRecipientsListCopier.copyToBuilder(this.ccList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCcList(Collection<EmailRecipient.BuilderImpl> ccList) {
            this.ccList = EmailRecipientsListCopier.copyFromBuilder(ccList);
        }

        @Override
        public final Builder ccList(Collection<EmailRecipient> ccList) {
            this.ccList = EmailRecipientsListCopier.copy(ccList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccList(EmailRecipient ... ccList) {
            this.ccList(Arrays.asList(ccList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccList(Consumer<EmailRecipient.Builder> ... ccList) {
            this.ccList(Stream.of(ccList).map(c -> (EmailRecipient)((EmailRecipient.Builder)EmailRecipient.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AdditionalEmailRecipients build() {
            return new AdditionalEmailRecipients(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalEmailRecipients> {
        public Builder toList(Collection<EmailRecipient> var1);

        public Builder toList(EmailRecipient ... var1);

        public Builder toList(Consumer<EmailRecipient.Builder> ... var1);

        public Builder ccList(Collection<EmailRecipient> var1);

        public Builder ccList(EmailRecipient ... var1);

        public Builder ccList(Consumer<EmailRecipient.Builder> ... var1);
    }
}

