/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchHoursOfOperationOverridesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchHoursOfOperationOverridesResponse> {
    private static final SdkField<List<HoursOfOperationOverride>> HOURS_OF_OPERATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HoursOfOperationOverrides").getter(SearchHoursOfOperationOverridesResponse.getter(SearchHoursOfOperationOverridesResponse::hoursOfOperationOverrides)).setter(SearchHoursOfOperationOverridesResponse.setter(Builder::hoursOfOperationOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchHoursOfOperationOverridesResponse.getter(SearchHoursOfOperationOverridesResponse::nextToken)).setter(SearchHoursOfOperationOverridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchHoursOfOperationOverridesResponse.getter(SearchHoursOfOperationOverridesResponse::approximateTotalCount)).setter(SearchHoursOfOperationOverridesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_OVERRIDES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchHoursOfOperationOverridesResponse.memberNameToFieldInitializer();
    private final List<HoursOfOperationOverride> hoursOfOperationOverrides;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchHoursOfOperationOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationOverrides = builder.hoursOfOperationOverrides;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasHoursOfOperationOverrides() {
        return this.hoursOfOperationOverrides != null && !(this.hoursOfOperationOverrides instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationOverride> hoursOfOperationOverrides() {
        return this.hoursOfOperationOverrides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHoursOfOperationOverrides() ? this.hoursOfOperationOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchHoursOfOperationOverridesResponse)) {
            return false;
        }
        SearchHoursOfOperationOverridesResponse other = (SearchHoursOfOperationOverridesResponse)((Object)obj);
        return this.hasHoursOfOperationOverrides() == other.hasHoursOfOperationOverrides() && Objects.equals(this.hoursOfOperationOverrides(), other.hoursOfOperationOverrides()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchHoursOfOperationOverridesResponse").add("HoursOfOperationOverrides", this.hasHoursOfOperationOverrides() ? this.hoursOfOperationOverrides() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HoursOfOperationOverrides": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationOverrides()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HoursOfOperationOverrides", HOURS_OF_OPERATION_OVERRIDES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchHoursOfOperationOverridesResponse, T> g) {
        return obj -> g.apply((SearchHoursOfOperationOverridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<HoursOfOperationOverride> hoursOfOperationOverrides = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchHoursOfOperationOverridesResponse model) {
            super(model);
            this.hoursOfOperationOverrides(model.hoursOfOperationOverrides);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<HoursOfOperationOverride.Builder> getHoursOfOperationOverrides() {
            List<HoursOfOperationOverride.Builder> result = HoursOfOperationOverrideListCopier.copyToBuilder(this.hoursOfOperationOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHoursOfOperationOverrides(Collection<HoursOfOperationOverride.BuilderImpl> hoursOfOperationOverrides) {
            this.hoursOfOperationOverrides = HoursOfOperationOverrideListCopier.copyFromBuilder(hoursOfOperationOverrides);
        }

        @Override
        public final Builder hoursOfOperationOverrides(Collection<HoursOfOperationOverride> hoursOfOperationOverrides) {
            this.hoursOfOperationOverrides = HoursOfOperationOverrideListCopier.copy(hoursOfOperationOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrides(HoursOfOperationOverride ... hoursOfOperationOverrides) {
            this.hoursOfOperationOverrides(Arrays.asList(hoursOfOperationOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrides(Consumer<HoursOfOperationOverride.Builder> ... hoursOfOperationOverrides) {
            this.hoursOfOperationOverrides(Stream.of(hoursOfOperationOverrides).map(c -> (HoursOfOperationOverride)((HoursOfOperationOverride.Builder)HoursOfOperationOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchHoursOfOperationOverridesResponse build() {
            return new SearchHoursOfOperationOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchHoursOfOperationOverridesResponse> {
        public Builder hoursOfOperationOverrides(Collection<HoursOfOperationOverride> var1);

        public Builder hoursOfOperationOverrides(HoursOfOperationOverride ... var1);

        public Builder hoursOfOperationOverrides(Consumer<HoursOfOperationOverride.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

