/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.StringComparisonType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(StringCondition.getter(StringCondition::fieldName)).setter(StringCondition.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(StringCondition.getter(StringCondition::value)).setter(StringCondition.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonType").getter(StringCondition.getter(StringCondition::comparisonTypeAsString)).setter(StringCondition.setter(Builder::comparisonType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, VALUE_FIELD, COMPARISON_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String value;
    private final String comparisonType;

    private StringCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.value = builder.value;
        this.comparisonType = builder.comparisonType;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String value() {
        return this.value;
    }

    public final StringComparisonType comparisonType() {
        return StringComparisonType.fromValue(this.comparisonType);
    }

    public final String comparisonTypeAsString() {
        return this.comparisonType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringCondition)) {
            return false;
        }
        StringCondition other = (StringCondition)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StringCondition").add("FieldName", (Object)this.fieldName()).add("Value", (Object)this.value()).add("ComparisonType", (Object)this.comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ComparisonType": {
                return Optional.ofNullable(clazz.cast(this.comparisonTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringCondition, T> g) {
        return obj -> g.apply((StringCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String value;
        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(StringCondition model) {
            this.fieldName(model.fieldName);
            this.value(model.value);
            this.comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getComparisonType() {
            return this.comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(StringComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        public StringCondition build() {
            return new StringCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringCondition> {
        public Builder fieldName(String var1);

        public Builder value(String var1);

        public Builder comparisonType(String var1);

        public Builder comparisonType(StringComparisonType var1);
    }
}

