/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfig;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHoursOfOperationOverrideRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateHoursOfOperationOverrideRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::instanceId)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationId").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::hoursOfOperationId)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::hoursOfOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_OVERRIDE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationOverrideId").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::hoursOfOperationOverrideId)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::hoursOfOperationOverrideId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationOverrideId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::name)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::description)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<HoursOfOperationOverrideConfig>> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Config").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::config)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::config)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationOverrideConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EFFECTIVE_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveFrom").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::effectiveFrom)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::effectiveFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveFrom").build()}).build();
    private static final SdkField<String> EFFECTIVE_TILL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveTill").getter(UpdateHoursOfOperationOverrideRequest.getter(UpdateHoursOfOperationOverrideRequest::effectiveTill)).setter(UpdateHoursOfOperationOverrideRequest.setter(Builder::effectiveTill)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveTill").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, HOURS_OF_OPERATION_ID_FIELD, HOURS_OF_OPERATION_OVERRIDE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONFIG_FIELD, EFFECTIVE_FROM_FIELD, EFFECTIVE_TILL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHoursOfOperationOverrideRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String hoursOfOperationId;
    private final String hoursOfOperationOverrideId;
    private final String name;
    private final String description;
    private final List<HoursOfOperationOverrideConfig> config;
    private final String effectiveFrom;
    private final String effectiveTill;

    private UpdateHoursOfOperationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationOverrideId = builder.hoursOfOperationOverrideId;
        this.name = builder.name;
        this.description = builder.description;
        this.config = builder.config;
        this.effectiveFrom = builder.effectiveFrom;
        this.effectiveTill = builder.effectiveTill;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String hoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public final String hoursOfOperationOverrideId() {
        return this.hoursOfOperationOverrideId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasConfig() {
        return this.config != null && !(this.config instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationOverrideConfig> config() {
        return this.config;
    }

    public final String effectiveFrom() {
        return this.effectiveFrom;
    }

    public final String effectiveTill() {
        return this.effectiveTill;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationOverrideId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfig() ? this.config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveTill());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHoursOfOperationOverrideRequest)) {
            return false;
        }
        UpdateHoursOfOperationOverrideRequest other = (UpdateHoursOfOperationOverrideRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(this.hoursOfOperationOverrideId(), other.hoursOfOperationOverrideId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasConfig() == other.hasConfig() && Objects.equals(this.config(), other.config()) && Objects.equals(this.effectiveFrom(), other.effectiveFrom()) && Objects.equals(this.effectiveTill(), other.effectiveTill());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHoursOfOperationOverrideRequest").add("InstanceId", (Object)this.instanceId()).add("HoursOfOperationId", (Object)this.hoursOfOperationId()).add("HoursOfOperationOverrideId", (Object)this.hoursOfOperationOverrideId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Config", this.hasConfig() ? this.config() : null).add("EffectiveFrom", (Object)this.effectiveFrom()).add("EffectiveTill", (Object)this.effectiveTill()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HoursOfOperationId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationId()));
            }
            case "HoursOfOperationOverrideId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationOverrideId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "EffectiveFrom": {
                return Optional.ofNullable(clazz.cast(this.effectiveFrom()));
            }
            case "EffectiveTill": {
                return Optional.ofNullable(clazz.cast(this.effectiveTill()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("HoursOfOperationOverrideId", HOURS_OF_OPERATION_OVERRIDE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Config", CONFIG_FIELD);
        map.put("EffectiveFrom", EFFECTIVE_FROM_FIELD);
        map.put("EffectiveTill", EFFECTIVE_TILL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHoursOfOperationOverrideRequest, T> g) {
        return obj -> g.apply((UpdateHoursOfOperationOverrideRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String hoursOfOperationId;
        private String hoursOfOperationOverrideId;
        private String name;
        private String description;
        private List<HoursOfOperationOverrideConfig> config = DefaultSdkAutoConstructList.getInstance();
        private String effectiveFrom;
        private String effectiveTill;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHoursOfOperationOverrideRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.hoursOfOperationId(model.hoursOfOperationId);
            this.hoursOfOperationOverrideId(model.hoursOfOperationOverrideId);
            this.name(model.name);
            this.description(model.description);
            this.config(model.config);
            this.effectiveFrom(model.effectiveFrom);
            this.effectiveTill(model.effectiveTill);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return this.hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationOverrideId() {
            return this.hoursOfOperationOverrideId;
        }

        public final void setHoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
        }

        @Override
        public final Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<HoursOfOperationOverrideConfig.Builder> getConfig() {
            List<HoursOfOperationOverrideConfig.Builder> result = HoursOfOperationOverrideConfigListCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationOverrideConfig.BuilderImpl> config) {
            this.config = HoursOfOperationOverrideConfigListCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Collection<HoursOfOperationOverrideConfig> config) {
            this.config = HoursOfOperationOverrideConfigListCopier.copy(config);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(HoursOfOperationOverrideConfig ... config) {
            this.config(Arrays.asList(config));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationOverrideConfig.Builder> ... config) {
            this.config(Stream.of(config).map(c -> (HoursOfOperationOverrideConfig)((HoursOfOperationOverrideConfig.Builder)HoursOfOperationOverrideConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEffectiveFrom() {
            return this.effectiveFrom;
        }

        public final void setEffectiveFrom(String effectiveFrom) {
            this.effectiveFrom = effectiveFrom;
        }

        @Override
        public final Builder effectiveFrom(String effectiveFrom) {
            this.effectiveFrom = effectiveFrom;
            return this;
        }

        public final String getEffectiveTill() {
            return this.effectiveTill;
        }

        public final void setEffectiveTill(String effectiveTill) {
            this.effectiveTill = effectiveTill;
        }

        @Override
        public final Builder effectiveTill(String effectiveTill) {
            this.effectiveTill = effectiveTill;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHoursOfOperationOverrideRequest build() {
            return new UpdateHoursOfOperationOverrideRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHoursOfOperationOverrideRequest> {
        public Builder instanceId(String var1);

        public Builder hoursOfOperationId(String var1);

        public Builder hoursOfOperationOverrideId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder config(Collection<HoursOfOperationOverrideConfig> var1);

        public Builder config(HoursOfOperationOverrideConfig ... var1);

        public Builder config(Consumer<HoursOfOperationOverrideConfig.Builder> ... var1);

        public Builder effectiveFrom(String var1);

        public Builder effectiveTill(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

