/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.UrlMetadataSignedHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadUrlMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadUrlMetadata> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(UploadUrlMetadata.getter(UploadUrlMetadata::url)).setter(UploadUrlMetadata.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UrlExpiry").getter(UploadUrlMetadata.getter(UploadUrlMetadata::urlExpiry)).setter(UploadUrlMetadata.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiry").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_TO_INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("HeadersToInclude").getter(UploadUrlMetadata.getter(UploadUrlMetadata::headersToInclude)).setter(UploadUrlMetadata.setter(Builder::headersToInclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersToInclude").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, URL_EXPIRY_FIELD, HEADERS_TO_INCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UploadUrlMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String urlExpiry;
    private final Map<String, String> headersToInclude;

    private UploadUrlMetadata(BuilderImpl builder) {
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
        this.headersToInclude = builder.headersToInclude;
    }

    public final String url() {
        return this.url;
    }

    public final String urlExpiry() {
        return this.urlExpiry;
    }

    public final boolean hasHeadersToInclude() {
        return this.headersToInclude != null && !(this.headersToInclude instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headersToInclude() {
        return this.headersToInclude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeadersToInclude() ? this.headersToInclude() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadUrlMetadata)) {
            return false;
        }
        UploadUrlMetadata other = (UploadUrlMetadata)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry()) && this.hasHeadersToInclude() == other.hasHeadersToInclude() && Objects.equals(this.headersToInclude(), other.headersToInclude());
    }

    public final String toString() {
        return ToString.builder((String)"UploadUrlMetadata").add("Url", (Object)this.url()).add("UrlExpiry", (Object)this.urlExpiry()).add("HeadersToInclude", this.hasHeadersToInclude() ? this.headersToInclude() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "UrlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
            case "HeadersToInclude": {
                return Optional.ofNullable(clazz.cast(this.headersToInclude()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("UrlExpiry", URL_EXPIRY_FIELD);
        map.put("HeadersToInclude", HEADERS_TO_INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadUrlMetadata, T> g) {
        return obj -> g.apply((UploadUrlMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String urlExpiry;
        private Map<String, String> headersToInclude = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadUrlMetadata model) {
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
            this.headersToInclude(model.headersToInclude);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(String urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(String urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public final Map<String, String> getHeadersToInclude() {
            if (this.headersToInclude instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headersToInclude;
        }

        public final void setHeadersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = UrlMetadataSignedHeadersCopier.copy(headersToInclude);
        }

        @Override
        public final Builder headersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = UrlMetadataSignedHeadersCopier.copy(headersToInclude);
            return this;
        }

        public UploadUrlMetadata build() {
            return new UploadUrlMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadUrlMetadata> {
        public Builder url(String var1);

        public Builder urlExpiry(String var1);

        public Builder headersToInclude(Map<String, String> var1);
    }
}

