/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.RoutingProfile;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse;

public class SearchRoutingProfilesPublisher
implements SdkPublisher<SearchRoutingProfilesResponse> {
    private final ConnectAsyncClient client;
    private final SearchRoutingProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchRoutingProfilesPublisher(ConnectAsyncClient client, SearchRoutingProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchRoutingProfilesPublisher(ConnectAsyncClient client, SearchRoutingProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchRoutingProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchRoutingProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoutingProfile> routingProfiles() {
        Function<SearchRoutingProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfiles() != null) {
                return response.routingProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchRoutingProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchRoutingProfilesResponseFetcher
    implements AsyncPageFetcher<SearchRoutingProfilesResponse> {
        private SearchRoutingProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchRoutingProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchRoutingProfilesResponse> nextPage(SearchRoutingProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchRoutingProfilesPublisher.this.client.searchRoutingProfiles(SearchRoutingProfilesPublisher.this.firstRequest);
            }
            return SearchRoutingProfilesPublisher.this.client.searchRoutingProfiles((SearchRoutingProfilesRequest)((Object)SearchRoutingProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

