/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional filter that narrows the results to a specific objective.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommonControlFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CommonControlFilter.Builder, CommonControlFilter> {
    private static final SdkField<List<ObjectiveResourceFilter>> OBJECTIVES_FIELD = SdkField
            .<List<ObjectiveResourceFilter>> builder(MarshallingType.LIST)
            .memberName("Objectives")
            .getter(getter(CommonControlFilter::objectives))
            .setter(setter(Builder::objectives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objectives").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectiveResourceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectiveResourceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTIVES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ObjectiveResourceFilter> objectives;

    private CommonControlFilter(BuilderImpl builder) {
        this.objectives = builder.objectives;
    }

    /**
     * For responses, this returns true if the service returned a value for the Objectives property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjectives() {
        return objectives != null && !(objectives instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The objective that's used as filter criteria.
     * </p>
     * <p>
     * You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
     * <code>CommonControlFilter</code> isn’t currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectives} method.
     * </p>
     * 
     * @return The objective that's used as filter criteria.</p>
     *         <p>
     *         You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
     *         <code>CommonControlFilter</code> isn’t currently supported.
     */
    public final List<ObjectiveResourceFilter> objectives() {
        return objectives;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectives() ? objectives() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonControlFilter)) {
            return false;
        }
        CommonControlFilter other = (CommonControlFilter) obj;
        return hasObjectives() == other.hasObjectives() && Objects.equals(objectives(), other.objectives());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommonControlFilter").add("Objectives", hasObjectives() ? objectives() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Objectives":
            return Optional.ofNullable(clazz.cast(objectives()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Objectives", OBJECTIVES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommonControlFilter, T> g) {
        return obj -> g.apply((CommonControlFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommonControlFilter> {
        /**
         * <p>
         * The objective that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
         * <code>CommonControlFilter</code> isn’t currently supported.
         * </p>
         * 
         * @param objectives
         *        The objective that's used as filter criteria.</p>
         *        <p>
         *        You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
         *        <code>CommonControlFilter</code> isn’t currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectives(Collection<ObjectiveResourceFilter> objectives);

        /**
         * <p>
         * The objective that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
         * <code>CommonControlFilter</code> isn’t currently supported.
         * </p>
         * 
         * @param objectives
         *        The objective that's used as filter criteria.</p>
         *        <p>
         *        You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
         *        <code>CommonControlFilter</code> isn’t currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectives(ObjectiveResourceFilter... objectives);

        /**
         * <p>
         * The objective that's used as filter criteria.
         * </p>
         * <p>
         * You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the
         * <code>CommonControlFilter</code> isn’t currently supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #objectives(List<ObjectiveResourceFilter>)}.
         * 
         * @param objectives
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectives(java.util.Collection<ObjectiveResourceFilter>)
         */
        Builder objectives(Consumer<ObjectiveResourceFilter.Builder>... objectives);
    }

    static final class BuilderImpl implements Builder {
        private List<ObjectiveResourceFilter> objectives = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommonControlFilter model) {
            objectives(model.objectives);
        }

        public final List<ObjectiveResourceFilter.Builder> getObjectives() {
            List<ObjectiveResourceFilter.Builder> result = ObjectiveResourceFilterListCopier.copyToBuilder(this.objectives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectives(Collection<ObjectiveResourceFilter.BuilderImpl> objectives) {
            this.objectives = ObjectiveResourceFilterListCopier.copyFromBuilder(objectives);
        }

        @Override
        public final Builder objectives(Collection<ObjectiveResourceFilter> objectives) {
            this.objectives = ObjectiveResourceFilterListCopier.copy(objectives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(ObjectiveResourceFilter... objectives) {
            objectives(Arrays.asList(objectives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(Consumer<ObjectiveResourceFilter.Builder>... objectives) {
            objectives(Stream.of(objectives).map(c -> ObjectiveResourceFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CommonControlFilter build() {
            return new CommonControlFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
