/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCostCategoryDefinitionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<DeleteCostCategoryDefinitionRequest.Builder, DeleteCostCategoryDefinitionRequest> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryArn").getter(getter(DeleteCostCategoryDefinitionRequest::costCategoryArn))
            .setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String costCategoryArn;

    private DeleteCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public final String costCategoryArn() {
        return costCategoryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCostCategoryDefinitionRequest)) {
            return false;
        }
        DeleteCostCategoryDefinitionRequest other = (DeleteCostCategoryDefinitionRequest) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCostCategoryDefinitionRequest").add("CostCategoryArn", costCategoryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CostCategoryArn", COST_CATEGORY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((DeleteCostCategoryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCostCategoryDefinitionRequest> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String costCategoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCostCategoryDefinitionRequest model) {
            super(model);
            costCategoryArn(model.costCategoryArn);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCostCategoryDefinitionRequest build() {
            return new DeleteCostCategoryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
