/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EBS field that contains a list of EBS metrics that are associated with the current instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EBSResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<EBSResourceUtilization.Builder, EBSResourceUtilization> {
    private static final SdkField<String> EBS_READ_OPS_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsReadOpsPerSecond").getter(getter(EBSResourceUtilization::ebsReadOpsPerSecond))
            .setter(setter(Builder::ebsReadOpsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsReadOpsPerSecond").build())
            .build();

    private static final SdkField<String> EBS_WRITE_OPS_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsWriteOpsPerSecond").getter(getter(EBSResourceUtilization::ebsWriteOpsPerSecond))
            .setter(setter(Builder::ebsWriteOpsPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsWriteOpsPerSecond").build())
            .build();

    private static final SdkField<String> EBS_READ_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsReadBytesPerSecond").getter(getter(EBSResourceUtilization::ebsReadBytesPerSecond))
            .setter(setter(Builder::ebsReadBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsReadBytesPerSecond").build())
            .build();

    private static final SdkField<String> EBS_WRITE_BYTES_PER_SECOND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsWriteBytesPerSecond").getter(getter(EBSResourceUtilization::ebsWriteBytesPerSecond))
            .setter(setter(Builder::ebsWriteBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsWriteBytesPerSecond").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_READ_OPS_PER_SECOND_FIELD,
            EBS_WRITE_OPS_PER_SECOND_FIELD, EBS_READ_BYTES_PER_SECOND_FIELD, EBS_WRITE_BYTES_PER_SECOND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ebsReadOpsPerSecond;

    private final String ebsWriteOpsPerSecond;

    private final String ebsReadBytesPerSecond;

    private final String ebsWriteBytesPerSecond;

    private EBSResourceUtilization(BuilderImpl builder) {
        this.ebsReadOpsPerSecond = builder.ebsReadOpsPerSecond;
        this.ebsWriteOpsPerSecond = builder.ebsWriteOpsPerSecond;
        this.ebsReadBytesPerSecond = builder.ebsReadBytesPerSecond;
        this.ebsWriteBytesPerSecond = builder.ebsWriteBytesPerSecond;
    }

    /**
     * <p>
     * The maximum number of read operations per second.
     * </p>
     * 
     * @return The maximum number of read operations per second.
     */
    public final String ebsReadOpsPerSecond() {
        return ebsReadOpsPerSecond;
    }

    /**
     * <p>
     * The maximum number of write operations per second.
     * </p>
     * 
     * @return The maximum number of write operations per second.
     */
    public final String ebsWriteOpsPerSecond() {
        return ebsWriteOpsPerSecond;
    }

    /**
     * <p>
     * The maximum size of read operations per second
     * </p>
     * 
     * @return The maximum size of read operations per second
     */
    public final String ebsReadBytesPerSecond() {
        return ebsReadBytesPerSecond;
    }

    /**
     * <p>
     * The maximum size of write operations per second.
     * </p>
     * 
     * @return The maximum size of write operations per second.
     */
    public final String ebsWriteBytesPerSecond() {
        return ebsWriteBytesPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsReadOpsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(ebsWriteOpsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(ebsReadBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(ebsWriteBytesPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSResourceUtilization)) {
            return false;
        }
        EBSResourceUtilization other = (EBSResourceUtilization) obj;
        return Objects.equals(ebsReadOpsPerSecond(), other.ebsReadOpsPerSecond())
                && Objects.equals(ebsWriteOpsPerSecond(), other.ebsWriteOpsPerSecond())
                && Objects.equals(ebsReadBytesPerSecond(), other.ebsReadBytesPerSecond())
                && Objects.equals(ebsWriteBytesPerSecond(), other.ebsWriteBytesPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EBSResourceUtilization").add("EbsReadOpsPerSecond", ebsReadOpsPerSecond())
                .add("EbsWriteOpsPerSecond", ebsWriteOpsPerSecond()).add("EbsReadBytesPerSecond", ebsReadBytesPerSecond())
                .add("EbsWriteBytesPerSecond", ebsWriteBytesPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsReadOpsPerSecond":
            return Optional.ofNullable(clazz.cast(ebsReadOpsPerSecond()));
        case "EbsWriteOpsPerSecond":
            return Optional.ofNullable(clazz.cast(ebsWriteOpsPerSecond()));
        case "EbsReadBytesPerSecond":
            return Optional.ofNullable(clazz.cast(ebsReadBytesPerSecond()));
        case "EbsWriteBytesPerSecond":
            return Optional.ofNullable(clazz.cast(ebsWriteBytesPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EbsReadOpsPerSecond", EBS_READ_OPS_PER_SECOND_FIELD);
        map.put("EbsWriteOpsPerSecond", EBS_WRITE_OPS_PER_SECOND_FIELD);
        map.put("EbsReadBytesPerSecond", EBS_READ_BYTES_PER_SECOND_FIELD);
        map.put("EbsWriteBytesPerSecond", EBS_WRITE_BYTES_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSResourceUtilization, T> g) {
        return obj -> g.apply((EBSResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EBSResourceUtilization> {
        /**
         * <p>
         * The maximum number of read operations per second.
         * </p>
         * 
         * @param ebsReadOpsPerSecond
         *        The maximum number of read operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsReadOpsPerSecond(String ebsReadOpsPerSecond);

        /**
         * <p>
         * The maximum number of write operations per second.
         * </p>
         * 
         * @param ebsWriteOpsPerSecond
         *        The maximum number of write operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsWriteOpsPerSecond(String ebsWriteOpsPerSecond);

        /**
         * <p>
         * The maximum size of read operations per second
         * </p>
         * 
         * @param ebsReadBytesPerSecond
         *        The maximum size of read operations per second
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsReadBytesPerSecond(String ebsReadBytesPerSecond);

        /**
         * <p>
         * The maximum size of write operations per second.
         * </p>
         * 
         * @param ebsWriteBytesPerSecond
         *        The maximum size of write operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsWriteBytesPerSecond(String ebsWriteBytesPerSecond);
    }

    static final class BuilderImpl implements Builder {
        private String ebsReadOpsPerSecond;

        private String ebsWriteOpsPerSecond;

        private String ebsReadBytesPerSecond;

        private String ebsWriteBytesPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSResourceUtilization model) {
            ebsReadOpsPerSecond(model.ebsReadOpsPerSecond);
            ebsWriteOpsPerSecond(model.ebsWriteOpsPerSecond);
            ebsReadBytesPerSecond(model.ebsReadBytesPerSecond);
            ebsWriteBytesPerSecond(model.ebsWriteBytesPerSecond);
        }

        public final String getEbsReadOpsPerSecond() {
            return ebsReadOpsPerSecond;
        }

        public final void setEbsReadOpsPerSecond(String ebsReadOpsPerSecond) {
            this.ebsReadOpsPerSecond = ebsReadOpsPerSecond;
        }

        @Override
        public final Builder ebsReadOpsPerSecond(String ebsReadOpsPerSecond) {
            this.ebsReadOpsPerSecond = ebsReadOpsPerSecond;
            return this;
        }

        public final String getEbsWriteOpsPerSecond() {
            return ebsWriteOpsPerSecond;
        }

        public final void setEbsWriteOpsPerSecond(String ebsWriteOpsPerSecond) {
            this.ebsWriteOpsPerSecond = ebsWriteOpsPerSecond;
        }

        @Override
        public final Builder ebsWriteOpsPerSecond(String ebsWriteOpsPerSecond) {
            this.ebsWriteOpsPerSecond = ebsWriteOpsPerSecond;
            return this;
        }

        public final String getEbsReadBytesPerSecond() {
            return ebsReadBytesPerSecond;
        }

        public final void setEbsReadBytesPerSecond(String ebsReadBytesPerSecond) {
            this.ebsReadBytesPerSecond = ebsReadBytesPerSecond;
        }

        @Override
        public final Builder ebsReadBytesPerSecond(String ebsReadBytesPerSecond) {
            this.ebsReadBytesPerSecond = ebsReadBytesPerSecond;
            return this;
        }

        public final String getEbsWriteBytesPerSecond() {
            return ebsWriteBytesPerSecond;
        }

        public final void setEbsWriteBytesPerSecond(String ebsWriteBytesPerSecond) {
            this.ebsWriteBytesPerSecond = ebsWriteBytesPerSecond;
        }

        @Override
        public final Builder ebsWriteBytesPerSecond(String ebsWriteBytesPerSecond) {
            this.ebsWriteBytesPerSecond = ebsWriteBytesPerSecond;
            return this;
        }

        @Override
        public EBSResourceUtilization build() {
            return new EBSResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
