/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The forecast that's created for your query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastResult implements SdkPojo, Serializable, ToCopyableBuilder<ForecastResult.Builder, ForecastResult> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(ForecastResult::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> MEAN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeanValue").getter(getter(ForecastResult::meanValue)).setter(setter(Builder::meanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeanValue").build()).build();

    private static final SdkField<String> PREDICTION_INTERVAL_LOWER_BOUND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictionIntervalLowerBound")
            .getter(getter(ForecastResult::predictionIntervalLowerBound))
            .setter(setter(Builder::predictionIntervalLowerBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalLowerBound")
                    .build()).build();

    private static final SdkField<String> PREDICTION_INTERVAL_UPPER_BOUND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictionIntervalUpperBound")
            .getter(getter(ForecastResult::predictionIntervalUpperBound))
            .setter(setter(Builder::predictionIntervalUpperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalUpperBound")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            MEAN_VALUE_FIELD, PREDICTION_INTERVAL_LOWER_BOUND_FIELD, PREDICTION_INTERVAL_UPPER_BOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateInterval timePeriod;

    private final String meanValue;

    private final String predictionIntervalLowerBound;

    private final String predictionIntervalUpperBound;

    private ForecastResult(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.meanValue = builder.meanValue;
        this.predictionIntervalLowerBound = builder.predictionIntervalLowerBound;
        this.predictionIntervalUpperBound = builder.predictionIntervalUpperBound;
    }

    /**
     * <p>
     * The period of time that the forecast covers.
     * </p>
     * 
     * @return The period of time that the forecast covers.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The mean value of the forecast.
     * </p>
     * 
     * @return The mean value of the forecast.
     */
    public final String meanValue() {
        return meanValue;
    }

    /**
     * <p>
     * The lower limit for the prediction interval.
     * </p>
     * 
     * @return The lower limit for the prediction interval.
     */
    public final String predictionIntervalLowerBound() {
        return predictionIntervalLowerBound;
    }

    /**
     * <p>
     * The upper limit for the prediction interval.
     * </p>
     * 
     * @return The upper limit for the prediction interval.
     */
    public final String predictionIntervalUpperBound() {
        return predictionIntervalUpperBound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(meanValue());
        hashCode = 31 * hashCode + Objects.hashCode(predictionIntervalLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(predictionIntervalUpperBound());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastResult)) {
            return false;
        }
        ForecastResult other = (ForecastResult) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && Objects.equals(meanValue(), other.meanValue())
                && Objects.equals(predictionIntervalLowerBound(), other.predictionIntervalLowerBound())
                && Objects.equals(predictionIntervalUpperBound(), other.predictionIntervalUpperBound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastResult").add("TimePeriod", timePeriod()).add("MeanValue", meanValue())
                .add("PredictionIntervalLowerBound", predictionIntervalLowerBound())
                .add("PredictionIntervalUpperBound", predictionIntervalUpperBound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "MeanValue":
            return Optional.ofNullable(clazz.cast(meanValue()));
        case "PredictionIntervalLowerBound":
            return Optional.ofNullable(clazz.cast(predictionIntervalLowerBound()));
        case "PredictionIntervalUpperBound":
            return Optional.ofNullable(clazz.cast(predictionIntervalUpperBound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("MeanValue", MEAN_VALUE_FIELD);
        map.put("PredictionIntervalLowerBound", PREDICTION_INTERVAL_LOWER_BOUND_FIELD);
        map.put("PredictionIntervalUpperBound", PREDICTION_INTERVAL_UPPER_BOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastResult, T> g) {
        return obj -> g.apply((ForecastResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastResult> {
        /**
         * <p>
         * The period of time that the forecast covers.
         * </p>
         * 
         * @param timePeriod
         *        The period of time that the forecast covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The period of time that the forecast covers.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The mean value of the forecast.
         * </p>
         * 
         * @param meanValue
         *        The mean value of the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meanValue(String meanValue);

        /**
         * <p>
         * The lower limit for the prediction interval.
         * </p>
         * 
         * @param predictionIntervalLowerBound
         *        The lower limit for the prediction interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionIntervalLowerBound(String predictionIntervalLowerBound);

        /**
         * <p>
         * The upper limit for the prediction interval.
         * </p>
         * 
         * @param predictionIntervalUpperBound
         *        The upper limit for the prediction interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionIntervalUpperBound(String predictionIntervalUpperBound);
    }

    static final class BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private String meanValue;

        private String predictionIntervalLowerBound;

        private String predictionIntervalUpperBound;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastResult model) {
            timePeriod(model.timePeriod);
            meanValue(model.meanValue);
            predictionIntervalLowerBound(model.predictionIntervalLowerBound);
            predictionIntervalUpperBound(model.predictionIntervalUpperBound);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getMeanValue() {
            return meanValue;
        }

        public final void setMeanValue(String meanValue) {
            this.meanValue = meanValue;
        }

        @Override
        public final Builder meanValue(String meanValue) {
            this.meanValue = meanValue;
            return this;
        }

        public final String getPredictionIntervalLowerBound() {
            return predictionIntervalLowerBound;
        }

        public final void setPredictionIntervalLowerBound(String predictionIntervalLowerBound) {
            this.predictionIntervalLowerBound = predictionIntervalLowerBound;
        }

        @Override
        public final Builder predictionIntervalLowerBound(String predictionIntervalLowerBound) {
            this.predictionIntervalLowerBound = predictionIntervalLowerBound;
            return this;
        }

        public final String getPredictionIntervalUpperBound() {
            return predictionIntervalUpperBound;
        }

        public final void setPredictionIntervalUpperBound(String predictionIntervalUpperBound) {
            this.predictionIntervalUpperBound = predictionIntervalUpperBound;
        }

        @Override
        public final Builder predictionIntervalUpperBound(String predictionIntervalUpperBound) {
            this.predictionIntervalUpperBound = predictionIntervalUpperBound;
            return this;
        }

        @Override
        public ForecastResult build() {
            return new ForecastResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
