/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the Savings Plans recommendation generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerationSummary.Builder, GenerationSummary> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(GenerationSummary::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationStatus").getter(getter(GenerationSummary::generationStatusAsString))
            .setter(setter(Builder::generationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStatus").build()).build();

    private static final SdkField<String> GENERATION_STARTED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationStartedTime").getter(getter(GenerationSummary::generationStartedTime))
            .setter(setter(Builder::generationStartedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStartedTime").build())
            .build();

    private static final SdkField<String> GENERATION_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationCompletionTime").getter(getter(GenerationSummary::generationCompletionTime))
            .setter(setter(Builder::generationCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationCompletionTime").build())
            .build();

    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCompletionTime").getter(getter(GenerationSummary::estimatedCompletionTime))
            .setter(setter(Builder::estimatedCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            GENERATION_STATUS_FIELD, GENERATION_STARTED_TIME_FIELD, GENERATION_COMPLETION_TIME_FIELD,
            ESTIMATED_COMPLETION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String generationStatus;

    private final String generationStartedTime;

    private final String generationCompletionTime;

    private final String estimatedCompletionTime;

    private GenerationSummary(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationStatus = builder.generationStatus;
        this.generationStartedTime = builder.generationStartedTime;
        this.generationCompletionTime = builder.generationCompletionTime;
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
    }

    /**
     * <p>
     * Indicates the ID for this specific recommendation.
     * </p>
     * 
     * @return Indicates the ID for this specific recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * Indicates whether the recommendation generation succeeded, is processing, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the recommendation generation succeeded, is processing, or failed.
     * @see GenerationStatus
     */
    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(generationStatus);
    }

    /**
     * <p>
     * Indicates whether the recommendation generation succeeded, is processing, or failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the recommendation generation succeeded, is processing, or failed.
     * @see GenerationStatus
     */
    public final String generationStatusAsString() {
        return generationStatus;
    }

    /**
     * <p>
     * Indicates the start time of the recommendation generation.
     * </p>
     * 
     * @return Indicates the start time of the recommendation generation.
     */
    public final String generationStartedTime() {
        return generationStartedTime;
    }

    /**
     * <p>
     * Indicates the completion time of the recommendation generation.
     * </p>
     * 
     * @return Indicates the completion time of the recommendation generation.
     */
    public final String generationCompletionTime() {
        return generationCompletionTime;
    }

    /**
     * <p>
     * Indicates the estimated time for when the recommendation generation will complete.
     * </p>
     * 
     * @return Indicates the estimated time for when the recommendation generation will complete.
     */
    public final String estimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generationStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(generationCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCompletionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationSummary)) {
            return false;
        }
        GenerationSummary other = (GenerationSummary) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(generationStatusAsString(), other.generationStatusAsString())
                && Objects.equals(generationStartedTime(), other.generationStartedTime())
                && Objects.equals(generationCompletionTime(), other.generationCompletionTime())
                && Objects.equals(estimatedCompletionTime(), other.estimatedCompletionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerationSummary").add("RecommendationId", recommendationId())
                .add("GenerationStatus", generationStatusAsString()).add("GenerationStartedTime", generationStartedTime())
                .add("GenerationCompletionTime", generationCompletionTime())
                .add("EstimatedCompletionTime", estimatedCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "GenerationStatus":
            return Optional.ofNullable(clazz.cast(generationStatusAsString()));
        case "GenerationStartedTime":
            return Optional.ofNullable(clazz.cast(generationStartedTime()));
        case "GenerationCompletionTime":
            return Optional.ofNullable(clazz.cast(generationCompletionTime()));
        case "EstimatedCompletionTime":
            return Optional.ofNullable(clazz.cast(estimatedCompletionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("GenerationStatus", GENERATION_STATUS_FIELD);
        map.put("GenerationStartedTime", GENERATION_STARTED_TIME_FIELD);
        map.put("GenerationCompletionTime", GENERATION_COMPLETION_TIME_FIELD);
        map.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerationSummary, T> g) {
        return obj -> g.apply((GenerationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerationSummary> {
        /**
         * <p>
         * Indicates the ID for this specific recommendation.
         * </p>
         * 
         * @param recommendationId
         *        Indicates the ID for this specific recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * Indicates whether the recommendation generation succeeded, is processing, or failed.
         * </p>
         * 
         * @param generationStatus
         *        Indicates whether the recommendation generation succeeded, is processing, or failed.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(String generationStatus);

        /**
         * <p>
         * Indicates whether the recommendation generation succeeded, is processing, or failed.
         * </p>
         * 
         * @param generationStatus
         *        Indicates whether the recommendation generation succeeded, is processing, or failed.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(GenerationStatus generationStatus);

        /**
         * <p>
         * Indicates the start time of the recommendation generation.
         * </p>
         * 
         * @param generationStartedTime
         *        Indicates the start time of the recommendation generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationStartedTime(String generationStartedTime);

        /**
         * <p>
         * Indicates the completion time of the recommendation generation.
         * </p>
         * 
         * @param generationCompletionTime
         *        Indicates the completion time of the recommendation generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationCompletionTime(String generationCompletionTime);

        /**
         * <p>
         * Indicates the estimated time for when the recommendation generation will complete.
         * </p>
         * 
         * @param estimatedCompletionTime
         *        Indicates the estimated time for when the recommendation generation will complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCompletionTime(String estimatedCompletionTime);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String generationStatus;

        private String generationStartedTime;

        private String generationCompletionTime;

        private String estimatedCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationSummary model) {
            recommendationId(model.recommendationId);
            generationStatus(model.generationStatus);
            generationStartedTime(model.generationStartedTime);
            generationCompletionTime(model.generationCompletionTime);
            estimatedCompletionTime(model.estimatedCompletionTime);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getGenerationStatus() {
            return generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final String getGenerationStartedTime() {
            return generationStartedTime;
        }

        public final void setGenerationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
        }

        @Override
        public final Builder generationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
            return this;
        }

        public final String getGenerationCompletionTime() {
            return generationCompletionTime;
        }

        public final void setGenerationCompletionTime(String generationCompletionTime) {
            this.generationCompletionTime = generationCompletionTime;
        }

        @Override
        public final Builder generationCompletionTime(String generationCompletionTime) {
            this.generationCompletionTime = generationCompletionTime;
            return this;
        }

        public final String getEstimatedCompletionTime() {
            return estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        @Override
        public GenerationSummary build() {
            return new GenerationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
