/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnomalyMonitorsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetAnomalyMonitorsRequest.Builder, GetAnomalyMonitorsRequest> {
    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MonitorArnList")
            .getter(getter(GetAnomalyMonitorsRequest::monitorArnList))
            .setter(setter(Builder::monitorArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetAnomalyMonitorsRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetAnomalyMonitorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_LIST_FIELD,
            NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> monitorArnList;

    private final String nextPageToken;

    private final Integer maxResults;

    private GetAnomalyMonitorsRequest(BuilderImpl builder) {
        super(builder);
        this.monitorArnList = builder.monitorArnList;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitorArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMonitorArnList() {
        return monitorArnList != null && !(monitorArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost anomaly monitor ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitorArnList} method.
     * </p>
     * 
     * @return A list of cost anomaly monitor ARNs.
     */
    public final List<String> monitorArnList() {
        return monitorArnList;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The number of entries that a paginated response contains.
     * </p>
     * 
     * @return The number of entries that a paginated response contains.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitorArnList() ? monitorArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalyMonitorsRequest)) {
            return false;
        }
        GetAnomalyMonitorsRequest other = (GetAnomalyMonitorsRequest) obj;
        return hasMonitorArnList() == other.hasMonitorArnList() && Objects.equals(monitorArnList(), other.monitorArnList())
                && Objects.equals(nextPageToken(), other.nextPageToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnomalyMonitorsRequest").add("MonitorArnList", hasMonitorArnList() ? monitorArnList() : null)
                .add("NextPageToken", nextPageToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArnList":
            return Optional.ofNullable(clazz.cast(monitorArnList()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitorArnList", MONITOR_ARN_LIST_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalyMonitorsRequest, T> g) {
        return obj -> g.apply((GetAnomalyMonitorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAnomalyMonitorsRequest> {
        /**
         * <p>
         * A list of cost anomaly monitor ARNs.
         * </p>
         * 
         * @param monitorArnList
         *        A list of cost anomaly monitor ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArnList(Collection<String> monitorArnList);

        /**
         * <p>
         * A list of cost anomaly monitor ARNs.
         * </p>
         * 
         * @param monitorArnList
         *        A list of cost anomaly monitor ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArnList(String... monitorArnList);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The number of entries that a paginated response contains.
         * </p>
         * 
         * @param maxResults
         *        The number of entries that a paginated response contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalyMonitorsRequest model) {
            super(model);
            monitorArnList(model.monitorArnList);
            nextPageToken(model.nextPageToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getMonitorArnList() {
            if (monitorArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return monitorArnList;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String... monitorArnList) {
            monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomalyMonitorsRequest build() {
            return new GetAnomalyMonitorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
