/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostCategoriesRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetCostCategoriesRequest.Builder, GetCostCategoriesRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchString").getter(getter(GetCostCategoriesRequest::searchString))
            .setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetCostCategoriesRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> COST_CATEGORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryName").getter(getter(GetCostCategoriesRequest::costCategoryName))
            .setter(setter(Builder::costCategoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryName").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetCostCategoriesRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<SortDefinition>> SORT_BY_FIELD = SdkField
            .<List<SortDefinition>> builder(MarshallingType.LIST)
            .memberName("SortBy")
            .getter(getter(GetCostCategoriesRequest::sortBy))
            .setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingViewArn").getter(getter(GetCostCategoriesRequest::billingViewArn))
            .setter(setter(Builder::billingViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCostCategoriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostCategoriesRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD,
            TIME_PERIOD_FIELD, COST_CATEGORY_NAME_FIELD, FILTER_FIELD, SORT_BY_FIELD, BILLING_VIEW_ARN_FIELD, MAX_RESULTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String searchString;

    private final DateInterval timePeriod;

    private final String costCategoryName;

    private final Expression filter;

    private final List<SortDefinition> sortBy;

    private final String billingViewArn;

    private final Integer maxResults;

    private final String nextPageToken;

    private GetCostCategoriesRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.costCategoryName = builder.costCategoryName;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.billingViewArn = builder.billingViewArn;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The value that you want to search the filter values for.
     * </p>
     * <p>
     * If you don't specify a <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost Category
     * names that match the <code>SearchString</code> pattern. If you specify a <code>CostCategoryName</code>,
     * <code>SearchString</code> is used to filter Cost Category values that match the <code>SearchString</code>
     * pattern.
     * </p>
     * 
     * @return The value that you want to search the filter values for.</p>
     *         <p>
     *         If you don't specify a <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost
     *         Category names that match the <code>SearchString</code> pattern. If you specify a
     *         <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost Category values that
     *         match the <code>SearchString</code> pattern.
     */
    public final String searchString() {
        return searchString;
    }

    /**
     * Returns the value of the TimePeriod property for this object.
     * 
     * @return The value of the TimePeriod property for this object.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * Returns the value of the CostCategoryName property for this object.
     * 
     * @return The value of the CostCategoryName property for this object.
     */
    public final String costCategoryName() {
        return costCategoryName;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSortBy() {
        return sortBy != null && !(sortBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value that you sort the data by.
     * </p>
     * <p>
     * The key represents the cost and usage metrics. The following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BlendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetAmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetUnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UsageQuantity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NormalizedUsageAmount</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
     * <code>DESCENDING</code>.
     * </p>
     * <p>
     * When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and <code>SearchString</code> key
     * values aren't supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortBy} method.
     * </p>
     * 
     * @return The value that you sort the data by.</p>
     *         <p>
     *         The key represents the cost and usage metrics. The following values are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BlendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetAmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetUnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UsageQuantity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NormalizedUsageAmount</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
     *         <code>DESCENDING</code>.
     *         </p>
     *         <p>
     *         When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and <code>SearchString</code>
     *         key values aren't supported.
     */
    public final List<SortDefinition> sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify which
     * particular billing view you want to interact with or retrieve information from when making API calls related to
     * Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by calling the
     * ListBillingViews API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
     *         specify which particular billing view you want to interact with or retrieve information from when making
     *         API calls related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be
     *         retrieved by calling the ListBillingViews API.
     */
    public final String billingViewArn() {
        return billingViewArn;
    }

    /**
     * <p>
     * This field is only used when the <code>SortBy</code> value is provided in the request.
     * </p>
     * <p>
     * The maximum number of objects that are returned for this request. If <code>MaxResults</code> isn't specified with
     * the <code>SortBy</code> value, the request returns 1000 results as the default value for this parameter.
     * </p>
     * <p>
     * For <code>GetCostCategories</code>, MaxResults has an upper quota of 1000.
     * </p>
     * 
     * @return This field is only used when the <code>SortBy</code> value is provided in the request.</p>
     *         <p>
     *         The maximum number of objects that are returned for this request. If <code>MaxResults</code> isn't
     *         specified with the <code>SortBy</code> value, the request returns 1000 results as the default value for
     *         this parameter.
     *         </p>
     *         <p>
     *         For <code>GetCostCategories</code>, MaxResults has an upper quota of 1000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services returns a
     * NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the
     * previous call in your next request.
     * </p>
     * 
     * @return If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services
     *         returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the
     *         NextPageToken from the previous call in your next request.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryName());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortBy() ? sortBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostCategoriesRequest)) {
            return false;
        }
        GetCostCategoriesRequest other = (GetCostCategoriesRequest) obj;
        return Objects.equals(searchString(), other.searchString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(costCategoryName(), other.costCategoryName()) && Objects.equals(filter(), other.filter())
                && hasSortBy() == other.hasSortBy() && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(billingViewArn(), other.billingViewArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostCategoriesRequest").add("SearchString", searchString()).add("TimePeriod", timePeriod())
                .add("CostCategoryName", costCategoryName()).add("Filter", filter()).add("SortBy", hasSortBy() ? sortBy() : null)
                .add("BillingViewArn", billingViewArn()).add("MaxResults", maxResults()).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "CostCategoryName":
            return Optional.ofNullable(clazz.cast(costCategoryName()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "BillingViewArn":
            return Optional.ofNullable(clazz.cast(billingViewArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchString", SEARCH_STRING_FIELD);
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("CostCategoryName", COST_CATEGORY_NAME_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostCategoriesRequest, T> g) {
        return obj -> g.apply((GetCostCategoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCostCategoriesRequest> {
        /**
         * <p>
         * The value that you want to search the filter values for.
         * </p>
         * <p>
         * If you don't specify a <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost
         * Category names that match the <code>SearchString</code> pattern. If you specify a
         * <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost Category values that match
         * the <code>SearchString</code> pattern.
         * </p>
         * 
         * @param searchString
         *        The value that you want to search the filter values for.</p>
         *        <p>
         *        If you don't specify a <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost
         *        Category names that match the <code>SearchString</code> pattern. If you specify a
         *        <code>CostCategoryName</code>, <code>SearchString</code> is used to filter Cost Category values that
         *        match the <code>SearchString</code> pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * @param timePeriod
         *        The new value for the TimePeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * Sets the value of the CostCategoryName property for this object.
         *
         * @param costCategoryName
         *        The new value for the CostCategoryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryName(String costCategoryName);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The value that you sort the data by.
         * </p>
         * <p>
         * The key represents the cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
         * <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and <code>SearchString</code> key
         * values aren't supported.
         * </p>
         * 
         * @param sortBy
         *        The value that you sort the data by.</p>
         *        <p>
         *        The key represents the cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
         *        <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and
         *        <code>SearchString</code> key values aren't supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(Collection<SortDefinition> sortBy);

        /**
         * <p>
         * The value that you sort the data by.
         * </p>
         * <p>
         * The key represents the cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
         * <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and <code>SearchString</code> key
         * values aren't supported.
         * </p>
         * 
         * @param sortBy
         *        The value that you sort the data by.</p>
         *        <p>
         *        The key represents the cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
         *        <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and
         *        <code>SearchString</code> key values aren't supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition... sortBy);

        /**
         * <p>
         * The value that you sort the data by.
         * </p>
         * <p>
         * The key represents the cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The supported key values for the <code>SortOrder</code> value are <code>ASCENDING</code> and
         * <code>DESCENDING</code>.
         * </p>
         * <p>
         * When you use the <code>SortBy</code> value, the <code>NextPageToken</code> and <code>SearchString</code> key
         * values aren't supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.SortDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costexplorer.model.SortDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.SortDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #sortBy(List<SortDefinition>)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.SortDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(java.util.Collection<SortDefinition>)
         */
        Builder sortBy(Consumer<SortDefinition.Builder>... sortBy);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify
         * which particular billing view you want to interact with or retrieve information from when making API calls
         * related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by
         * calling the ListBillingViews API.
         * </p>
         * 
         * @param billingViewArn
         *        The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
         *        specify which particular billing view you want to interact with or retrieve information from when
         *        making API calls related to Amazon Web Services Billing and Cost Management features. The
         *        BillingViewArn can be retrieved by calling the ListBillingViews API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewArn(String billingViewArn);

        /**
         * <p>
         * This field is only used when the <code>SortBy</code> value is provided in the request.
         * </p>
         * <p>
         * The maximum number of objects that are returned for this request. If <code>MaxResults</code> isn't specified
         * with the <code>SortBy</code> value, the request returns 1000 results as the default value for this parameter.
         * </p>
         * <p>
         * For <code>GetCostCategories</code>, MaxResults has an upper quota of 1000.
         * </p>
         * 
         * @param maxResults
         *        This field is only used when the <code>SortBy</code> value is provided in the request.</p>
         *        <p>
         *        The maximum number of objects that are returned for this request. If <code>MaxResults</code> isn't
         *        specified with the <code>SortBy</code> value, the request returns 1000 results as the default value
         *        for this parameter.
         *        </p>
         *        <p>
         *        For <code>GetCostCategories</code>, MaxResults has an upper quota of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services
         * returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the
         * NextPageToken from the previous call in your next request.
         * </p>
         * 
         * @param nextPageToken
         *        If the number of objects that are still available for retrieval exceeds the quota, Amazon Web Services
         *        returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the
         *        NextPageToken from the previous call in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String searchString;

        private DateInterval timePeriod;

        private String costCategoryName;

        private Expression filter;

        private List<SortDefinition> sortBy = DefaultSdkAutoConstructList.getInstance();

        private String billingViewArn;

        private Integer maxResults;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostCategoriesRequest model) {
            super(model);
            searchString(model.searchString);
            timePeriod(model.timePeriod);
            costCategoryName(model.costCategoryName);
            filter(model.filter);
            sortBy(model.sortBy);
            billingViewArn(model.billingViewArn);
            maxResults(model.maxResults);
            nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getCostCategoryName() {
            return costCategoryName;
        }

        public final void setCostCategoryName(String costCategoryName) {
            this.costCategoryName = costCategoryName;
        }

        @Override
        public final Builder costCategoryName(String costCategoryName) {
            this.costCategoryName = costCategoryName;
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final List<SortDefinition.Builder> getSortBy() {
            List<SortDefinition.Builder> result = SortDefinitionsCopier.copyToBuilder(this.sortBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortBy(Collection<SortDefinition.BuilderImpl> sortBy) {
            this.sortBy = SortDefinitionsCopier.copyFromBuilder(sortBy);
        }

        @Override
        public final Builder sortBy(Collection<SortDefinition> sortBy) {
            this.sortBy = SortDefinitionsCopier.copy(sortBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(SortDefinition... sortBy) {
            sortBy(Arrays.asList(sortBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(Consumer<SortDefinition.Builder>... sortBy) {
            sortBy(Stream.of(sortBy).map(c -> SortDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBillingViewArn() {
            return billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostCategoriesRequest build() {
            return new GetCostCategoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
