/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansCoverageRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetSavingsPlansCoverageRequest.Builder, GetSavingsPlansCoverageRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetSavingsPlansCoverageRequest::timePeriod))
            .setter(setter(Builder::timePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField
            .<List<GroupDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetSavingsPlansCoverageRequest::groupBy))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetSavingsPlansCoverageRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetSavingsPlansCoverageRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(GetSavingsPlansCoverageRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSavingsPlansCoverageRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetSavingsPlansCoverageRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(GetSavingsPlansCoverageRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(SortDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            GROUP_BY_FIELD, GRANULARITY_FIELD, FILTER_FIELD, METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DateInterval timePeriod;

    private final List<GroupDefinition> groupBy;

    private final String granularity;

    private final Expression filter;

    private final List<String> metrics;

    private final String nextToken;

    private final Integer maxResults;

    private final SortDefinition sortBy;

    private GetSavingsPlansCoverageRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The
     * <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't
     * be used as an <code>End</code> date.
     * </p>
     * 
     * @return The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
     *         months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date.
     *         Future dates can't be used as an <code>End</code> date.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
     * <code>SERVICE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
     *         <code>SERVICE</code>.
     */
    public final List<GroupDefinition> groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be
     * set if <code>GroupBy</code> is set.
     * </p>
     * <p>
     * The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> 
     *         can't be set if <code>GroupBy</code> is set.</p>
     *         <p>
     *         The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be
     * set if <code>GroupBy</code> is set.
     * </p>
     * <p>
     * The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> 
     *         can't be set if <code>GroupBy</code> is set.</p>
     *         <p>
     *         The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following
     * dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>GetSavingsPlansCoverage</code> uses the same <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object as the other operations, but only <code>AND</code> is supported among each dimension. If there are
     * multiple values for a dimension, they are OR'd together.
     * </p>
     * <p>
     * Cost category is also supported.
     * </p>
     * 
     * @return Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the
     *         following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINKED_ACCOUNT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_FAMILY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>GetSavingsPlansCoverage</code> uses the same <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
     *         dimension. If there are multiple values for a dimension, they are OR'd together.
     *         </p>
     *         <p>
     *         Cost category is also supported.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The measurement that you want your Savings Plans coverage reported in. The only valid value is
     * <code>SpendCoveredBySavingsPlans</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The measurement that you want your Savings Plans coverage reported in. The only valid value is
     *         <code>SpendCoveredBySavingsPlans</code>.
     */
    public final List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
     * <code>1</code>.
     * </p>
     * 
     * @return The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
     *         <code>1</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The value that you want to sort the data by.
     * </p>
     * <p>
     * The following values are supported for <code>Key</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SpendCoveredBySavingsPlan</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OnDemandCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CoveragePercentage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InstanceFamily</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Region</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Service</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The supported values for <code>SortOrder</code> are <code>ASCENDING</code> and <code>DESCENDING</code>.
     * </p>
     * 
     * @return The value that you want to sort the data by.</p>
     *         <p>
     *         The following values are supported for <code>Key</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SpendCoveredBySavingsPlan</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OnDemandCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CoveragePercentage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TotalCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InstanceFamily</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Region</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Service</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The supported values for <code>SortOrder</code> are <code>ASCENDING</code> and <code>DESCENDING</code>.
     */
    public final SortDefinition sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansCoverageRequest)) {
            return false;
        }
        GetSavingsPlansCoverageRequest other = (GetSavingsPlansCoverageRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && hasGroupBy() == other.hasGroupBy()
                && Objects.equals(groupBy(), other.groupBy())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlansCoverageRequest").add("TimePeriod", timePeriod())
                .add("GroupBy", hasGroupBy() ? groupBy() : null).add("Granularity", granularityAsString())
                .add("Filter", filter()).add("Metrics", hasMetrics() ? metrics() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansCoverageRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansCoverageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansCoverageRequest> {
        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * 
         * @param timePeriod
         *        The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
         *        months. The <code>End</code> date must be after the <code>Start</code> date, and before the current
         *        date. Future dates can't be used as an <code>End</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
         * <code>SERVICE</code>.
         * </p>
         * 
         * @param groupBy
         *        You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
         *        <code>SERVICE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupDefinition> groupBy);

        /**
         * <p>
         * You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
         * <code>SERVICE</code>.
         * </p>
         * 
         * @param groupBy
         *        You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
         *        <code>SERVICE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupDefinition... groupBy);

        /**
         * <p>
         * You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or
         * <code>SERVICE</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #groupBy(List<GroupDefinition>)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(java.util.Collection<GroupDefinition>)
         */
        Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy);

        /**
         * <p>
         * The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't
         * be set if <code>GroupBy</code> is set.
         * </p>
         * <p>
         * The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code>
         *        can't be set if <code>GroupBy</code> is set.</p>
         *        <p>
         *        The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't
         * be set if <code>GroupBy</code> is set.
         * </p>
         * <p>
         * The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code>
         *        can't be set if <code>GroupBy</code> is set.</p>
         *        <p>
         *        The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the
         * following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansCoverage</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension. If there are
         * multiple values for a dimension, they are OR'd together.
         * </p>
         * <p>
         * Cost category is also supported.
         * </p>
         * 
         * @param filter
         *        Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with
         *        the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINKED_ACCOUNT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_FAMILY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>GetSavingsPlansCoverage</code> uses the same <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
         *        dimension. If there are multiple values for a dimension, they are OR'd together.
         *        </p>
         *        <p>
         *        Cost category is also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the
         * following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansCoverage</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension. If there are
         * multiple values for a dimension, they are OR'd together.
         * </p>
         * <p>
         * Cost category is also supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The measurement that you want your Savings Plans coverage reported in. The only valid value is
         * <code>SpendCoveredBySavingsPlans</code>.
         * </p>
         * 
         * @param metrics
         *        The measurement that you want your Savings Plans coverage reported in. The only valid value is
         *        <code>SpendCoveredBySavingsPlans</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * The measurement that you want your Savings Plans coverage reported in. The only valid value is
         * <code>SpendCoveredBySavingsPlans</code>.
         * </p>
         * 
         * @param metrics
         *        The measurement that you want your Savings Plans coverage reported in. The only valid value is
         *        <code>SpendCoveredBySavingsPlans</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of
         * <code>1</code>.
         * </p>
         * 
         * @param maxResults
         *        The number of items to be returned in a response. The default is <code>20</code>, with a minimum value
         *        of <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The value that you want to sort the data by.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SpendCoveredBySavingsPlan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoveragePercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InstanceFamily</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Region</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Service</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The supported values for <code>SortOrder</code> are <code>ASCENDING</code> and <code>DESCENDING</code>.
         * </p>
         * 
         * @param sortBy
         *        The value that you want to sort the data by.</p>
         *        <p>
         *        The following values are supported for <code>Key</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SpendCoveredBySavingsPlan</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OnDemandCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CoveragePercentage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TotalCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InstanceFamily</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Region</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Service</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The supported values for <code>SortOrder</code> are <code>ASCENDING</code> and <code>DESCENDING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition sortBy);

        /**
         * <p>
         * The value that you want to sort the data by.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SpendCoveredBySavingsPlan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoveragePercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InstanceFamily</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Region</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Service</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The supported values for <code>SortOrder</code> are <code>ASCENDING</code> and <code>DESCENDING</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortDefinition.Builder} avoiding the need
         * to create one manually via {@link SortDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(SortDefinition)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SortDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SortDefinition)
         */
        default Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return sortBy(SortDefinition.builder().applyMutation(sortBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();

        private String granularity;

        private Expression filter;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private SortDefinition sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansCoverageRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            groupBy(model.groupBy);
            granularity(model.granularity);
            filter(model.filter);
            metrics(model.metrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortBy(model.sortBy);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy) {
            groupBy(Stream.of(groupBy).map(c -> GroupDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SortDefinition.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansCoverageRequest build() {
            return new GetSavingsPlansCoverageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
