/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetSavingsPlansUtilizationResponse.Builder, GetSavingsPlansUtilizationResponse> {
    private static final SdkField<List<SavingsPlansUtilizationByTime>> SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD = SdkField
            .<List<SavingsPlansUtilizationByTime>> builder(MarshallingType.LIST)
            .memberName("SavingsPlansUtilizationsByTime")
            .getter(getter(GetSavingsPlansUtilizationResponse::savingsPlansUtilizationsByTime))
            .setter(setter(Builder::savingsPlansUtilizationsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansUtilizationsByTime")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlansUtilizationByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlansUtilizationByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SavingsPlansUtilizationAggregates> TOTAL_FIELD = SdkField
            .<SavingsPlansUtilizationAggregates> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(GetSavingsPlansUtilizationResponse::total)).setter(setter(Builder::total))
            .constructor(SavingsPlansUtilizationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime;

    private final SavingsPlansUtilizationAggregates total;

    private GetSavingsPlansUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansUtilizationsByTime = builder.savingsPlansUtilizationsByTime;
        this.total = builder.total;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlansUtilizationsByTime property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSavingsPlansUtilizationsByTime() {
        return savingsPlansUtilizationsByTime != null && !(savingsPlansUtilizationsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlansUtilizationsByTime} method.
     * </p>
     * 
     * @return The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
     */
    public final List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime() {
        return savingsPlansUtilizationsByTime;
    }

    /**
     * <p>
     * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
     * </p>
     * 
     * @return The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
     */
    public final SavingsPlansUtilizationAggregates total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSavingsPlansUtilizationsByTime() ? savingsPlansUtilizationsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationResponse)) {
            return false;
        }
        GetSavingsPlansUtilizationResponse other = (GetSavingsPlansUtilizationResponse) obj;
        return hasSavingsPlansUtilizationsByTime() == other.hasSavingsPlansUtilizationsByTime()
                && Objects.equals(savingsPlansUtilizationsByTime(), other.savingsPlansUtilizationsByTime())
                && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetSavingsPlansUtilizationResponse")
                .add("SavingsPlansUtilizationsByTime",
                        hasSavingsPlansUtilizationsByTime() ? savingsPlansUtilizationsByTime() : null).add("Total", total())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansUtilizationsByTime":
            return Optional.ofNullable(clazz.cast(savingsPlansUtilizationsByTime()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SavingsPlansUtilizationsByTime", SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD);
        map.put("Total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationResponse> {
        /**
         * <p>
         * The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
         * </p>
         * 
         * @param savingsPlansUtilizationsByTime
         *        The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationsByTime(Collection<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
         * </p>
         * 
         * @param savingsPlansUtilizationsByTime
         *        The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime... savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The amount of cost/commitment that you used your Savings Plans. You can use it to specify date ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #savingsPlansUtilizationsByTime(List<SavingsPlansUtilizationByTime>)}.
         * 
         * @param savingsPlansUtilizationsByTime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationByTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansUtilizationsByTime(java.util.Collection<SavingsPlansUtilizationByTime>)
         */
        Builder savingsPlansUtilizationsByTime(Consumer<SavingsPlansUtilizationByTime.Builder>... savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * </p>
         * 
         * @param total
         *        The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(SavingsPlansUtilizationAggregates total);

        /**
         * <p>
         * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SavingsPlansUtilizationAggregates.Builder} avoiding the need to create one manually via
         * {@link SavingsPlansUtilizationAggregates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansUtilizationAggregates.Builder#build()} is called
         * immediately and its result is passed to {@link #total(SavingsPlansUtilizationAggregates)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link SavingsPlansUtilizationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(SavingsPlansUtilizationAggregates)
         */
        default Builder total(Consumer<SavingsPlansUtilizationAggregates.Builder> total) {
            return total(SavingsPlansUtilizationAggregates.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime = DefaultSdkAutoConstructList.getInstance();

        private SavingsPlansUtilizationAggregates total;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationResponse model) {
            super(model);
            savingsPlansUtilizationsByTime(model.savingsPlansUtilizationsByTime);
            total(model.total);
        }

        public final List<SavingsPlansUtilizationByTime.Builder> getSavingsPlansUtilizationsByTime() {
            List<SavingsPlansUtilizationByTime.Builder> result = SavingsPlansUtilizationsByTimeCopier
                    .copyToBuilder(this.savingsPlansUtilizationsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSavingsPlansUtilizationsByTime(
                Collection<SavingsPlansUtilizationByTime.BuilderImpl> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier
                    .copyFromBuilder(savingsPlansUtilizationsByTime);
        }

        @Override
        public final Builder savingsPlansUtilizationsByTime(
                Collection<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier.copy(savingsPlansUtilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime... savingsPlansUtilizationsByTime) {
            savingsPlansUtilizationsByTime(Arrays.asList(savingsPlansUtilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(
                Consumer<SavingsPlansUtilizationByTime.Builder>... savingsPlansUtilizationsByTime) {
            savingsPlansUtilizationsByTime(Stream.of(savingsPlansUtilizationsByTime)
                    .map(c -> SavingsPlansUtilizationByTime.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SavingsPlansUtilizationAggregates.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(SavingsPlansUtilizationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(SavingsPlansUtilizationAggregates total) {
            this.total = total;
            return this;
        }

        @Override
        public GetSavingsPlansUtilizationResponse build() {
            return new GetSavingsPlansUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
