/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSavingsPlansPurchaseRecommendationGenerationResponse extends CostExplorerResponse
        implements
        ToCopyableBuilder<ListSavingsPlansPurchaseRecommendationGenerationResponse.Builder, ListSavingsPlansPurchaseRecommendationGenerationResponse> {
    private static final SdkField<List<GenerationSummary>> GENERATION_SUMMARY_LIST_FIELD = SdkField
            .<List<GenerationSummary>> builder(MarshallingType.LIST)
            .memberName("GenerationSummaryList")
            .getter(getter(ListSavingsPlansPurchaseRecommendationGenerationResponse::generationSummaryList))
            .setter(setter(Builder::generationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GenerationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GenerationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListSavingsPlansPurchaseRecommendationGenerationResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_SUMMARY_LIST_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GenerationSummary> generationSummaryList;

    private final String nextPageToken;

    private ListSavingsPlansPurchaseRecommendationGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.generationSummaryList = builder.generationSummaryList;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GenerationSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGenerationSummaryList() {
        return generationSummaryList != null && !(generationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of historical recommendation generations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGenerationSummaryList} method.
     * </p>
     * 
     * @return The list of historical recommendation generations.
     */
    public final List<GenerationSummary> generationSummaryList() {
        return generationSummaryList;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGenerationSummaryList() ? generationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSavingsPlansPurchaseRecommendationGenerationResponse)) {
            return false;
        }
        ListSavingsPlansPurchaseRecommendationGenerationResponse other = (ListSavingsPlansPurchaseRecommendationGenerationResponse) obj;
        return hasGenerationSummaryList() == other.hasGenerationSummaryList()
                && Objects.equals(generationSummaryList(), other.generationSummaryList())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSavingsPlansPurchaseRecommendationGenerationResponse")
                .add("GenerationSummaryList", hasGenerationSummaryList() ? generationSummaryList() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GenerationSummaryList":
            return Optional.ofNullable(clazz.cast(generationSummaryList()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GenerationSummaryList", GENERATION_SUMMARY_LIST_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSavingsPlansPurchaseRecommendationGenerationResponse, T> g) {
        return obj -> g.apply((ListSavingsPlansPurchaseRecommendationGenerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationResponse> {
        /**
         * <p>
         * The list of historical recommendation generations.
         * </p>
         * 
         * @param generationSummaryList
         *        The list of historical recommendation generations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationSummaryList(Collection<GenerationSummary> generationSummaryList);

        /**
         * <p>
         * The list of historical recommendation generations.
         * </p>
         * 
         * @param generationSummaryList
         *        The list of historical recommendation generations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationSummaryList(GenerationSummary... generationSummaryList);

        /**
         * <p>
         * The list of historical recommendation generations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.GenerationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.GenerationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.GenerationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #generationSummaryList(List<GenerationSummary>)}.
         * 
         * @param generationSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.GenerationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationSummaryList(java.util.Collection<GenerationSummary>)
         */
        Builder generationSummaryList(Consumer<GenerationSummary.Builder>... generationSummaryList);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<GenerationSummary> generationSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSavingsPlansPurchaseRecommendationGenerationResponse model) {
            super(model);
            generationSummaryList(model.generationSummaryList);
            nextPageToken(model.nextPageToken);
        }

        public final List<GenerationSummary.Builder> getGenerationSummaryList() {
            List<GenerationSummary.Builder> result = GenerationSummaryListCopier.copyToBuilder(this.generationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGenerationSummaryList(Collection<GenerationSummary.BuilderImpl> generationSummaryList) {
            this.generationSummaryList = GenerationSummaryListCopier.copyFromBuilder(generationSummaryList);
        }

        @Override
        public final Builder generationSummaryList(Collection<GenerationSummary> generationSummaryList) {
            this.generationSummaryList = GenerationSummaryListCopier.copy(generationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaryList(GenerationSummary... generationSummaryList) {
            generationSummaryList(Arrays.asList(generationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaryList(Consumer<GenerationSummary.Builder>... generationSummaryList) {
            generationSummaryList(Stream.of(generationSummaryList).map(c -> GenerationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListSavingsPlansPurchaseRecommendationGenerationResponse build() {
            return new ListSavingsPlansPurchaseRecommendationGenerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
