/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvideAnomalyFeedbackRequest extends CostExplorerRequest implements
        ToCopyableBuilder<ProvideAnomalyFeedbackRequest.Builder, ProvideAnomalyFeedbackRequest> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyId").getter(getter(ProvideAnomalyFeedbackRequest::anomalyId)).setter(setter(Builder::anomalyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyId").build()).build();

    private static final SdkField<String> FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Feedback").getter(getter(ProvideAnomalyFeedbackRequest::feedbackAsString))
            .setter(setter(Builder::feedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD,
            FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anomalyId;

    private final String feedback;

    private ProvideAnomalyFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyId = builder.anomalyId;
        this.feedback = builder.feedback;
    }

    /**
     * <p>
     * A cost anomaly ID.
     * </p>
     * 
     * @return A cost anomaly ID.
     */
    public final String anomalyId() {
        return anomalyId;
    }

    /**
     * <p>
     * Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link AnomalyFeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
     * @see AnomalyFeedbackType
     */
    public final AnomalyFeedbackType feedback() {
        return AnomalyFeedbackType.fromValue(feedback);
    }

    /**
     * <p>
     * Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link AnomalyFeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
     * @see AnomalyFeedbackType
     */
    public final String feedbackAsString() {
        return feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvideAnomalyFeedbackRequest)) {
            return false;
        }
        ProvideAnomalyFeedbackRequest other = (ProvideAnomalyFeedbackRequest) obj;
        return Objects.equals(anomalyId(), other.anomalyId()) && Objects.equals(feedbackAsString(), other.feedbackAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvideAnomalyFeedbackRequest").add("AnomalyId", anomalyId())
                .add("Feedback", feedbackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyId":
            return Optional.ofNullable(clazz.cast(anomalyId()));
        case "Feedback":
            return Optional.ofNullable(clazz.cast(feedbackAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnomalyId", ANOMALY_ID_FIELD);
        map.put("Feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvideAnomalyFeedbackRequest, T> g) {
        return obj -> g.apply((ProvideAnomalyFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ProvideAnomalyFeedbackRequest> {
        /**
         * <p>
         * A cost anomaly ID.
         * </p>
         * 
         * @param anomalyId
         *        A cost anomaly ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyId(String anomalyId);

        /**
         * <p>
         * Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
         * </p>
         * 
         * @param feedback
         *        Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
         * @see AnomalyFeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyFeedbackType
         */
        Builder feedback(String feedback);

        /**
         * <p>
         * Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
         * </p>
         * 
         * @param feedback
         *        Describes whether the cost anomaly was a planned activity or you considered it an anomaly.
         * @see AnomalyFeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyFeedbackType
         */
        Builder feedback(AnomalyFeedbackType feedback);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String anomalyId;

        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvideAnomalyFeedbackRequest model) {
            super(model);
            anomalyId(model.anomalyId);
            feedback(model.feedback);
        }

        public final String getAnomalyId() {
            return anomalyId;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final String getFeedback() {
            return feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(AnomalyFeedbackType feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvideAnomalyFeedbackRequest build() {
            return new ProvideAnomalyFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
