/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details and metrics for the given recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationDetailData implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationDetailData.Builder, RecommendationDetailData> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountScope").getter(getter(RecommendationDetailData::accountScopeAsString))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackPeriodInDays").getter(getter(RecommendationDetailData::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SavingsPlansType").getter(getter(RecommendationDetailData::savingsPlansTypeAsString))
            .setter(setter(Builder::savingsPlansType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()).build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermInYears").getter(getter(RecommendationDetailData::termInYearsAsString))
            .setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(RecommendationDetailData::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RecommendationDetailData::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(RecommendationDetailData::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily").getter(getter(RecommendationDetailData::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RecommendationDetailData::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingId").getter(getter(RecommendationDetailData::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").build()).build();

    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationTimestamp").getter(getter(RecommendationDetailData::generationTimestamp))
            .setter(setter(Builder::generationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build())
            .build();

    private static final SdkField<String> LATEST_USAGE_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestUsageTimestamp").getter(getter(RecommendationDetailData::latestUsageTimestamp))
            .setter(setter(Builder::latestUsageTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUsageTimestamp").build())
            .build();

    private static final SdkField<String> CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentAverageHourlyOnDemandSpend")
            .getter(getter(RecommendationDetailData::currentAverageHourlyOnDemandSpend))
            .setter(setter(Builder::currentAverageHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentMaximumHourlyOnDemandSpend")
            .getter(getter(RecommendationDetailData::currentMaximumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMaximumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMaximumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentMinimumHourlyOnDemandSpend")
            .getter(getter(RecommendationDetailData::currentMinimumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMinimumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMinimumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_AVERAGE_UTILIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedAverageUtilization")
            .getter(getter(RecommendationDetailData::estimatedAverageUtilization))
            .setter(setter(Builder::estimatedAverageUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageUtilization")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavingsAmount")
            .getter(getter(RecommendationDetailData::estimatedMonthlySavingsAmount))
            .setter(setter(Builder::estimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCost").getter(getter(RecommendationDetailData::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build())
            .build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCostWithCurrentCommitment")
            .getter(getter(RecommendationDetailData::estimatedOnDemandCostWithCurrentCommitment))
            .setter(setter(Builder::estimatedOnDemandCostWithCurrentCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedOnDemandCostWithCurrentCommitment").build()).build();

    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedROI").getter(getter(RecommendationDetailData::estimatedROI))
            .setter(setter(Builder::estimatedROI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()).build();

    private static final SdkField<String> ESTIMATED_SP_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSPCost").getter(getter(RecommendationDetailData::estimatedSPCost))
            .setter(setter(Builder::estimatedSPCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSPCost").build()).build();

    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsAmount").getter(getter(RecommendationDetailData::estimatedSavingsAmount))
            .setter(setter(Builder::estimatedSavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build())
            .build();

    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsPercentage")
            .getter(getter(RecommendationDetailData::estimatedSavingsPercentage))
            .setter(setter(Builder::estimatedSavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build())
            .build();

    private static final SdkField<String> EXISTING_HOURLY_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExistingHourlyCommitment").getter(getter(RecommendationDetailData::existingHourlyCommitment))
            .setter(setter(Builder::existingHourlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingHourlyCommitment").build())
            .build();

    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HourlyCommitmentToPurchase")
            .getter(getter(RecommendationDetailData::hourlyCommitmentToPurchase))
            .setter(setter(Builder::hourlyCommitmentToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build())
            .build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpfrontCost").getter(getter(RecommendationDetailData::upfrontCost)).setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()).build();

    private static final SdkField<String> CURRENT_AVERAGE_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentAverageCoverage").getter(getter(RecommendationDetailData::currentAverageCoverage))
            .setter(setter(Builder::currentAverageCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageCoverage").build())
            .build();

    private static final SdkField<String> ESTIMATED_AVERAGE_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedAverageCoverage").getter(getter(RecommendationDetailData::estimatedAverageCoverage))
            .setter(setter(Builder::estimatedAverageCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageCoverage").build())
            .build();

    private static final SdkField<List<RecommendationDetailHourlyMetrics>> METRICS_OVER_LOOKBACK_PERIOD_FIELD = SdkField
            .<List<RecommendationDetailHourlyMetrics>> builder(MarshallingType.LIST)
            .memberName("MetricsOverLookbackPeriod")
            .getter(getter(RecommendationDetailData::metricsOverLookbackPeriod))
            .setter(setter(Builder::metricsOverLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsOverLookbackPeriod").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationDetailHourlyMetrics> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationDetailHourlyMetrics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            LOOKBACK_PERIOD_IN_DAYS_FIELD, SAVINGS_PLANS_TYPE_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, ACCOUNT_ID_FIELD,
            CURRENCY_CODE_FIELD, INSTANCE_FAMILY_FIELD, REGION_FIELD, OFFERING_ID_FIELD, GENERATION_TIMESTAMP_FIELD,
            LATEST_USAGE_TIMESTAMP_FIELD, CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD,
            CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD,
            ESTIMATED_AVERAGE_UTILIZATION_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, ESTIMATED_ON_DEMAND_COST_FIELD,
            ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD, ESTIMATED_ROI_FIELD, ESTIMATED_SP_COST_FIELD,
            ESTIMATED_SAVINGS_AMOUNT_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, EXISTING_HOURLY_COMMITMENT_FIELD,
            HOURLY_COMMITMENT_TO_PURCHASE_FIELD, UPFRONT_COST_FIELD, CURRENT_AVERAGE_COVERAGE_FIELD,
            ESTIMATED_AVERAGE_COVERAGE_FIELD, METRICS_OVER_LOOKBACK_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String lookbackPeriodInDays;

    private final String savingsPlansType;

    private final String termInYears;

    private final String paymentOption;

    private final String accountId;

    private final String currencyCode;

    private final String instanceFamily;

    private final String region;

    private final String offeringId;

    private final String generationTimestamp;

    private final String latestUsageTimestamp;

    private final String currentAverageHourlyOnDemandSpend;

    private final String currentMaximumHourlyOnDemandSpend;

    private final String currentMinimumHourlyOnDemandSpend;

    private final String estimatedAverageUtilization;

    private final String estimatedMonthlySavingsAmount;

    private final String estimatedOnDemandCost;

    private final String estimatedOnDemandCostWithCurrentCommitment;

    private final String estimatedROI;

    private final String estimatedSPCost;

    private final String estimatedSavingsAmount;

    private final String estimatedSavingsPercentage;

    private final String existingHourlyCommitment;

    private final String hourlyCommitmentToPurchase;

    private final String upfrontCost;

    private final String currentAverageCoverage;

    private final String estimatedAverageCoverage;

    private final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod;

    private RecommendationDetailData(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.accountId = builder.accountId;
        this.currencyCode = builder.currencyCode;
        this.instanceFamily = builder.instanceFamily;
        this.region = builder.region;
        this.offeringId = builder.offeringId;
        this.generationTimestamp = builder.generationTimestamp;
        this.latestUsageTimestamp = builder.latestUsageTimestamp;
        this.currentAverageHourlyOnDemandSpend = builder.currentAverageHourlyOnDemandSpend;
        this.currentMaximumHourlyOnDemandSpend = builder.currentMaximumHourlyOnDemandSpend;
        this.currentMinimumHourlyOnDemandSpend = builder.currentMinimumHourlyOnDemandSpend;
        this.estimatedAverageUtilization = builder.estimatedAverageUtilization;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
        this.estimatedROI = builder.estimatedROI;
        this.estimatedSPCost = builder.estimatedSPCost;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.existingHourlyCommitment = builder.existingHourlyCommitment;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.upfrontCost = builder.upfrontCost;
        this.currentAverageCoverage = builder.currentAverageCoverage;
        this.estimatedAverageCoverage = builder.estimatedAverageCoverage;
        this.metricsOverLookbackPeriod = builder.metricsOverLookbackPeriod;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     * including the management account and member accounts if the value is set to PAYER. If the value is LINKED,
     * recommendations are calculated for individual member accounts only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     *         including the management account and member accounts if the value is set to PAYER. If the value is
     *         LINKED, recommendations are calculated for individual member accounts only.
     * @see AccountScope
     */
    public final AccountScope accountScope() {
        return AccountScope.fromValue(accountScope);
    }

    /**
     * <p>
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     * including the management account and member accounts if the value is set to PAYER. If the value is LINKED,
     * recommendations are calculated for individual member accounts only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     *         including the management account and member accounts if the value is set to PAYER. If the value is
     *         LINKED, recommendations are calculated for individual member accounts only.
     * @see AccountScope
     */
    public final String accountScopeAsString() {
        return accountScope;
    }

    /**
     * <p>
     * How many days of previous usage that Amazon Web Services considers when making this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return How many days of previous usage that Amazon Web Services considers when making this recommendation.
     * @see LookbackPeriodInDays
     */
    public final LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * How many days of previous usage that Amazon Web Services considers when making this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return How many days of previous usage that Amazon Web Services considers when making this recommendation.
     * @see LookbackPeriodInDays
     */
    public final String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    /**
     * <p>
     * The requested Savings Plan recommendation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The requested Savings Plan recommendation type.
     * @see SupportedSavingsPlansType
     */
    public final SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(savingsPlansType);
    }

    /**
     * <p>
     * The requested Savings Plan recommendation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The requested Savings Plan recommendation type.
     * @see SupportedSavingsPlansType
     */
    public final String savingsPlansTypeAsString() {
        return savingsPlansType;
    }

    /**
     * <p>
     * The term of the commitment in years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term of the commitment in years.
     * @see TermInYears
     */
    public final TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The term of the commitment in years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term of the commitment in years.
     * @see TermInYears
     */
    public final String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The payment option for the commitment (for example, All Upfront or No Upfront).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the commitment (for example, All Upfront or No Upfront).
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the commitment (for example, All Upfront or No Upfront).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the commitment (for example, All Upfront or No Upfront).
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The AccountID that the recommendation is generated for.
     * </p>
     * 
     * @return The AccountID that the recommendation is generated for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to generate the recommendation and present potential savings.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to generate the recommendation and present potential
     *         savings.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The instance family of the recommended Savings Plan.
     * </p>
     * 
     * @return The instance family of the recommended Savings Plan.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The region the recommendation is generated for.
     * </p>
     * 
     * @return The region the recommendation is generated for.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The unique ID that's used to distinguish Savings Plans from one another.
     * </p>
     * 
     * @return The unique ID that's used to distinguish Savings Plans from one another.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * Returns the value of the GenerationTimestamp property for this object.
     * 
     * @return The value of the GenerationTimestamp property for this object.
     */
    public final String generationTimestamp() {
        return generationTimestamp;
    }

    /**
     * Returns the value of the LatestUsageTimestamp property for this object.
     * 
     * @return The value of the LatestUsageTimestamp property for this object.
     */
    public final String latestUsageTimestamp() {
        return latestUsageTimestamp;
    }

    /**
     * <p>
     * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public final String currentAverageHourlyOnDemandSpend() {
        return currentAverageHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public final String currentMaximumHourlyOnDemandSpend() {
        return currentMaximumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public final String currentMinimumHourlyOnDemandSpend() {
        return currentMinimumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The estimated utilization of the recommended Savings Plan.
     * </p>
     * 
     * @return The estimated utilization of the recommended Savings Plan.
     */
    public final String estimatedAverageUtilization() {
        return estimatedAverageUtilization;
    }

    /**
     * <p>
     * The estimated monthly savings amount based on the recommended Savings Plan.
     * </p>
     * 
     * @return The estimated monthly savings amount based on the recommended Savings Plan.
     */
    public final String estimatedMonthlySavingsAmount() {
        return estimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length of the
     * lookback period.
     * </p>
     * 
     * @return The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length
     *         of the lookback period.
     */
    public final String estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The estimated On-Demand costs you expect with no additional commitment, based on your usage of the selected time
     * period and the Savings Plan you own.
     * </p>
     * 
     * @return The estimated On-Demand costs you expect with no additional commitment, based on your usage of the
     *         selected time period and the Savings Plan you own.
     */
    public final String estimatedOnDemandCostWithCurrentCommitment() {
        return estimatedOnDemandCostWithCurrentCommitment;
    }

    /**
     * <p>
     * The estimated return on investment that's based on the recommended Savings Plan that you purchased. This is
     * calculated as estimatedSavingsAmount/estimatedSPCost*100.
     * </p>
     * 
     * @return The estimated return on investment that's based on the recommended Savings Plan that you purchased. This
     *         is calculated as estimatedSavingsAmount/estimatedSPCost*100.
     */
    public final String estimatedROI() {
        return estimatedROI;
    }

    /**
     * <p>
     * The cost of the recommended Savings Plan over the length of the lookback period.
     * </p>
     * 
     * @return The cost of the recommended Savings Plan over the length of the lookback period.
     */
    public final String estimatedSPCost() {
        return estimatedSPCost;
    }

    /**
     * <p>
     * The estimated savings amount that's based on the recommended Savings Plan over the length of the lookback period.
     * </p>
     * 
     * @return The estimated savings amount that's based on the recommended Savings Plan over the length of the lookback
     *         period.
     */
    public final String estimatedSavingsAmount() {
        return estimatedSavingsAmount;
    }

    /**
     * <p>
     * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback
     * period.
     * </p>
     * 
     * @return The estimated savings percentage relative to the total cost of applicable On-Demand usage over the
     *         lookback period.
     */
    public final String estimatedSavingsPercentage() {
        return estimatedSavingsPercentage;
    }

    /**
     * <p>
     * The existing hourly commitment for the Savings Plan type.
     * </p>
     * 
     * @return The existing hourly commitment for the Savings Plan type.
     */
    public final String existingHourlyCommitment() {
        return existingHourlyCommitment;
    }

    /**
     * <p>
     * The recommended hourly commitment level for the Savings Plan type and the configuration that's based on the usage
     * during the lookback period.
     * </p>
     * 
     * @return The recommended hourly commitment level for the Savings Plan type and the configuration that's based on
     *         the usage during the lookback period.
     */
    public final String hourlyCommitmentToPurchase() {
        return hourlyCommitmentToPurchase;
    }

    /**
     * <p>
     * The upfront cost of the recommended Savings Plan, based on the selected payment option.
     * </p>
     * 
     * @return The upfront cost of the recommended Savings Plan, based on the selected payment option.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * The average value of hourly coverage over the lookback period.
     * </p>
     * 
     * @return The average value of hourly coverage over the lookback period.
     */
    public final String currentAverageCoverage() {
        return currentAverageCoverage;
    }

    /**
     * <p>
     * The estimated coverage of the recommended Savings Plan.
     * </p>
     * 
     * @return The estimated coverage of the recommended Savings Plan.
     */
    public final String estimatedAverageCoverage() {
        return estimatedAverageCoverage;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsOverLookbackPeriod property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetricsOverLookbackPeriod() {
        return metricsOverLookbackPeriod != null && !(metricsOverLookbackPeriod instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The related hourly cost, coverage, and utilization metrics over the lookback period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsOverLookbackPeriod} method.
     * </p>
     * 
     * @return The related hourly cost, coverage, and utilization metrics over the lookback period.
     */
    public final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod() {
        return metricsOverLookbackPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(generationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestUsageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(currentAverageHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentMaximumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentMinimumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedAverageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCostWithCurrentCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSPCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(existingHourlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(currentAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsOverLookbackPeriod() ? metricsOverLookbackPeriod() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationDetailData)) {
            return false;
        }
        RecommendationDetailData other = (RecommendationDetailData) obj;
        return Objects.equals(accountScopeAsString(), other.accountScopeAsString())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString())
                && Objects.equals(savingsPlansTypeAsString(), other.savingsPlansTypeAsString())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(region(), other.region())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(generationTimestamp(), other.generationTimestamp())
                && Objects.equals(latestUsageTimestamp(), other.latestUsageTimestamp())
                && Objects.equals(currentAverageHourlyOnDemandSpend(), other.currentAverageHourlyOnDemandSpend())
                && Objects.equals(currentMaximumHourlyOnDemandSpend(), other.currentMaximumHourlyOnDemandSpend())
                && Objects.equals(currentMinimumHourlyOnDemandSpend(), other.currentMinimumHourlyOnDemandSpend())
                && Objects.equals(estimatedAverageUtilization(), other.estimatedAverageUtilization())
                && Objects.equals(estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(estimatedOnDemandCostWithCurrentCommitment(),
                        other.estimatedOnDemandCostWithCurrentCommitment())
                && Objects.equals(estimatedROI(), other.estimatedROI())
                && Objects.equals(estimatedSPCost(), other.estimatedSPCost())
                && Objects.equals(estimatedSavingsAmount(), other.estimatedSavingsAmount())
                && Objects.equals(estimatedSavingsPercentage(), other.estimatedSavingsPercentage())
                && Objects.equals(existingHourlyCommitment(), other.existingHourlyCommitment())
                && Objects.equals(hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(currentAverageCoverage(), other.currentAverageCoverage())
                && Objects.equals(estimatedAverageCoverage(), other.estimatedAverageCoverage())
                && hasMetricsOverLookbackPeriod() == other.hasMetricsOverLookbackPeriod()
                && Objects.equals(metricsOverLookbackPeriod(), other.metricsOverLookbackPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationDetailData").add("AccountScope", accountScopeAsString())
                .add("LookbackPeriodInDays", lookbackPeriodInDaysAsString()).add("SavingsPlansType", savingsPlansTypeAsString())
                .add("TermInYears", termInYearsAsString()).add("PaymentOption", paymentOptionAsString())
                .add("AccountId", accountId()).add("CurrencyCode", currencyCode()).add("InstanceFamily", instanceFamily())
                .add("Region", region()).add("OfferingId", offeringId()).add("GenerationTimestamp", generationTimestamp())
                .add("LatestUsageTimestamp", latestUsageTimestamp())
                .add("CurrentAverageHourlyOnDemandSpend", currentAverageHourlyOnDemandSpend())
                .add("CurrentMaximumHourlyOnDemandSpend", currentMaximumHourlyOnDemandSpend())
                .add("CurrentMinimumHourlyOnDemandSpend", currentMinimumHourlyOnDemandSpend())
                .add("EstimatedAverageUtilization", estimatedAverageUtilization())
                .add("EstimatedMonthlySavingsAmount", estimatedMonthlySavingsAmount())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost())
                .add("EstimatedOnDemandCostWithCurrentCommitment", estimatedOnDemandCostWithCurrentCommitment())
                .add("EstimatedROI", estimatedROI()).add("EstimatedSPCost", estimatedSPCost())
                .add("EstimatedSavingsAmount", estimatedSavingsAmount())
                .add("EstimatedSavingsPercentage", estimatedSavingsPercentage())
                .add("ExistingHourlyCommitment", existingHourlyCommitment())
                .add("HourlyCommitmentToPurchase", hourlyCommitmentToPurchase()).add("UpfrontCost", upfrontCost())
                .add("CurrentAverageCoverage", currentAverageCoverage())
                .add("EstimatedAverageCoverage", estimatedAverageCoverage())
                .add("MetricsOverLookbackPeriod", hasMetricsOverLookbackPeriod() ? metricsOverLookbackPeriod() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountScope":
            return Optional.ofNullable(clazz.cast(accountScopeAsString()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        case "SavingsPlansType":
            return Optional.ofNullable(clazz.cast(savingsPlansTypeAsString()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "GenerationTimestamp":
            return Optional.ofNullable(clazz.cast(generationTimestamp()));
        case "LatestUsageTimestamp":
            return Optional.ofNullable(clazz.cast(latestUsageTimestamp()));
        case "CurrentAverageHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentAverageHourlyOnDemandSpend()));
        case "CurrentMaximumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMaximumHourlyOnDemandSpend()));
        case "CurrentMinimumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMinimumHourlyOnDemandSpend()));
        case "EstimatedAverageUtilization":
            return Optional.ofNullable(clazz.cast(estimatedAverageUtilization()));
        case "EstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsAmount()));
        case "EstimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "EstimatedOnDemandCostWithCurrentCommitment":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCostWithCurrentCommitment()));
        case "EstimatedROI":
            return Optional.ofNullable(clazz.cast(estimatedROI()));
        case "EstimatedSPCost":
            return Optional.ofNullable(clazz.cast(estimatedSPCost()));
        case "EstimatedSavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedSavingsAmount()));
        case "EstimatedSavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedSavingsPercentage()));
        case "ExistingHourlyCommitment":
            return Optional.ofNullable(clazz.cast(existingHourlyCommitment()));
        case "HourlyCommitmentToPurchase":
            return Optional.ofNullable(clazz.cast(hourlyCommitmentToPurchase()));
        case "UpfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "CurrentAverageCoverage":
            return Optional.ofNullable(clazz.cast(currentAverageCoverage()));
        case "EstimatedAverageCoverage":
            return Optional.ofNullable(clazz.cast(estimatedAverageCoverage()));
        case "MetricsOverLookbackPeriod":
            return Optional.ofNullable(clazz.cast(metricsOverLookbackPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountScope", ACCOUNT_SCOPE_FIELD);
        map.put("LookbackPeriodInDays", LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("SavingsPlansType", SAVINGS_PLANS_TYPE_FIELD);
        map.put("TermInYears", TERM_IN_YEARS_FIELD);
        map.put("PaymentOption", PAYMENT_OPTION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("OfferingId", OFFERING_ID_FIELD);
        map.put("GenerationTimestamp", GENERATION_TIMESTAMP_FIELD);
        map.put("LatestUsageTimestamp", LATEST_USAGE_TIMESTAMP_FIELD);
        map.put("CurrentAverageHourlyOnDemandSpend", CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMaximumHourlyOnDemandSpend", CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMinimumHourlyOnDemandSpend", CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("EstimatedAverageUtilization", ESTIMATED_AVERAGE_UTILIZATION_FIELD);
        map.put("EstimatedMonthlySavingsAmount", ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        map.put("EstimatedOnDemandCostWithCurrentCommitment", ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD);
        map.put("EstimatedROI", ESTIMATED_ROI_FIELD);
        map.put("EstimatedSPCost", ESTIMATED_SP_COST_FIELD);
        map.put("EstimatedSavingsAmount", ESTIMATED_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedSavingsPercentage", ESTIMATED_SAVINGS_PERCENTAGE_FIELD);
        map.put("ExistingHourlyCommitment", EXISTING_HOURLY_COMMITMENT_FIELD);
        map.put("HourlyCommitmentToPurchase", HOURLY_COMMITMENT_TO_PURCHASE_FIELD);
        map.put("UpfrontCost", UPFRONT_COST_FIELD);
        map.put("CurrentAverageCoverage", CURRENT_AVERAGE_COVERAGE_FIELD);
        map.put("EstimatedAverageCoverage", ESTIMATED_AVERAGE_COVERAGE_FIELD);
        map.put("MetricsOverLookbackPeriod", METRICS_OVER_LOOKBACK_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationDetailData, T> g) {
        return obj -> g.apply((RecommendationDetailData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationDetailData> {
        /**
         * <p>
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
         * including the management account and member accounts if the value is set to PAYER. If the value is LINKED,
         * recommendations are calculated for individual member accounts only.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for. Amazon Web Services calculates
         *        recommendations including the management account and member accounts if the value is set to PAYER. If
         *        the value is LINKED, recommendations are calculated for individual member accounts only.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
         * including the management account and member accounts if the value is set to PAYER. If the value is LINKED,
         * recommendations are calculated for individual member accounts only.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for. Amazon Web Services calculates
         *        recommendations including the management account and member accounts if the value is set to PAYER. If
         *        the value is LINKED, recommendations are calculated for individual member accounts only.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(AccountScope accountScope);

        /**
         * <p>
         * How many days of previous usage that Amazon Web Services considers when making this recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        How many days of previous usage that Amazon Web Services considers when making this recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * How many days of previous usage that Amazon Web Services considers when making this recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        How many days of previous usage that Amazon Web Services considers when making this recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        /**
         * <p>
         * The requested Savings Plan recommendation type.
         * </p>
         * 
         * @param savingsPlansType
         *        The requested Savings Plan recommendation type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(String savingsPlansType);

        /**
         * <p>
         * The requested Savings Plan recommendation type.
         * </p>
         * 
         * @param savingsPlansType
         *        The requested Savings Plan recommendation type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType);

        /**
         * <p>
         * The term of the commitment in years.
         * </p>
         * 
         * @param termInYears
         *        The term of the commitment in years.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The term of the commitment in years.
         * </p>
         * 
         * @param termInYears
         *        The term of the commitment in years.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The payment option for the commitment (for example, All Upfront or No Upfront).
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment (for example, All Upfront or No Upfront).
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the commitment (for example, All Upfront or No Upfront).
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment (for example, All Upfront or No Upfront).
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The AccountID that the recommendation is generated for.
         * </p>
         * 
         * @param accountId
         *        The AccountID that the recommendation is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The currency code that Amazon Web Services used to generate the recommendation and present potential savings.
         * </p>
         * 
         * @param currencyCode
         *        The currency code that Amazon Web Services used to generate the recommendation and present potential
         *        savings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The instance family of the recommended Savings Plan.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The region the recommendation is generated for.
         * </p>
         * 
         * @param region
         *        The region the recommendation is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The unique ID that's used to distinguish Savings Plans from one another.
         * </p>
         * 
         * @param offeringId
         *        The unique ID that's used to distinguish Savings Plans from one another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * Sets the value of the GenerationTimestamp property for this object.
         *
         * @param generationTimestamp
         *        The new value for the GenerationTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationTimestamp(String generationTimestamp);

        /**
         * Sets the value of the LatestUsageTimestamp property for this object.
         *
         * @param latestUsageTimestamp
         *        The new value for the LatestUsageTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestUsageTimestamp(String latestUsageTimestamp);

        /**
         * <p>
         * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentAverageHourlyOnDemandSpend
         *        The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend);

        /**
         * <p>
         * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentMaximumHourlyOnDemandSpend
         *        The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend);

        /**
         * <p>
         * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentMinimumHourlyOnDemandSpend
         *        The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend);

        /**
         * <p>
         * The estimated utilization of the recommended Savings Plan.
         * </p>
         * 
         * @param estimatedAverageUtilization
         *        The estimated utilization of the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedAverageUtilization(String estimatedAverageUtilization);

        /**
         * <p>
         * The estimated monthly savings amount based on the recommended Savings Plan.
         * </p>
         * 
         * @param estimatedMonthlySavingsAmount
         *        The estimated monthly savings amount based on the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount);

        /**
         * <p>
         * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length of
         * the lookback period.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the
         *        length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(String estimatedOnDemandCost);

        /**
         * <p>
         * The estimated On-Demand costs you expect with no additional commitment, based on your usage of the selected
         * time period and the Savings Plan you own.
         * </p>
         * 
         * @param estimatedOnDemandCostWithCurrentCommitment
         *        The estimated On-Demand costs you expect with no additional commitment, based on your usage of the
         *        selected time period and the Savings Plan you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment);

        /**
         * <p>
         * The estimated return on investment that's based on the recommended Savings Plan that you purchased. This is
         * calculated as estimatedSavingsAmount/estimatedSPCost*100.
         * </p>
         * 
         * @param estimatedROI
         *        The estimated return on investment that's based on the recommended Savings Plan that you purchased.
         *        This is calculated as estimatedSavingsAmount/estimatedSPCost*100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedROI(String estimatedROI);

        /**
         * <p>
         * The cost of the recommended Savings Plan over the length of the lookback period.
         * </p>
         * 
         * @param estimatedSPCost
         *        The cost of the recommended Savings Plan over the length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSPCost(String estimatedSPCost);

        /**
         * <p>
         * The estimated savings amount that's based on the recommended Savings Plan over the length of the lookback
         * period.
         * </p>
         * 
         * @param estimatedSavingsAmount
         *        The estimated savings amount that's based on the recommended Savings Plan over the length of the
         *        lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsAmount(String estimatedSavingsAmount);

        /**
         * <p>
         * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback
         * period.
         * </p>
         * 
         * @param estimatedSavingsPercentage
         *        The estimated savings percentage relative to the total cost of applicable On-Demand usage over the
         *        lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsPercentage(String estimatedSavingsPercentage);

        /**
         * <p>
         * The existing hourly commitment for the Savings Plan type.
         * </p>
         * 
         * @param existingHourlyCommitment
         *        The existing hourly commitment for the Savings Plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingHourlyCommitment(String existingHourlyCommitment);

        /**
         * <p>
         * The recommended hourly commitment level for the Savings Plan type and the configuration that's based on the
         * usage during the lookback period.
         * </p>
         * 
         * @param hourlyCommitmentToPurchase
         *        The recommended hourly commitment level for the Savings Plan type and the configuration that's based
         *        on the usage during the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase);

        /**
         * <p>
         * The upfront cost of the recommended Savings Plan, based on the selected payment option.
         * </p>
         * 
         * @param upfrontCost
         *        The upfront cost of the recommended Savings Plan, based on the selected payment option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * The average value of hourly coverage over the lookback period.
         * </p>
         * 
         * @param currentAverageCoverage
         *        The average value of hourly coverage over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAverageCoverage(String currentAverageCoverage);

        /**
         * <p>
         * The estimated coverage of the recommended Savings Plan.
         * </p>
         * 
         * @param estimatedAverageCoverage
         *        The estimated coverage of the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedAverageCoverage(String estimatedAverageCoverage);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * 
         * @param metricsOverLookbackPeriod
         *        The related hourly cost, coverage, and utilization metrics over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * 
         * @param metricsOverLookbackPeriod
         *        The related hourly cost, coverage, and utilization metrics over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics... metricsOverLookbackPeriod);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #metricsOverLookbackPeriod(List<RecommendationDetailHourlyMetrics>)}.
         * 
         * @param metricsOverLookbackPeriod
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsOverLookbackPeriod(java.util.Collection<RecommendationDetailHourlyMetrics>)
         */
        Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder>... metricsOverLookbackPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String lookbackPeriodInDays;

        private String savingsPlansType;

        private String termInYears;

        private String paymentOption;

        private String accountId;

        private String currencyCode;

        private String instanceFamily;

        private String region;

        private String offeringId;

        private String generationTimestamp;

        private String latestUsageTimestamp;

        private String currentAverageHourlyOnDemandSpend;

        private String currentMaximumHourlyOnDemandSpend;

        private String currentMinimumHourlyOnDemandSpend;

        private String estimatedAverageUtilization;

        private String estimatedMonthlySavingsAmount;

        private String estimatedOnDemandCost;

        private String estimatedOnDemandCostWithCurrentCommitment;

        private String estimatedROI;

        private String estimatedSPCost;

        private String estimatedSavingsAmount;

        private String estimatedSavingsPercentage;

        private String existingHourlyCommitment;

        private String hourlyCommitmentToPurchase;

        private String upfrontCost;

        private String currentAverageCoverage;

        private String estimatedAverageCoverage;

        private List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationDetailData model) {
            accountScope(model.accountScope);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
            savingsPlansType(model.savingsPlansType);
            termInYears(model.termInYears);
            paymentOption(model.paymentOption);
            accountId(model.accountId);
            currencyCode(model.currencyCode);
            instanceFamily(model.instanceFamily);
            region(model.region);
            offeringId(model.offeringId);
            generationTimestamp(model.generationTimestamp);
            latestUsageTimestamp(model.latestUsageTimestamp);
            currentAverageHourlyOnDemandSpend(model.currentAverageHourlyOnDemandSpend);
            currentMaximumHourlyOnDemandSpend(model.currentMaximumHourlyOnDemandSpend);
            currentMinimumHourlyOnDemandSpend(model.currentMinimumHourlyOnDemandSpend);
            estimatedAverageUtilization(model.estimatedAverageUtilization);
            estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
            estimatedROI(model.estimatedROI);
            estimatedSPCost(model.estimatedSPCost);
            estimatedSavingsAmount(model.estimatedSavingsAmount);
            estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            existingHourlyCommitment(model.existingHourlyCommitment);
            hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            upfrontCost(model.upfrontCost);
            currentAverageCoverage(model.currentAverageCoverage);
            estimatedAverageCoverage(model.estimatedAverageCoverage);
            metricsOverLookbackPeriod(model.metricsOverLookbackPeriod);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final String getLookbackPeriodInDays() {
            return lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final String getSavingsPlansType() {
            return savingsPlansType;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final String getTermInYears() {
            return termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getGenerationTimestamp() {
            return generationTimestamp;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final String getLatestUsageTimestamp() {
            return latestUsageTimestamp;
        }

        public final void setLatestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
        }

        @Override
        public final Builder latestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
            return this;
        }

        public final String getCurrentAverageHourlyOnDemandSpend() {
            return currentAverageHourlyOnDemandSpend;
        }

        public final void setCurrentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMaximumHourlyOnDemandSpend() {
            return currentMaximumHourlyOnDemandSpend;
        }

        public final void setCurrentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMinimumHourlyOnDemandSpend() {
            return currentMinimumHourlyOnDemandSpend;
        }

        public final void setCurrentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
            return this;
        }

        public final String getEstimatedAverageUtilization() {
            return estimatedAverageUtilization;
        }

        public final void setEstimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
        }

        @Override
        public final Builder estimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return estimatedOnDemandCostWithCurrentCommitment;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        public final String getEstimatedROI() {
            return estimatedROI;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final String getEstimatedSPCost() {
            return estimatedSPCost;
        }

        public final void setEstimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
        }

        @Override
        public final Builder estimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
            return this;
        }

        public final String getEstimatedSavingsAmount() {
            return estimatedSavingsAmount;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final String getEstimatedSavingsPercentage() {
            return estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getExistingHourlyCommitment() {
            return existingHourlyCommitment;
        }

        public final void setExistingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
        }

        @Override
        public final Builder existingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
            return this;
        }

        public final String getHourlyCommitmentToPurchase() {
            return hourlyCommitmentToPurchase;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getCurrentAverageCoverage() {
            return currentAverageCoverage;
        }

        public final void setCurrentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
        }

        @Override
        public final Builder currentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
            return this;
        }

        public final String getEstimatedAverageCoverage() {
            return estimatedAverageCoverage;
        }

        public final void setEstimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
        }

        @Override
        public final Builder estimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
            return this;
        }

        public final List<RecommendationDetailHourlyMetrics.Builder> getMetricsOverLookbackPeriod() {
            List<RecommendationDetailHourlyMetrics.Builder> result = MetricsOverLookbackPeriodCopier
                    .copyToBuilder(this.metricsOverLookbackPeriod);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsOverLookbackPeriod(
                Collection<RecommendationDetailHourlyMetrics.BuilderImpl> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copyFromBuilder(metricsOverLookbackPeriod);
        }

        @Override
        public final Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copy(metricsOverLookbackPeriod);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics... metricsOverLookbackPeriod) {
            metricsOverLookbackPeriod(Arrays.asList(metricsOverLookbackPeriod));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(
                Consumer<RecommendationDetailHourlyMetrics.Builder>... metricsOverLookbackPeriod) {
            metricsOverLookbackPeriod(Stream.of(metricsOverLookbackPeriod)
                    .map(c -> RecommendationDetailHourlyMetrics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendationDetailData build() {
            return new RecommendationDetailData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
