/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dollar value of the root cause.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RootCauseImpact implements SdkPojo, Serializable, ToCopyableBuilder<RootCauseImpact.Builder, RootCauseImpact> {
    private static final SdkField<Double> CONTRIBUTION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Contribution").getter(getter(RootCauseImpact::contribution)).setter(setter(Builder::contribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contribution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRIBUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double contribution;

    private RootCauseImpact(BuilderImpl builder) {
        this.contribution = builder.contribution;
    }

    /**
     * <p>
     * The dollar amount that this root cause contributed to the anomaly's TotalImpact.
     * </p>
     * 
     * @return The dollar amount that this root cause contributed to the anomaly's TotalImpact.
     */
    public final Double contribution() {
        return contribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contribution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootCauseImpact)) {
            return false;
        }
        RootCauseImpact other = (RootCauseImpact) obj;
        return Objects.equals(contribution(), other.contribution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RootCauseImpact").add("Contribution", contribution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Contribution":
            return Optional.ofNullable(clazz.cast(contribution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Contribution", CONTRIBUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RootCauseImpact, T> g) {
        return obj -> g.apply((RootCauseImpact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RootCauseImpact> {
        /**
         * <p>
         * The dollar amount that this root cause contributed to the anomaly's TotalImpact.
         * </p>
         * 
         * @param contribution
         *        The dollar amount that this root cause contributed to the anomaly's TotalImpact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contribution(Double contribution);
    }

    static final class BuilderImpl implements Builder {
        private Double contribution;

        private BuilderImpl() {
        }

        private BuilderImpl(RootCauseImpact model) {
            contribution(model.contribution);
        }

        public final Double getContribution() {
            return contribution;
        }

        public final void setContribution(Double contribution) {
            this.contribution = contribution;
        }

        @Override
        public final Builder contribution(Double contribution) {
            this.contribution = contribution;
            return this;
        }

        @Override
        public RootCauseImpact build() {
            return new RootCauseImpact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
