/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Savings Plans purchase analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseAnalysisDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseAnalysisDetails.Builder, SavingsPlansPurchaseAnalysisDetails> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(SavingsPlansPurchaseAnalysisDetails::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_HOURS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackPeriodInHours").getter(getter(SavingsPlansPurchaseAnalysisDetails::lookbackPeriodInHours))
            .setter(setter(Builder::lookbackPeriodInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInHours").build())
            .build();

    private static final SdkField<String> CURRENT_AVERAGE_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentAverageCoverage").getter(getter(SavingsPlansPurchaseAnalysisDetails::currentAverageCoverage))
            .setter(setter(Builder::currentAverageCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageCoverage").build())
            .build();

    private static final SdkField<String> CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentAverageHourlyOnDemandSpend")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::currentAverageHourlyOnDemandSpend))
            .setter(setter(Builder::currentAverageHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentMaximumHourlyOnDemandSpend")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::currentMaximumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMaximumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMaximumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentMinimumHourlyOnDemandSpend")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::currentMinimumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMinimumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMinimumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_ON_DEMAND_SPEND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentOnDemandSpend").getter(getter(SavingsPlansPurchaseAnalysisDetails::currentOnDemandSpend))
            .setter(setter(Builder::currentOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentOnDemandSpend").build())
            .build();

    private static final SdkField<String> EXISTING_HOURLY_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExistingHourlyCommitment").getter(getter(SavingsPlansPurchaseAnalysisDetails::existingHourlyCommitment))
            .setter(setter(Builder::existingHourlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingHourlyCommitment").build())
            .build();

    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HourlyCommitmentToPurchase")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::hourlyCommitmentToPurchase))
            .setter(setter(Builder::hourlyCommitmentToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build())
            .build();

    private static final SdkField<String> ESTIMATED_AVERAGE_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedAverageCoverage").getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedAverageCoverage))
            .setter(setter(Builder::estimatedAverageCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageCoverage").build())
            .build();

    private static final SdkField<String> ESTIMATED_AVERAGE_UTILIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedAverageUtilization")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedAverageUtilization))
            .setter(setter(Builder::estimatedAverageUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageUtilization")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedMonthlySavingsAmount")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedMonthlySavingsAmount))
            .setter(setter(Builder::estimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCost").getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build())
            .build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCostWithCurrentCommitment")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedOnDemandCostWithCurrentCommitment))
            .setter(setter(Builder::estimatedOnDemandCostWithCurrentCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedOnDemandCostWithCurrentCommitment").build()).build();

    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedROI").getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedROI))
            .setter(setter(Builder::estimatedROI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()).build();

    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsAmount").getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedSavingsAmount))
            .setter(setter(Builder::estimatedSavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build())
            .build();

    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedSavingsPercentage")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedSavingsPercentage))
            .setter(setter(Builder::estimatedSavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build())
            .build();

    private static final SdkField<String> ESTIMATED_COMMITMENT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCommitmentCost").getter(getter(SavingsPlansPurchaseAnalysisDetails::estimatedCommitmentCost))
            .setter(setter(Builder::estimatedCommitmentCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCommitmentCost").build())
            .build();

    private static final SdkField<String> LATEST_USAGE_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestUsageTimestamp").getter(getter(SavingsPlansPurchaseAnalysisDetails::latestUsageTimestamp))
            .setter(setter(Builder::latestUsageTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUsageTimestamp").build())
            .build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpfrontCost").getter(getter(SavingsPlansPurchaseAnalysisDetails::upfrontCost))
            .setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()).build();

    private static final SdkField<String> ADDITIONAL_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalMetadata").getter(getter(SavingsPlansPurchaseAnalysisDetails::additionalMetadata))
            .setter(setter(Builder::additionalMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetadata").build())
            .build();

    private static final SdkField<List<RecommendationDetailHourlyMetrics>> METRICS_OVER_LOOKBACK_PERIOD_FIELD = SdkField
            .<List<RecommendationDetailHourlyMetrics>> builder(MarshallingType.LIST)
            .memberName("MetricsOverLookbackPeriod")
            .getter(getter(SavingsPlansPurchaseAnalysisDetails::metricsOverLookbackPeriod))
            .setter(setter(Builder::metricsOverLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsOverLookbackPeriod").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationDetailHourlyMetrics> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationDetailHourlyMetrics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            LOOKBACK_PERIOD_IN_HOURS_FIELD, CURRENT_AVERAGE_COVERAGE_FIELD, CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD,
            CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD,
            CURRENT_ON_DEMAND_SPEND_FIELD, EXISTING_HOURLY_COMMITMENT_FIELD, HOURLY_COMMITMENT_TO_PURCHASE_FIELD,
            ESTIMATED_AVERAGE_COVERAGE_FIELD, ESTIMATED_AVERAGE_UTILIZATION_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD,
            ESTIMATED_ON_DEMAND_COST_FIELD, ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD, ESTIMATED_ROI_FIELD,
            ESTIMATED_SAVINGS_AMOUNT_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, ESTIMATED_COMMITMENT_COST_FIELD,
            LATEST_USAGE_TIMESTAMP_FIELD, UPFRONT_COST_FIELD, ADDITIONAL_METADATA_FIELD, METRICS_OVER_LOOKBACK_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final String lookbackPeriodInHours;

    private final String currentAverageCoverage;

    private final String currentAverageHourlyOnDemandSpend;

    private final String currentMaximumHourlyOnDemandSpend;

    private final String currentMinimumHourlyOnDemandSpend;

    private final String currentOnDemandSpend;

    private final String existingHourlyCommitment;

    private final String hourlyCommitmentToPurchase;

    private final String estimatedAverageCoverage;

    private final String estimatedAverageUtilization;

    private final String estimatedMonthlySavingsAmount;

    private final String estimatedOnDemandCost;

    private final String estimatedOnDemandCostWithCurrentCommitment;

    private final String estimatedROI;

    private final String estimatedSavingsAmount;

    private final String estimatedSavingsPercentage;

    private final String estimatedCommitmentCost;

    private final String latestUsageTimestamp;

    private final String upfrontCost;

    private final String additionalMetadata;

    private final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod;

    private SavingsPlansPurchaseAnalysisDetails(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.lookbackPeriodInHours = builder.lookbackPeriodInHours;
        this.currentAverageCoverage = builder.currentAverageCoverage;
        this.currentAverageHourlyOnDemandSpend = builder.currentAverageHourlyOnDemandSpend;
        this.currentMaximumHourlyOnDemandSpend = builder.currentMaximumHourlyOnDemandSpend;
        this.currentMinimumHourlyOnDemandSpend = builder.currentMinimumHourlyOnDemandSpend;
        this.currentOnDemandSpend = builder.currentOnDemandSpend;
        this.existingHourlyCommitment = builder.existingHourlyCommitment;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.estimatedAverageCoverage = builder.estimatedAverageCoverage;
        this.estimatedAverageUtilization = builder.estimatedAverageUtilization;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
        this.estimatedROI = builder.estimatedROI;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.estimatedCommitmentCost = builder.estimatedCommitmentCost;
        this.latestUsageTimestamp = builder.latestUsageTimestamp;
        this.upfrontCost = builder.upfrontCost;
        this.additionalMetadata = builder.additionalMetadata;
        this.metricsOverLookbackPeriod = builder.metricsOverLookbackPeriod;
    }

    /**
     * <p>
     * The currency code used for the analysis.
     * </p>
     * 
     * @return The currency code used for the analysis.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The lookback period in hours that's used to generate the analysis.
     * </p>
     * 
     * @return The lookback period in hours that's used to generate the analysis.
     */
    public final String lookbackPeriodInHours() {
        return lookbackPeriodInHours;
    }

    /**
     * <p>
     * The average value of hourly coverage over the lookback period.
     * </p>
     * 
     * @return The average value of hourly coverage over the lookback period.
     */
    public final String currentAverageCoverage() {
        return currentAverageCoverage;
    }

    /**
     * <p>
     * The average value of hourly On-Demand spend over the lookback period.
     * </p>
     * 
     * @return The average value of hourly On-Demand spend over the lookback period.
     */
    public final String currentAverageHourlyOnDemandSpend() {
        return currentAverageHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The highest value of hourly On-Demand spend over the lookback period.
     * </p>
     * 
     * @return The highest value of hourly On-Demand spend over the lookback period.
     */
    public final String currentMaximumHourlyOnDemandSpend() {
        return currentMaximumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The lowest value of hourly On-Demand spend over the lookback period.
     * </p>
     * 
     * @return The lowest value of hourly On-Demand spend over the lookback period.
     */
    public final String currentMinimumHourlyOnDemandSpend() {
        return currentMinimumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The current total On-Demand spend over the lookback period.
     * </p>
     * 
     * @return The current total On-Demand spend over the lookback period.
     */
    public final String currentOnDemandSpend() {
        return currentOnDemandSpend;
    }

    /**
     * <p>
     * The existing hourly commitment for the Savings Plan type.
     * </p>
     * 
     * @return The existing hourly commitment for the Savings Plan type.
     */
    public final String existingHourlyCommitment() {
        return existingHourlyCommitment;
    }

    /**
     * <p>
     * The recommended or custom hourly commitment.
     * </p>
     * 
     * @return The recommended or custom hourly commitment.
     */
    public final String hourlyCommitmentToPurchase() {
        return hourlyCommitmentToPurchase;
    }

    /**
     * <p>
     * The estimated coverage of the Savings Plan.
     * </p>
     * 
     * @return The estimated coverage of the Savings Plan.
     */
    public final String estimatedAverageCoverage() {
        return estimatedAverageCoverage;
    }

    /**
     * <p>
     * The estimated utilization of the Savings Plan.
     * </p>
     * 
     * @return The estimated utilization of the Savings Plan.
     */
    public final String estimatedAverageUtilization() {
        return estimatedAverageUtilization;
    }

    /**
     * <p>
     * The estimated monthly savings amount based on the Savings Plan.
     * </p>
     * 
     * @return The estimated monthly savings amount based on the Savings Plan.
     */
    public final String estimatedMonthlySavingsAmount() {
        return estimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * The remaining On-Demand cost estimated to not be covered by the Savings Plan over the length of the lookback
     * period.
     * </p>
     * 
     * @return The remaining On-Demand cost estimated to not be covered by the Savings Plan over the length of the
     *         lookback period.
     */
    public final String estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The estimated On-Demand cost you expect with no additional commitment based on your usage of the selected time
     * period and the Savings Plan you own.
     * </p>
     * 
     * @return The estimated On-Demand cost you expect with no additional commitment based on your usage of the selected
     *         time period and the Savings Plan you own.
     */
    public final String estimatedOnDemandCostWithCurrentCommitment() {
        return estimatedOnDemandCostWithCurrentCommitment;
    }

    /**
     * <p>
     * The estimated return on investment that's based on the Savings Plan and estimated savings. This is calculated as
     * estimatedSavingsAmount/estimatedSPCost*100.
     * </p>
     * 
     * @return The estimated return on investment that's based on the Savings Plan and estimated savings. This is
     *         calculated as estimatedSavingsAmount/estimatedSPCost*100.
     */
    public final String estimatedROI() {
        return estimatedROI;
    }

    /**
     * <p>
     * The estimated savings amount that's based on the Savings Plan over the length of the lookback period.
     * </p>
     * 
     * @return The estimated savings amount that's based on the Savings Plan over the length of the lookback period.
     */
    public final String estimatedSavingsAmount() {
        return estimatedSavingsAmount;
    }

    /**
     * <p>
     * The estimated savings percentage relative to the total cost over the cost calculation lookback period.
     * </p>
     * 
     * @return The estimated savings percentage relative to the total cost over the cost calculation lookback period.
     */
    public final String estimatedSavingsPercentage() {
        return estimatedSavingsPercentage;
    }

    /**
     * <p>
     * The estimated cost of the Savings Plan over the length of the lookback period.
     * </p>
     * 
     * @return The estimated cost of the Savings Plan over the length of the lookback period.
     */
    public final String estimatedCommitmentCost() {
        return estimatedCommitmentCost;
    }

    /**
     * <p>
     * The date and time of the last hour that went into the analysis.
     * </p>
     * 
     * @return The date and time of the last hour that went into the analysis.
     */
    public final String latestUsageTimestamp() {
        return latestUsageTimestamp;
    }

    /**
     * <p>
     * The upfront cost of the Savings Plan based on the selected payment option.
     * </p>
     * 
     * @return The upfront cost of the Savings Plan based on the selected payment option.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * Additional metadata that might be applicable to the commitment.
     * </p>
     * 
     * @return Additional metadata that might be applicable to the commitment.
     */
    public final String additionalMetadata() {
        return additionalMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsOverLookbackPeriod property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetricsOverLookbackPeriod() {
        return metricsOverLookbackPeriod != null && !(metricsOverLookbackPeriod instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The related hourly cost, coverage, and utilization metrics over the lookback period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsOverLookbackPeriod} method.
     * </p>
     * 
     * @return The related hourly cost, coverage, and utilization metrics over the lookback period.
     */
    public final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod() {
        return metricsOverLookbackPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInHours());
        hashCode = 31 * hashCode + Objects.hashCode(currentAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(currentAverageHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentMaximumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentMinimumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(existingHourlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedAverageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCostWithCurrentCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCommitmentCost());
        hashCode = 31 * hashCode + Objects.hashCode(latestUsageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsOverLookbackPeriod() ? metricsOverLookbackPeriod() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseAnalysisDetails)) {
            return false;
        }
        SavingsPlansPurchaseAnalysisDetails other = (SavingsPlansPurchaseAnalysisDetails) obj;
        return Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(lookbackPeriodInHours(), other.lookbackPeriodInHours())
                && Objects.equals(currentAverageCoverage(), other.currentAverageCoverage())
                && Objects.equals(currentAverageHourlyOnDemandSpend(), other.currentAverageHourlyOnDemandSpend())
                && Objects.equals(currentMaximumHourlyOnDemandSpend(), other.currentMaximumHourlyOnDemandSpend())
                && Objects.equals(currentMinimumHourlyOnDemandSpend(), other.currentMinimumHourlyOnDemandSpend())
                && Objects.equals(currentOnDemandSpend(), other.currentOnDemandSpend())
                && Objects.equals(existingHourlyCommitment(), other.existingHourlyCommitment())
                && Objects.equals(hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase())
                && Objects.equals(estimatedAverageCoverage(), other.estimatedAverageCoverage())
                && Objects.equals(estimatedAverageUtilization(), other.estimatedAverageUtilization())
                && Objects.equals(estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(estimatedOnDemandCostWithCurrentCommitment(),
                        other.estimatedOnDemandCostWithCurrentCommitment())
                && Objects.equals(estimatedROI(), other.estimatedROI())
                && Objects.equals(estimatedSavingsAmount(), other.estimatedSavingsAmount())
                && Objects.equals(estimatedSavingsPercentage(), other.estimatedSavingsPercentage())
                && Objects.equals(estimatedCommitmentCost(), other.estimatedCommitmentCost())
                && Objects.equals(latestUsageTimestamp(), other.latestUsageTimestamp())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(additionalMetadata(), other.additionalMetadata())
                && hasMetricsOverLookbackPeriod() == other.hasMetricsOverLookbackPeriod()
                && Objects.equals(metricsOverLookbackPeriod(), other.metricsOverLookbackPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPurchaseAnalysisDetails").add("CurrencyCode", currencyCode())
                .add("LookbackPeriodInHours", lookbackPeriodInHours()).add("CurrentAverageCoverage", currentAverageCoverage())
                .add("CurrentAverageHourlyOnDemandSpend", currentAverageHourlyOnDemandSpend())
                .add("CurrentMaximumHourlyOnDemandSpend", currentMaximumHourlyOnDemandSpend())
                .add("CurrentMinimumHourlyOnDemandSpend", currentMinimumHourlyOnDemandSpend())
                .add("CurrentOnDemandSpend", currentOnDemandSpend()).add("ExistingHourlyCommitment", existingHourlyCommitment())
                .add("HourlyCommitmentToPurchase", hourlyCommitmentToPurchase())
                .add("EstimatedAverageCoverage", estimatedAverageCoverage())
                .add("EstimatedAverageUtilization", estimatedAverageUtilization())
                .add("EstimatedMonthlySavingsAmount", estimatedMonthlySavingsAmount())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost())
                .add("EstimatedOnDemandCostWithCurrentCommitment", estimatedOnDemandCostWithCurrentCommitment())
                .add("EstimatedROI", estimatedROI()).add("EstimatedSavingsAmount", estimatedSavingsAmount())
                .add("EstimatedSavingsPercentage", estimatedSavingsPercentage())
                .add("EstimatedCommitmentCost", estimatedCommitmentCost()).add("LatestUsageTimestamp", latestUsageTimestamp())
                .add("UpfrontCost", upfrontCost()).add("AdditionalMetadata", additionalMetadata())
                .add("MetricsOverLookbackPeriod", hasMetricsOverLookbackPeriod() ? metricsOverLookbackPeriod() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "LookbackPeriodInHours":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInHours()));
        case "CurrentAverageCoverage":
            return Optional.ofNullable(clazz.cast(currentAverageCoverage()));
        case "CurrentAverageHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentAverageHourlyOnDemandSpend()));
        case "CurrentMaximumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMaximumHourlyOnDemandSpend()));
        case "CurrentMinimumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMinimumHourlyOnDemandSpend()));
        case "CurrentOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentOnDemandSpend()));
        case "ExistingHourlyCommitment":
            return Optional.ofNullable(clazz.cast(existingHourlyCommitment()));
        case "HourlyCommitmentToPurchase":
            return Optional.ofNullable(clazz.cast(hourlyCommitmentToPurchase()));
        case "EstimatedAverageCoverage":
            return Optional.ofNullable(clazz.cast(estimatedAverageCoverage()));
        case "EstimatedAverageUtilization":
            return Optional.ofNullable(clazz.cast(estimatedAverageUtilization()));
        case "EstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsAmount()));
        case "EstimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "EstimatedOnDemandCostWithCurrentCommitment":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCostWithCurrentCommitment()));
        case "EstimatedROI":
            return Optional.ofNullable(clazz.cast(estimatedROI()));
        case "EstimatedSavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedSavingsAmount()));
        case "EstimatedSavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedSavingsPercentage()));
        case "EstimatedCommitmentCost":
            return Optional.ofNullable(clazz.cast(estimatedCommitmentCost()));
        case "LatestUsageTimestamp":
            return Optional.ofNullable(clazz.cast(latestUsageTimestamp()));
        case "UpfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "AdditionalMetadata":
            return Optional.ofNullable(clazz.cast(additionalMetadata()));
        case "MetricsOverLookbackPeriod":
            return Optional.ofNullable(clazz.cast(metricsOverLookbackPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("LookbackPeriodInHours", LOOKBACK_PERIOD_IN_HOURS_FIELD);
        map.put("CurrentAverageCoverage", CURRENT_AVERAGE_COVERAGE_FIELD);
        map.put("CurrentAverageHourlyOnDemandSpend", CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMaximumHourlyOnDemandSpend", CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMinimumHourlyOnDemandSpend", CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentOnDemandSpend", CURRENT_ON_DEMAND_SPEND_FIELD);
        map.put("ExistingHourlyCommitment", EXISTING_HOURLY_COMMITMENT_FIELD);
        map.put("HourlyCommitmentToPurchase", HOURLY_COMMITMENT_TO_PURCHASE_FIELD);
        map.put("EstimatedAverageCoverage", ESTIMATED_AVERAGE_COVERAGE_FIELD);
        map.put("EstimatedAverageUtilization", ESTIMATED_AVERAGE_UTILIZATION_FIELD);
        map.put("EstimatedMonthlySavingsAmount", ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        map.put("EstimatedOnDemandCostWithCurrentCommitment", ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD);
        map.put("EstimatedROI", ESTIMATED_ROI_FIELD);
        map.put("EstimatedSavingsAmount", ESTIMATED_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedSavingsPercentage", ESTIMATED_SAVINGS_PERCENTAGE_FIELD);
        map.put("EstimatedCommitmentCost", ESTIMATED_COMMITMENT_COST_FIELD);
        map.put("LatestUsageTimestamp", LATEST_USAGE_TIMESTAMP_FIELD);
        map.put("UpfrontCost", UPFRONT_COST_FIELD);
        map.put("AdditionalMetadata", ADDITIONAL_METADATA_FIELD);
        map.put("MetricsOverLookbackPeriod", METRICS_OVER_LOOKBACK_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseAnalysisDetails, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseAnalysisDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseAnalysisDetails> {
        /**
         * <p>
         * The currency code used for the analysis.
         * </p>
         * 
         * @param currencyCode
         *        The currency code used for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The lookback period in hours that's used to generate the analysis.
         * </p>
         * 
         * @param lookbackPeriodInHours
         *        The lookback period in hours that's used to generate the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackPeriodInHours(String lookbackPeriodInHours);

        /**
         * <p>
         * The average value of hourly coverage over the lookback period.
         * </p>
         * 
         * @param currentAverageCoverage
         *        The average value of hourly coverage over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAverageCoverage(String currentAverageCoverage);

        /**
         * <p>
         * The average value of hourly On-Demand spend over the lookback period.
         * </p>
         * 
         * @param currentAverageHourlyOnDemandSpend
         *        The average value of hourly On-Demand spend over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend);

        /**
         * <p>
         * The highest value of hourly On-Demand spend over the lookback period.
         * </p>
         * 
         * @param currentMaximumHourlyOnDemandSpend
         *        The highest value of hourly On-Demand spend over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend);

        /**
         * <p>
         * The lowest value of hourly On-Demand spend over the lookback period.
         * </p>
         * 
         * @param currentMinimumHourlyOnDemandSpend
         *        The lowest value of hourly On-Demand spend over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend);

        /**
         * <p>
         * The current total On-Demand spend over the lookback period.
         * </p>
         * 
         * @param currentOnDemandSpend
         *        The current total On-Demand spend over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentOnDemandSpend(String currentOnDemandSpend);

        /**
         * <p>
         * The existing hourly commitment for the Savings Plan type.
         * </p>
         * 
         * @param existingHourlyCommitment
         *        The existing hourly commitment for the Savings Plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingHourlyCommitment(String existingHourlyCommitment);

        /**
         * <p>
         * The recommended or custom hourly commitment.
         * </p>
         * 
         * @param hourlyCommitmentToPurchase
         *        The recommended or custom hourly commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase);

        /**
         * <p>
         * The estimated coverage of the Savings Plan.
         * </p>
         * 
         * @param estimatedAverageCoverage
         *        The estimated coverage of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedAverageCoverage(String estimatedAverageCoverage);

        /**
         * <p>
         * The estimated utilization of the Savings Plan.
         * </p>
         * 
         * @param estimatedAverageUtilization
         *        The estimated utilization of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedAverageUtilization(String estimatedAverageUtilization);

        /**
         * <p>
         * The estimated monthly savings amount based on the Savings Plan.
         * </p>
         * 
         * @param estimatedMonthlySavingsAmount
         *        The estimated monthly savings amount based on the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount);

        /**
         * <p>
         * The remaining On-Demand cost estimated to not be covered by the Savings Plan over the length of the lookback
         * period.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        The remaining On-Demand cost estimated to not be covered by the Savings Plan over the length of the
         *        lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(String estimatedOnDemandCost);

        /**
         * <p>
         * The estimated On-Demand cost you expect with no additional commitment based on your usage of the selected
         * time period and the Savings Plan you own.
         * </p>
         * 
         * @param estimatedOnDemandCostWithCurrentCommitment
         *        The estimated On-Demand cost you expect with no additional commitment based on your usage of the
         *        selected time period and the Savings Plan you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment);

        /**
         * <p>
         * The estimated return on investment that's based on the Savings Plan and estimated savings. This is calculated
         * as estimatedSavingsAmount/estimatedSPCost*100.
         * </p>
         * 
         * @param estimatedROI
         *        The estimated return on investment that's based on the Savings Plan and estimated savings. This is
         *        calculated as estimatedSavingsAmount/estimatedSPCost*100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedROI(String estimatedROI);

        /**
         * <p>
         * The estimated savings amount that's based on the Savings Plan over the length of the lookback period.
         * </p>
         * 
         * @param estimatedSavingsAmount
         *        The estimated savings amount that's based on the Savings Plan over the length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsAmount(String estimatedSavingsAmount);

        /**
         * <p>
         * The estimated savings percentage relative to the total cost over the cost calculation lookback period.
         * </p>
         * 
         * @param estimatedSavingsPercentage
         *        The estimated savings percentage relative to the total cost over the cost calculation lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsPercentage(String estimatedSavingsPercentage);

        /**
         * <p>
         * The estimated cost of the Savings Plan over the length of the lookback period.
         * </p>
         * 
         * @param estimatedCommitmentCost
         *        The estimated cost of the Savings Plan over the length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCommitmentCost(String estimatedCommitmentCost);

        /**
         * <p>
         * The date and time of the last hour that went into the analysis.
         * </p>
         * 
         * @param latestUsageTimestamp
         *        The date and time of the last hour that went into the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestUsageTimestamp(String latestUsageTimestamp);

        /**
         * <p>
         * The upfront cost of the Savings Plan based on the selected payment option.
         * </p>
         * 
         * @param upfrontCost
         *        The upfront cost of the Savings Plan based on the selected payment option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * Additional metadata that might be applicable to the commitment.
         * </p>
         * 
         * @param additionalMetadata
         *        Additional metadata that might be applicable to the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetadata(String additionalMetadata);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * 
         * @param metricsOverLookbackPeriod
         *        The related hourly cost, coverage, and utilization metrics over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * 
         * @param metricsOverLookbackPeriod
         *        The related hourly cost, coverage, and utilization metrics over the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics... metricsOverLookbackPeriod);

        /**
         * <p>
         * The related hourly cost, coverage, and utilization metrics over the lookback period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #metricsOverLookbackPeriod(List<RecommendationDetailHourlyMetrics>)}.
         * 
         * @param metricsOverLookbackPeriod
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsOverLookbackPeriod(java.util.Collection<RecommendationDetailHourlyMetrics>)
         */
        Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder>... metricsOverLookbackPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private String lookbackPeriodInHours;

        private String currentAverageCoverage;

        private String currentAverageHourlyOnDemandSpend;

        private String currentMaximumHourlyOnDemandSpend;

        private String currentMinimumHourlyOnDemandSpend;

        private String currentOnDemandSpend;

        private String existingHourlyCommitment;

        private String hourlyCommitmentToPurchase;

        private String estimatedAverageCoverage;

        private String estimatedAverageUtilization;

        private String estimatedMonthlySavingsAmount;

        private String estimatedOnDemandCost;

        private String estimatedOnDemandCostWithCurrentCommitment;

        private String estimatedROI;

        private String estimatedSavingsAmount;

        private String estimatedSavingsPercentage;

        private String estimatedCommitmentCost;

        private String latestUsageTimestamp;

        private String upfrontCost;

        private String additionalMetadata;

        private List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseAnalysisDetails model) {
            currencyCode(model.currencyCode);
            lookbackPeriodInHours(model.lookbackPeriodInHours);
            currentAverageCoverage(model.currentAverageCoverage);
            currentAverageHourlyOnDemandSpend(model.currentAverageHourlyOnDemandSpend);
            currentMaximumHourlyOnDemandSpend(model.currentMaximumHourlyOnDemandSpend);
            currentMinimumHourlyOnDemandSpend(model.currentMinimumHourlyOnDemandSpend);
            currentOnDemandSpend(model.currentOnDemandSpend);
            existingHourlyCommitment(model.existingHourlyCommitment);
            hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            estimatedAverageCoverage(model.estimatedAverageCoverage);
            estimatedAverageUtilization(model.estimatedAverageUtilization);
            estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
            estimatedROI(model.estimatedROI);
            estimatedSavingsAmount(model.estimatedSavingsAmount);
            estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            estimatedCommitmentCost(model.estimatedCommitmentCost);
            latestUsageTimestamp(model.latestUsageTimestamp);
            upfrontCost(model.upfrontCost);
            additionalMetadata(model.additionalMetadata);
            metricsOverLookbackPeriod(model.metricsOverLookbackPeriod);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getLookbackPeriodInHours() {
            return lookbackPeriodInHours;
        }

        public final void setLookbackPeriodInHours(String lookbackPeriodInHours) {
            this.lookbackPeriodInHours = lookbackPeriodInHours;
        }

        @Override
        public final Builder lookbackPeriodInHours(String lookbackPeriodInHours) {
            this.lookbackPeriodInHours = lookbackPeriodInHours;
            return this;
        }

        public final String getCurrentAverageCoverage() {
            return currentAverageCoverage;
        }

        public final void setCurrentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
        }

        @Override
        public final Builder currentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
            return this;
        }

        public final String getCurrentAverageHourlyOnDemandSpend() {
            return currentAverageHourlyOnDemandSpend;
        }

        public final void setCurrentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMaximumHourlyOnDemandSpend() {
            return currentMaximumHourlyOnDemandSpend;
        }

        public final void setCurrentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMinimumHourlyOnDemandSpend() {
            return currentMinimumHourlyOnDemandSpend;
        }

        public final void setCurrentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentOnDemandSpend() {
            return currentOnDemandSpend;
        }

        public final void setCurrentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
        }

        @Override
        public final Builder currentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
            return this;
        }

        public final String getExistingHourlyCommitment() {
            return existingHourlyCommitment;
        }

        public final void setExistingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
        }

        @Override
        public final Builder existingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
            return this;
        }

        public final String getHourlyCommitmentToPurchase() {
            return hourlyCommitmentToPurchase;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final String getEstimatedAverageCoverage() {
            return estimatedAverageCoverage;
        }

        public final void setEstimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
        }

        @Override
        public final Builder estimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
            return this;
        }

        public final String getEstimatedAverageUtilization() {
            return estimatedAverageUtilization;
        }

        public final void setEstimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
        }

        @Override
        public final Builder estimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return estimatedOnDemandCostWithCurrentCommitment;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        public final String getEstimatedROI() {
            return estimatedROI;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final String getEstimatedSavingsAmount() {
            return estimatedSavingsAmount;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final String getEstimatedSavingsPercentage() {
            return estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getEstimatedCommitmentCost() {
            return estimatedCommitmentCost;
        }

        public final void setEstimatedCommitmentCost(String estimatedCommitmentCost) {
            this.estimatedCommitmentCost = estimatedCommitmentCost;
        }

        @Override
        public final Builder estimatedCommitmentCost(String estimatedCommitmentCost) {
            this.estimatedCommitmentCost = estimatedCommitmentCost;
            return this;
        }

        public final String getLatestUsageTimestamp() {
            return latestUsageTimestamp;
        }

        public final void setLatestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
        }

        @Override
        public final Builder latestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getAdditionalMetadata() {
            return additionalMetadata;
        }

        public final void setAdditionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
        }

        @Override
        public final Builder additionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        public final List<RecommendationDetailHourlyMetrics.Builder> getMetricsOverLookbackPeriod() {
            List<RecommendationDetailHourlyMetrics.Builder> result = MetricsOverLookbackPeriodCopier
                    .copyToBuilder(this.metricsOverLookbackPeriod);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsOverLookbackPeriod(
                Collection<RecommendationDetailHourlyMetrics.BuilderImpl> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copyFromBuilder(metricsOverLookbackPeriod);
        }

        @Override
        public final Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copy(metricsOverLookbackPeriod);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics... metricsOverLookbackPeriod) {
            metricsOverLookbackPeriod(Arrays.asList(metricsOverLookbackPeriod));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(
                Consumer<RecommendationDetailHourlyMetrics.Builder>... metricsOverLookbackPeriod) {
            metricsOverLookbackPeriod(Stream.of(metricsOverLookbackPeriod)
                    .map(c -> RecommendationDetailHourlyMetrics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SavingsPlansPurchaseAnalysisDetails build() {
            return new SavingsPlansPurchaseAnalysisDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
