/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCommitmentPurchaseAnalysisResponse extends CostExplorerResponse implements
        ToCopyableBuilder<StartCommitmentPurchaseAnalysisResponse.Builder, StartCommitmentPurchaseAnalysisResponse> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(StartCommitmentPurchaseAnalysisResponse::analysisId))
            .setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> ANALYSIS_STARTED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisStartedTime").getter(getter(StartCommitmentPurchaseAnalysisResponse::analysisStartedTime))
            .setter(setter(Builder::analysisStartedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartedTime").build())
            .build();

    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCompletionTime")
            .getter(getter(StartCommitmentPurchaseAnalysisResponse::estimatedCompletionTime))
            .setter(setter(Builder::estimatedCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD,
            ANALYSIS_STARTED_TIME_FIELD, ESTIMATED_COMPLETION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String analysisId;

    private final String analysisStartedTime;

    private final String estimatedCompletionTime;

    private StartCommitmentPurchaseAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.analysisId = builder.analysisId;
        this.analysisStartedTime = builder.analysisStartedTime;
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
    }

    /**
     * <p>
     * The analysis ID that's associated with the commitment purchase analysis.
     * </p>
     * 
     * @return The analysis ID that's associated with the commitment purchase analysis.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The start time of the analysis.
     * </p>
     * 
     * @return The start time of the analysis.
     */
    public final String analysisStartedTime() {
        return analysisStartedTime;
    }

    /**
     * <p>
     * The estimated time for when the analysis will complete.
     * </p>
     * 
     * @return The estimated time for when the analysis will complete.
     */
    public final String estimatedCompletionTime() {
        return estimatedCompletionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCompletionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommitmentPurchaseAnalysisResponse)) {
            return false;
        }
        StartCommitmentPurchaseAnalysisResponse other = (StartCommitmentPurchaseAnalysisResponse) obj;
        return Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(analysisStartedTime(), other.analysisStartedTime())
                && Objects.equals(estimatedCompletionTime(), other.estimatedCompletionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCommitmentPurchaseAnalysisResponse").add("AnalysisId", analysisId())
                .add("AnalysisStartedTime", analysisStartedTime()).add("EstimatedCompletionTime", estimatedCompletionTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "AnalysisStartedTime":
            return Optional.ofNullable(clazz.cast(analysisStartedTime()));
        case "EstimatedCompletionTime":
            return Optional.ofNullable(clazz.cast(estimatedCompletionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("AnalysisStartedTime", ANALYSIS_STARTED_TIME_FIELD);
        map.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommitmentPurchaseAnalysisResponse, T> g) {
        return obj -> g.apply((StartCommitmentPurchaseAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartCommitmentPurchaseAnalysisResponse> {
        /**
         * <p>
         * The analysis ID that's associated with the commitment purchase analysis.
         * </p>
         * 
         * @param analysisId
         *        The analysis ID that's associated with the commitment purchase analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The start time of the analysis.
         * </p>
         * 
         * @param analysisStartedTime
         *        The start time of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStartedTime(String analysisStartedTime);

        /**
         * <p>
         * The estimated time for when the analysis will complete.
         * </p>
         * 
         * @param estimatedCompletionTime
         *        The estimated time for when the analysis will complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCompletionTime(String estimatedCompletionTime);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String analysisId;

        private String analysisStartedTime;

        private String estimatedCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommitmentPurchaseAnalysisResponse model) {
            super(model);
            analysisId(model.analysisId);
            analysisStartedTime(model.analysisStartedTime);
            estimatedCompletionTime(model.estimatedCompletionTime);
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getAnalysisStartedTime() {
            return analysisStartedTime;
        }

        public final void setAnalysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
        }

        @Override
        public final Builder analysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
            return this;
        }

        public final String getEstimatedCompletionTime() {
            return estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        @Override
        public StartCommitmentPurchaseAnalysisResponse build() {
            return new StartCommitmentPurchaseAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
