/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseTableOutputOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseTableOutputOptions.Builder, DatabaseTableOutputOptions> {
    private static final SdkField<S3Location> TEMP_DIRECTORY_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("TempDirectory").getter(getter(DatabaseTableOutputOptions::tempDirectory))
            .setter(setter(Builder::tempDirectory)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDirectory").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DatabaseTableOutputOptions::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMP_DIRECTORY_FIELD,
            TABLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Location tempDirectory;

    private final String tableName;

    private DatabaseTableOutputOptions(BuilderImpl builder) {
        this.tempDirectory = builder.tempDirectory;
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
     * </p>
     * 
     * @return Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate
     *         results.
     */
    public final S3Location tempDirectory() {
        return tempDirectory;
    }

    /**
     * <p>
     * A prefix for the name of a table DataBrew will create in the database.
     * </p>
     * 
     * @return A prefix for the name of a table DataBrew will create in the database.
     */
    public final String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tempDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseTableOutputOptions)) {
            return false;
        }
        DatabaseTableOutputOptions other = (DatabaseTableOutputOptions) obj;
        return Objects.equals(tempDirectory(), other.tempDirectory()) && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseTableOutputOptions").add("TempDirectory", tempDirectory()).add("TableName", tableName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TempDirectory":
            return Optional.ofNullable(clazz.cast(tempDirectory()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TempDirectory", TEMP_DIRECTORY_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseTableOutputOptions, T> g) {
        return obj -> g.apply((DatabaseTableOutputOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseTableOutputOptions> {
        /**
         * <p>
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
         * </p>
         * 
         * @param tempDirectory
         *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tempDirectory(S3Location tempDirectory);

        /**
         * <p>
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can store intermediate results.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #tempDirectory(S3Location)}.
         * 
         * @param tempDirectory
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tempDirectory(S3Location)
         */
        default Builder tempDirectory(Consumer<S3Location.Builder> tempDirectory) {
            return tempDirectory(S3Location.builder().applyMutation(tempDirectory).build());
        }

        /**
         * <p>
         * A prefix for the name of a table DataBrew will create in the database.
         * </p>
         * 
         * @param tableName
         *        A prefix for the name of a table DataBrew will create in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private S3Location tempDirectory;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseTableOutputOptions model) {
            tempDirectory(model.tempDirectory);
            tableName(model.tableName);
        }

        public final S3Location.Builder getTempDirectory() {
            return tempDirectory != null ? tempDirectory.toBuilder() : null;
        }

        public final void setTempDirectory(S3Location.BuilderImpl tempDirectory) {
            this.tempDirectory = tempDirectory != null ? tempDirectory.build() : null;
        }

        @Override
        public final Builder tempDirectory(S3Location tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public DatabaseTableOutputOptions build() {
            return new DatabaseTableOutputOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
