/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendProjectSessionActionRequest extends DataBrewRequest implements
        ToCopyableBuilder<SendProjectSessionActionRequest.Builder, SendProjectSessionActionRequest> {
    private static final SdkField<Boolean> PREVIEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Preview").getter(getter(SendProjectSessionActionRequest::preview)).setter(setter(Builder::preview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preview").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SendProjectSessionActionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<RecipeStep> RECIPE_STEP_FIELD = SdkField.<RecipeStep> builder(MarshallingType.SDK_POJO)
            .memberName("RecipeStep").getter(getter(SendProjectSessionActionRequest::recipeStep))
            .setter(setter(Builder::recipeStep)).constructor(RecipeStep::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeStep").build()).build();

    private static final SdkField<Integer> STEP_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StepIndex").getter(getter(SendProjectSessionActionRequest::stepIndex))
            .setter(setter(Builder::stepIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIndex").build()).build();

    private static final SdkField<String> CLIENT_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSessionId").getter(getter(SendProjectSessionActionRequest::clientSessionId))
            .setter(setter(Builder::clientSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSessionId").build()).build();

    private static final SdkField<ViewFrame> VIEW_FRAME_FIELD = SdkField.<ViewFrame> builder(MarshallingType.SDK_POJO)
            .memberName("ViewFrame").getter(getter(SendProjectSessionActionRequest::viewFrame))
            .setter(setter(Builder::viewFrame)).constructor(ViewFrame::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewFrame").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_FIELD, NAME_FIELD,
            RECIPE_STEP_FIELD, STEP_INDEX_FIELD, CLIENT_SESSION_ID_FIELD, VIEW_FRAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean preview;

    private final String name;

    private final RecipeStep recipeStep;

    private final Integer stepIndex;

    private final String clientSessionId;

    private final ViewFrame viewFrame;

    private SendProjectSessionActionRequest(BuilderImpl builder) {
        super(builder);
        this.preview = builder.preview;
        this.name = builder.name;
        this.recipeStep = builder.recipeStep;
        this.stepIndex = builder.stepIndex;
        this.clientSessionId = builder.clientSessionId;
        this.viewFrame = builder.viewFrame;
    }

    /**
     * <p>
     * If true, the result of the recipe step will be returned, but not applied.
     * </p>
     * 
     * @return If true, the result of the recipe step will be returned, but not applied.
     */
    public final Boolean preview() {
        return preview;
    }

    /**
     * <p>
     * The name of the project to apply the action to.
     * </p>
     * 
     * @return The name of the project to apply the action to.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the RecipeStep property for this object.
     * 
     * @return The value of the RecipeStep property for this object.
     */
    public final RecipeStep recipeStep() {
        return recipeStep;
    }

    /**
     * <p>
     * The index from which to preview a step. This index is used to preview the result of steps that have already been
     * applied, so that the resulting view frame is from earlier in the view frame stack.
     * </p>
     * 
     * @return The index from which to preview a step. This index is used to preview the result of steps that have
     *         already been applied, so that the resulting view frame is from earlier in the view frame stack.
     */
    public final Integer stepIndex() {
        return stepIndex;
    }

    /**
     * <p>
     * A unique identifier for an interactive session that's currently open and ready for work. The action will be
     * performed on this session.
     * </p>
     * 
     * @return A unique identifier for an interactive session that's currently open and ready for work. The action will
     *         be performed on this session.
     */
    public final String clientSessionId() {
        return clientSessionId;
    }

    /**
     * Returns the value of the ViewFrame property for this object.
     * 
     * @return The value of the ViewFrame property for this object.
     */
    public final ViewFrame viewFrame() {
        return viewFrame;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preview());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeStep());
        hashCode = 31 * hashCode + Objects.hashCode(stepIndex());
        hashCode = 31 * hashCode + Objects.hashCode(clientSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(viewFrame());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendProjectSessionActionRequest)) {
            return false;
        }
        SendProjectSessionActionRequest other = (SendProjectSessionActionRequest) obj;
        return Objects.equals(preview(), other.preview()) && Objects.equals(name(), other.name())
                && Objects.equals(recipeStep(), other.recipeStep()) && Objects.equals(stepIndex(), other.stepIndex())
                && Objects.equals(clientSessionId(), other.clientSessionId()) && Objects.equals(viewFrame(), other.viewFrame());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendProjectSessionActionRequest").add("Preview", preview()).add("Name", name())
                .add("RecipeStep", recipeStep()).add("StepIndex", stepIndex())
                .add("ClientSessionId", clientSessionId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ViewFrame", viewFrame()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Preview":
            return Optional.ofNullable(clazz.cast(preview()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecipeStep":
            return Optional.ofNullable(clazz.cast(recipeStep()));
        case "StepIndex":
            return Optional.ofNullable(clazz.cast(stepIndex()));
        case "ClientSessionId":
            return Optional.ofNullable(clazz.cast(clientSessionId()));
        case "ViewFrame":
            return Optional.ofNullable(clazz.cast(viewFrame()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Preview", PREVIEW_FIELD);
        map.put("name", NAME_FIELD);
        map.put("RecipeStep", RECIPE_STEP_FIELD);
        map.put("StepIndex", STEP_INDEX_FIELD);
        map.put("ClientSessionId", CLIENT_SESSION_ID_FIELD);
        map.put("ViewFrame", VIEW_FRAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendProjectSessionActionRequest, T> g) {
        return obj -> g.apply((SendProjectSessionActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendProjectSessionActionRequest> {
        /**
         * <p>
         * If true, the result of the recipe step will be returned, but not applied.
         * </p>
         * 
         * @param preview
         *        If true, the result of the recipe step will be returned, but not applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preview(Boolean preview);

        /**
         * <p>
         * The name of the project to apply the action to.
         * </p>
         * 
         * @param name
         *        The name of the project to apply the action to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the RecipeStep property for this object.
         *
         * @param recipeStep
         *        The new value for the RecipeStep property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeStep(RecipeStep recipeStep);

        /**
         * Sets the value of the RecipeStep property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RecipeStep.Builder} avoiding the need to
         * create one manually via {@link RecipeStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecipeStep.Builder#build()} is called immediately and its result
         * is passed to {@link #recipeStep(RecipeStep)}.
         * 
         * @param recipeStep
         *        a consumer that will call methods on {@link RecipeStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeStep(RecipeStep)
         */
        default Builder recipeStep(Consumer<RecipeStep.Builder> recipeStep) {
            return recipeStep(RecipeStep.builder().applyMutation(recipeStep).build());
        }

        /**
         * <p>
         * The index from which to preview a step. This index is used to preview the result of steps that have already
         * been applied, so that the resulting view frame is from earlier in the view frame stack.
         * </p>
         * 
         * @param stepIndex
         *        The index from which to preview a step. This index is used to preview the result of steps that have
         *        already been applied, so that the resulting view frame is from earlier in the view frame stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIndex(Integer stepIndex);

        /**
         * <p>
         * A unique identifier for an interactive session that's currently open and ready for work. The action will be
         * performed on this session.
         * </p>
         * 
         * @param clientSessionId
         *        A unique identifier for an interactive session that's currently open and ready for work. The action
         *        will be performed on this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSessionId(String clientSessionId);

        /**
         * Sets the value of the ViewFrame property for this object.
         *
         * @param viewFrame
         *        The new value for the ViewFrame property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewFrame(ViewFrame viewFrame);

        /**
         * Sets the value of the ViewFrame property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ViewFrame.Builder} avoiding the need to
         * create one manually via {@link ViewFrame#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewFrame.Builder#build()} is called immediately and its result
         * is passed to {@link #viewFrame(ViewFrame)}.
         * 
         * @param viewFrame
         *        a consumer that will call methods on {@link ViewFrame.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewFrame(ViewFrame)
         */
        default Builder viewFrame(Consumer<ViewFrame.Builder> viewFrame) {
            return viewFrame(ViewFrame.builder().applyMutation(viewFrame).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private Boolean preview;

        private String name;

        private RecipeStep recipeStep;

        private Integer stepIndex;

        private String clientSessionId;

        private ViewFrame viewFrame;

        private BuilderImpl() {
        }

        private BuilderImpl(SendProjectSessionActionRequest model) {
            super(model);
            preview(model.preview);
            name(model.name);
            recipeStep(model.recipeStep);
            stepIndex(model.stepIndex);
            clientSessionId(model.clientSessionId);
            viewFrame(model.viewFrame);
        }

        public final Boolean getPreview() {
            return preview;
        }

        public final void setPreview(Boolean preview) {
            this.preview = preview;
        }

        @Override
        public final Builder preview(Boolean preview) {
            this.preview = preview;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecipeStep.Builder getRecipeStep() {
            return recipeStep != null ? recipeStep.toBuilder() : null;
        }

        public final void setRecipeStep(RecipeStep.BuilderImpl recipeStep) {
            this.recipeStep = recipeStep != null ? recipeStep.build() : null;
        }

        @Override
        public final Builder recipeStep(RecipeStep recipeStep) {
            this.recipeStep = recipeStep;
            return this;
        }

        public final Integer getStepIndex() {
            return stepIndex;
        }

        public final void setStepIndex(Integer stepIndex) {
            this.stepIndex = stepIndex;
        }

        @Override
        public final Builder stepIndex(Integer stepIndex) {
            this.stepIndex = stepIndex;
            return this;
        }

        public final String getClientSessionId() {
            return clientSessionId;
        }

        public final void setClientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
        }

        @Override
        public final Builder clientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
            return this;
        }

        public final ViewFrame.Builder getViewFrame() {
            return viewFrame != null ? viewFrame.toBuilder() : null;
        }

        public final void setViewFrame(ViewFrame.BuilderImpl viewFrame) {
            this.viewFrame = viewFrame != null ? viewFrame.build() : null;
        }

        @Override
        public final Builder viewFrame(ViewFrame viewFrame) {
            this.viewFrame = viewFrame;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendProjectSessionActionRequest build() {
            return new SendProjectSessionActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
