/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data being transformed during an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewFrame implements SdkPojo, Serializable, ToCopyableBuilder<ViewFrame.Builder, ViewFrame> {
    private static final SdkField<Integer> START_COLUMN_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartColumnIndex").getter(getter(ViewFrame::startColumnIndex)).setter(setter(Builder::startColumnIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartColumnIndex").build()).build();

    private static final SdkField<Integer> COLUMN_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ColumnRange").getter(getter(ViewFrame::columnRange)).setter(setter(Builder::columnRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnRange").build()).build();

    private static final SdkField<List<String>> HIDDEN_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HiddenColumns")
            .getter(getter(ViewFrame::hiddenColumns))
            .setter(setter(Builder::hiddenColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> START_ROW_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartRowIndex").getter(getter(ViewFrame::startRowIndex)).setter(setter(Builder::startRowIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartRowIndex").build()).build();

    private static final SdkField<Integer> ROW_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RowRange").getter(getter(ViewFrame::rowRange)).setter(setter(Builder::rowRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowRange").build()).build();

    private static final SdkField<String> ANALYTICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Analytics").getter(getter(ViewFrame::analyticsAsString)).setter(setter(Builder::analytics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analytics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_COLUMN_INDEX_FIELD,
            COLUMN_RANGE_FIELD, HIDDEN_COLUMNS_FIELD, START_ROW_INDEX_FIELD, ROW_RANGE_FIELD, ANALYTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer startColumnIndex;

    private final Integer columnRange;

    private final List<String> hiddenColumns;

    private final Integer startRowIndex;

    private final Integer rowRange;

    private final String analytics;

    private ViewFrame(BuilderImpl builder) {
        this.startColumnIndex = builder.startColumnIndex;
        this.columnRange = builder.columnRange;
        this.hiddenColumns = builder.hiddenColumns;
        this.startRowIndex = builder.startRowIndex;
        this.rowRange = builder.rowRange;
        this.analytics = builder.analytics;
    }

    /**
     * <p>
     * The starting index for the range of columns to return in the view frame.
     * </p>
     * 
     * @return The starting index for the range of columns to return in the view frame.
     */
    public final Integer startColumnIndex() {
        return startColumnIndex;
    }

    /**
     * <p>
     * The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code> value and
     * ignoring any columns in the <code>HiddenColumns</code> list.
     * </p>
     * 
     * @return The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code>
     *         value and ignoring any columns in the <code>HiddenColumns</code> list.
     */
    public final Integer columnRange() {
        return columnRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the HiddenColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHiddenColumns() {
        return hiddenColumns != null && !(hiddenColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of columns to hide in the view frame.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenColumns} method.
     * </p>
     * 
     * @return A list of columns to hide in the view frame.
     */
    public final List<String> hiddenColumns() {
        return hiddenColumns;
    }

    /**
     * <p>
     * The starting index for the range of rows to return in the view frame.
     * </p>
     * 
     * @return The starting index for the range of rows to return in the view frame.
     */
    public final Integer startRowIndex() {
        return startRowIndex;
    }

    /**
     * <p>
     * The number of rows to include in the view frame, beginning with the <code>StartRowIndex</code> value.
     * </p>
     * 
     * @return The number of rows to include in the view frame, beginning with the <code>StartRowIndex</code> value.
     */
    public final Integer rowRange() {
        return rowRange;
    }

    /**
     * <p>
     * Controls if analytics computation is enabled or disabled. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analytics} will
     * return {@link AnalyticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analyticsAsString}.
     * </p>
     * 
     * @return Controls if analytics computation is enabled or disabled. Enabled by default.
     * @see AnalyticsMode
     */
    public final AnalyticsMode analytics() {
        return AnalyticsMode.fromValue(analytics);
    }

    /**
     * <p>
     * Controls if analytics computation is enabled or disabled. Enabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analytics} will
     * return {@link AnalyticsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analyticsAsString}.
     * </p>
     * 
     * @return Controls if analytics computation is enabled or disabled. Enabled by default.
     * @see AnalyticsMode
     */
    public final String analyticsAsString() {
        return analytics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startColumnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(columnRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasHiddenColumns() ? hiddenColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startRowIndex());
        hashCode = 31 * hashCode + Objects.hashCode(rowRange());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewFrame)) {
            return false;
        }
        ViewFrame other = (ViewFrame) obj;
        return Objects.equals(startColumnIndex(), other.startColumnIndex()) && Objects.equals(columnRange(), other.columnRange())
                && hasHiddenColumns() == other.hasHiddenColumns() && Objects.equals(hiddenColumns(), other.hiddenColumns())
                && Objects.equals(startRowIndex(), other.startRowIndex()) && Objects.equals(rowRange(), other.rowRange())
                && Objects.equals(analyticsAsString(), other.analyticsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewFrame").add("StartColumnIndex", startColumnIndex()).add("ColumnRange", columnRange())
                .add("HiddenColumns", hasHiddenColumns() ? hiddenColumns() : null).add("StartRowIndex", startRowIndex())
                .add("RowRange", rowRange()).add("Analytics", analyticsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartColumnIndex":
            return Optional.ofNullable(clazz.cast(startColumnIndex()));
        case "ColumnRange":
            return Optional.ofNullable(clazz.cast(columnRange()));
        case "HiddenColumns":
            return Optional.ofNullable(clazz.cast(hiddenColumns()));
        case "StartRowIndex":
            return Optional.ofNullable(clazz.cast(startRowIndex()));
        case "RowRange":
            return Optional.ofNullable(clazz.cast(rowRange()));
        case "Analytics":
            return Optional.ofNullable(clazz.cast(analyticsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartColumnIndex", START_COLUMN_INDEX_FIELD);
        map.put("ColumnRange", COLUMN_RANGE_FIELD);
        map.put("HiddenColumns", HIDDEN_COLUMNS_FIELD);
        map.put("StartRowIndex", START_ROW_INDEX_FIELD);
        map.put("RowRange", ROW_RANGE_FIELD);
        map.put("Analytics", ANALYTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewFrame, T> g) {
        return obj -> g.apply((ViewFrame) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewFrame> {
        /**
         * <p>
         * The starting index for the range of columns to return in the view frame.
         * </p>
         * 
         * @param startColumnIndex
         *        The starting index for the range of columns to return in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startColumnIndex(Integer startColumnIndex);

        /**
         * <p>
         * The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code> value
         * and ignoring any columns in the <code>HiddenColumns</code> list.
         * </p>
         * 
         * @param columnRange
         *        The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code>
         *        value and ignoring any columns in the <code>HiddenColumns</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnRange(Integer columnRange);

        /**
         * <p>
         * A list of columns to hide in the view frame.
         * </p>
         * 
         * @param hiddenColumns
         *        A list of columns to hide in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenColumns(Collection<String> hiddenColumns);

        /**
         * <p>
         * A list of columns to hide in the view frame.
         * </p>
         * 
         * @param hiddenColumns
         *        A list of columns to hide in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenColumns(String... hiddenColumns);

        /**
         * <p>
         * The starting index for the range of rows to return in the view frame.
         * </p>
         * 
         * @param startRowIndex
         *        The starting index for the range of rows to return in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startRowIndex(Integer startRowIndex);

        /**
         * <p>
         * The number of rows to include in the view frame, beginning with the <code>StartRowIndex</code> value.
         * </p>
         * 
         * @param rowRange
         *        The number of rows to include in the view frame, beginning with the <code>StartRowIndex</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowRange(Integer rowRange);

        /**
         * <p>
         * Controls if analytics computation is enabled or disabled. Enabled by default.
         * </p>
         * 
         * @param analytics
         *        Controls if analytics computation is enabled or disabled. Enabled by default.
         * @see AnalyticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsMode
         */
        Builder analytics(String analytics);

        /**
         * <p>
         * Controls if analytics computation is enabled or disabled. Enabled by default.
         * </p>
         * 
         * @param analytics
         *        Controls if analytics computation is enabled or disabled. Enabled by default.
         * @see AnalyticsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsMode
         */
        Builder analytics(AnalyticsMode analytics);
    }

    static final class BuilderImpl implements Builder {
        private Integer startColumnIndex;

        private Integer columnRange;

        private List<String> hiddenColumns = DefaultSdkAutoConstructList.getInstance();

        private Integer startRowIndex;

        private Integer rowRange;

        private String analytics;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewFrame model) {
            startColumnIndex(model.startColumnIndex);
            columnRange(model.columnRange);
            hiddenColumns(model.hiddenColumns);
            startRowIndex(model.startRowIndex);
            rowRange(model.rowRange);
            analytics(model.analytics);
        }

        public final Integer getStartColumnIndex() {
            return startColumnIndex;
        }

        public final void setStartColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
        }

        @Override
        public final Builder startColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
            return this;
        }

        public final Integer getColumnRange() {
            return columnRange;
        }

        public final void setColumnRange(Integer columnRange) {
            this.columnRange = columnRange;
        }

        @Override
        public final Builder columnRange(Integer columnRange) {
            this.columnRange = columnRange;
            return this;
        }

        public final Collection<String> getHiddenColumns() {
            if (hiddenColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return hiddenColumns;
        }

        public final void setHiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
        }

        @Override
        public final Builder hiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenColumns(String... hiddenColumns) {
            hiddenColumns(Arrays.asList(hiddenColumns));
            return this;
        }

        public final Integer getStartRowIndex() {
            return startRowIndex;
        }

        public final void setStartRowIndex(Integer startRowIndex) {
            this.startRowIndex = startRowIndex;
        }

        @Override
        public final Builder startRowIndex(Integer startRowIndex) {
            this.startRowIndex = startRowIndex;
            return this;
        }

        public final Integer getRowRange() {
            return rowRange;
        }

        public final void setRowRange(Integer rowRange) {
            this.rowRange = rowRange;
        }

        @Override
        public final Builder rowRange(Integer rowRange) {
            this.rowRange = rowRange;
            return this;
        }

        public final String getAnalytics() {
            return analytics;
        }

        public final void setAnalytics(String analytics) {
            this.analytics = analytics;
        }

        @Override
        public final Builder analytics(String analytics) {
            this.analytics = analytics;
            return this;
        }

        @Override
        public final Builder analytics(AnalyticsMode analytics) {
            this.analytics(analytics == null ? null : analytics.toString());
            return this;
        }

        @Override
        public ViewFrame build() {
            return new ViewFrame(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
