/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseInputDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseInputDefinition> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueConnectionName").getter(DatabaseInputDefinition.getter(DatabaseInputDefinition::glueConnectionName)).setter(DatabaseInputDefinition.setter(Builder::glueConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueConnectionName").build()}).build();
    private static final SdkField<String> DATABASE_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseTableName").getter(DatabaseInputDefinition.getter(DatabaseInputDefinition::databaseTableName)).setter(DatabaseInputDefinition.setter(Builder::databaseTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseTableName").build()}).build();
    private static final SdkField<S3Location> TEMP_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TempDirectory").getter(DatabaseInputDefinition.getter(DatabaseInputDefinition::tempDirectory)).setter(DatabaseInputDefinition.setter(Builder::tempDirectory)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDirectory").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(DatabaseInputDefinition.getter(DatabaseInputDefinition::queryString)).setter(DatabaseInputDefinition.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD, DATABASE_TABLE_NAME_FIELD, TEMP_DIRECTORY_FIELD, QUERY_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatabaseInputDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String glueConnectionName;
    private final String databaseTableName;
    private final S3Location tempDirectory;
    private final String queryString;

    private DatabaseInputDefinition(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.databaseTableName = builder.databaseTableName;
        this.tempDirectory = builder.tempDirectory;
        this.queryString = builder.queryString;
    }

    public final String glueConnectionName() {
        return this.glueConnectionName;
    }

    public final String databaseTableName() {
        return this.databaseTableName;
    }

    public final S3Location tempDirectory() {
        return this.tempDirectory;
    }

    public final String queryString() {
        return this.queryString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tempDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInputDefinition)) {
            return false;
        }
        DatabaseInputDefinition other = (DatabaseInputDefinition)obj;
        return Objects.equals(this.glueConnectionName(), other.glueConnectionName()) && Objects.equals(this.databaseTableName(), other.databaseTableName()) && Objects.equals(this.tempDirectory(), other.tempDirectory()) && Objects.equals(this.queryString(), other.queryString());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseInputDefinition").add("GlueConnectionName", (Object)this.glueConnectionName()).add("DatabaseTableName", (Object)this.databaseTableName()).add("TempDirectory", (Object)this.tempDirectory()).add("QueryString", (Object)this.queryString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlueConnectionName": {
                return Optional.ofNullable(clazz.cast(this.glueConnectionName()));
            }
            case "DatabaseTableName": {
                return Optional.ofNullable(clazz.cast(this.databaseTableName()));
            }
            case "TempDirectory": {
                return Optional.ofNullable(clazz.cast(this.tempDirectory()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        map.put("DatabaseTableName", DATABASE_TABLE_NAME_FIELD);
        map.put("TempDirectory", TEMP_DIRECTORY_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseInputDefinition, T> g) {
        return obj -> g.apply((DatabaseInputDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String glueConnectionName;
        private String databaseTableName;
        private S3Location tempDirectory;
        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseInputDefinition model) {
            this.glueConnectionName(model.glueConnectionName);
            this.databaseTableName(model.databaseTableName);
            this.tempDirectory(model.tempDirectory);
            this.queryString(model.queryString);
        }

        public final String getGlueConnectionName() {
            return this.glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final String getDatabaseTableName() {
            return this.databaseTableName;
        }

        public final void setDatabaseTableName(String databaseTableName) {
            this.databaseTableName = databaseTableName;
        }

        @Override
        public final Builder databaseTableName(String databaseTableName) {
            this.databaseTableName = databaseTableName;
            return this;
        }

        public final S3Location.Builder getTempDirectory() {
            return this.tempDirectory != null ? this.tempDirectory.toBuilder() : null;
        }

        public final void setTempDirectory(S3Location.BuilderImpl tempDirectory) {
            this.tempDirectory = tempDirectory != null ? tempDirectory.build() : null;
        }

        @Override
        public final Builder tempDirectory(S3Location tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public DatabaseInputDefinition build() {
            return new DatabaseInputDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseInputDefinition> {
        public Builder glueConnectionName(String var1);

        public Builder databaseTableName(String var1);

        public Builder tempDirectory(S3Location var1);

        default public Builder tempDirectory(Consumer<S3Location.Builder> tempDirectory) {
            return this.tempDirectory((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(tempDirectory)).build());
        }

        public Builder queryString(String var1);
    }
}

