/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.RulesetItem;
import software.amazon.awssdk.services.databrew.model.RulesetItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRulesetsResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, ListRulesetsResponse> {
    private static final SdkField<List<RulesetItem>> RULESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rulesets").getter(ListRulesetsResponse.getter(ListRulesetsResponse::rulesets)).setter(ListRulesetsResponse.setter(Builder::rulesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rulesets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RulesetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRulesetsResponse.getter(ListRulesetsResponse::nextToken)).setter(ListRulesetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULESETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRulesetsResponse.memberNameToFieldInitializer();
    private final List<RulesetItem> rulesets;
    private final String nextToken;

    private ListRulesetsResponse(BuilderImpl builder) {
        super(builder);
        this.rulesets = builder.rulesets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRulesets() {
        return this.rulesets != null && !(this.rulesets instanceof SdkAutoConstructList);
    }

    public final List<RulesetItem> rulesets() {
        return this.rulesets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesets() ? this.rulesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesetsResponse)) {
            return false;
        }
        ListRulesetsResponse other = (ListRulesetsResponse)((Object)obj);
        return this.hasRulesets() == other.hasRulesets() && Objects.equals(this.rulesets(), other.rulesets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRulesetsResponse").add("Rulesets", this.hasRulesets() ? this.rulesets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rulesets": {
                return Optional.ofNullable(clazz.cast(this.rulesets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Rulesets", RULESETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRulesetsResponse, T> g) {
        return obj -> g.apply((ListRulesetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private List<RulesetItem> rulesets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesetsResponse model) {
            super(model);
            this.rulesets(model.rulesets);
            this.nextToken(model.nextToken);
        }

        public final List<RulesetItem.Builder> getRulesets() {
            List<RulesetItem.Builder> result = RulesetItemListCopier.copyToBuilder(this.rulesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRulesets(Collection<RulesetItem.BuilderImpl> rulesets) {
            this.rulesets = RulesetItemListCopier.copyFromBuilder(rulesets);
        }

        @Override
        public final Builder rulesets(Collection<RulesetItem> rulesets) {
            this.rulesets = RulesetItemListCopier.copy(rulesets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesets(RulesetItem ... rulesets) {
            this.rulesets(Arrays.asList(rulesets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesets(Consumer<RulesetItem.Builder> ... rulesets) {
            this.rulesets(Stream.of(rulesets).map(c -> (RulesetItem)((RulesetItem.Builder)RulesetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRulesetsResponse build() {
            return new ListRulesetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRulesetsResponse> {
        public Builder rulesets(Collection<RulesetItem> var1);

        public Builder rulesets(RulesetItem ... var1);

        public Builder rulesets(Consumer<RulesetItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

