/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.ManifestAction;
import software.amazon.awssdk.services.datasync.model.ManifestFormat;
import software.amazon.awssdk.services.datasync.model.SourceManifestConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManifestConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManifestConfig> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ManifestConfig.getter(ManifestConfig::actionAsString)).setter(ManifestConfig.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(ManifestConfig.getter(ManifestConfig::formatAsString)).setter(ManifestConfig.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<SourceManifestConfig> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ManifestConfig.getter(ManifestConfig::source)).setter(ManifestConfig.setter(Builder::source)).constructor(SourceManifestConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FORMAT_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Action", ACTION_FIELD);
            this.put("Format", FORMAT_FIELD);
            this.put("Source", SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String format;
    private final SourceManifestConfig source;

    private ManifestConfig(BuilderImpl builder) {
        this.action = builder.action;
        this.format = builder.format;
        this.source = builder.source;
    }

    public final ManifestAction action() {
        return ManifestAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final ManifestFormat format() {
        return ManifestFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final SourceManifestConfig source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestConfig)) {
            return false;
        }
        ManifestConfig other = (ManifestConfig)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"ManifestConfig").add("Action", (Object)this.actionAsString()).add("Format", (Object)this.formatAsString()).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManifestConfig, T> g) {
        return obj -> g.apply((ManifestConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String format;
        private SourceManifestConfig source;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestConfig model) {
            this.action(model.action);
            this.format(model.format);
            this.source(model.source);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ManifestAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final SourceManifestConfig.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(SourceManifestConfig.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(SourceManifestConfig source) {
            this.source = source;
            return this;
        }

        public ManifestConfig build() {
            return new ManifestConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManifestConfig> {
        public Builder action(String var1);

        public Builder action(ManifestAction var1);

        public Builder format(String var1);

        public Builder format(ManifestFormat var1);

        public Builder source(SourceManifestConfig var1);

        default public Builder source(Consumer<SourceManifestConfig.Builder> source) {
            return this.source((SourceManifestConfig)((SourceManifestConfig.Builder)SourceManifestConfig.builder().applyMutation(source)).build());
        }
    }
}

