/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskMode {
    BASIC("BASIC"),
    ENHANCED("ENHANCED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskMode> VALUE_MAP;
    private final String value;

    private TaskMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskMode> knownValues() {
        EnumSet<TaskMode> knownValues = EnumSet.allOf(TaskMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskMode.class, TaskMode::toString);
    }
}

