/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SmbAuthenticationType {
    NTLM("NTLM"),
    KERBEROS("KERBEROS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SmbAuthenticationType> VALUE_MAP;
    private final String value;

    private SmbAuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SmbAuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SmbAuthenticationType> knownValues() {
        EnumSet<SmbAuthenticationType> knownValues = EnumSet.allOf(SmbAuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SmbAuthenticationType.class, SmbAuthenticationType::toString);
    }
}

