/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.SmbMountOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FsxUpdateProtocolSmb
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FsxUpdateProtocolSmb> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(FsxUpdateProtocolSmb.getter(FsxUpdateProtocolSmb::domain)).setter(FsxUpdateProtocolSmb.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<SmbMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MountOptions").getter(FsxUpdateProtocolSmb.getter(FsxUpdateProtocolSmb::mountOptions)).setter(FsxUpdateProtocolSmb.setter(Builder::mountOptions)).constructor(SmbMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(FsxUpdateProtocolSmb.getter(FsxUpdateProtocolSmb::password)).setter(FsxUpdateProtocolSmb.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(FsxUpdateProtocolSmb.getter(FsxUpdateProtocolSmb::user)).setter(FsxUpdateProtocolSmb.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, MOUNT_OPTIONS_FIELD, PASSWORD_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FsxUpdateProtocolSmb.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final SmbMountOptions mountOptions;
    private final String password;
    private final String user;

    private FsxUpdateProtocolSmb(BuilderImpl builder) {
        this.domain = builder.domain;
        this.mountOptions = builder.mountOptions;
        this.password = builder.password;
        this.user = builder.user;
    }

    public final String domain() {
        return this.domain;
    }

    public final SmbMountOptions mountOptions() {
        return this.mountOptions;
    }

    public final String password() {
        return this.password;
    }

    public final String user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxUpdateProtocolSmb)) {
            return false;
        }
        FsxUpdateProtocolSmb other = (FsxUpdateProtocolSmb)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder((String)"FsxUpdateProtocolSmb").add("Domain", (Object)this.domain()).add("MountOptions", (Object)this.mountOptions()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("User", (Object)this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("MountOptions", MOUNT_OPTIONS_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("User", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FsxUpdateProtocolSmb, T> g) {
        return obj -> g.apply((FsxUpdateProtocolSmb)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private SmbMountOptions mountOptions;
        private String password;
        private String user;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxUpdateProtocolSmb model) {
            this.domain(model.domain);
            this.mountOptions(model.mountOptions);
            this.password(model.password);
            this.user(model.user);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SmbMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(SmbMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(SmbMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public FsxUpdateProtocolSmb build() {
            return new FsxUpdateProtocolSmb(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FsxUpdateProtocolSmb> {
        public Builder domain(String var1);

        public Builder mountOptions(SmbMountOptions var1);

        default public Builder mountOptions(Consumer<SmbMountOptions.Builder> mountOptions) {
            return this.mountOptions((SmbMountOptions)((SmbMountOptions.Builder)SmbMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder password(String var1);

        public Builder user(String var1);
    }
}

