/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse;
import software.amazon.awssdk.services.datasync.model.ResourceMetrics;

public class DescribeStorageSystemResourceMetricsIterable
implements SdkIterable<DescribeStorageSystemResourceMetricsResponse> {
    private final DataSyncClient client;
    private final DescribeStorageSystemResourceMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStorageSystemResourceMetricsIterable(DataSyncClient client, DescribeStorageSystemResourceMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStorageSystemResourceMetricsResponseFetcher();
    }

    public Iterator<DescribeStorageSystemResourceMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceMetrics> metrics() {
        Function<DescribeStorageSystemResourceMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStorageSystemResourceMetricsResponseFetcher
    implements SyncPageFetcher<DescribeStorageSystemResourceMetricsResponse> {
        private DescribeStorageSystemResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageSystemResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStorageSystemResourceMetricsResponse nextPage(DescribeStorageSystemResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageSystemResourceMetricsIterable.this.client.describeStorageSystemResourceMetrics(DescribeStorageSystemResourceMetricsIterable.this.firstRequest);
            }
            return DescribeStorageSystemResourceMetricsIterable.this.client.describeStorageSystemResourceMetrics((DescribeStorageSystemResourceMetricsRequest)((Object)DescribeStorageSystemResourceMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

