/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.DnsIpListCopier;
import software.amazon.awssdk.services.datasync.model.SmbAuthenticationType;
import software.amazon.awssdk.services.datasync.model.SmbMountOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationSmbRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationSmbRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::locationArn)).setter(UpdateLocationSmbRequest.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::subdirectory)).setter(UpdateLocationSmbRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::user)).setter(UpdateLocationSmbRequest.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::domain)).setter(UpdateLocationSmbRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::password)).setter(UpdateLocationSmbRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::agentArns)).setter(UpdateLocationSmbRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SmbMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MountOptions").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::mountOptions)).setter(UpdateLocationSmbRequest.setter(Builder::mountOptions)).constructor(SmbMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::authenticationTypeAsString)).setter(UpdateLocationSmbRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddresses").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::dnsIpAddresses)).setter(UpdateLocationSmbRequest.setter(Builder::dnsIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KERBEROS_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KerberosPrincipal").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::kerberosPrincipal)).setter(UpdateLocationSmbRequest.setter(Builder::kerberosPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosPrincipal").build()}).build();
    private static final SdkField<SdkBytes> KERBEROS_KEYTAB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("KerberosKeytab").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::kerberosKeytab)).setter(UpdateLocationSmbRequest.setter(Builder::kerberosKeytab)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosKeytab").build()}).build();
    private static final SdkField<SdkBytes> KERBEROS_KRB5_CONF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("KerberosKrb5Conf").getter(UpdateLocationSmbRequest.getter(UpdateLocationSmbRequest::kerberosKrb5Conf)).setter(UpdateLocationSmbRequest.setter(Builder::kerberosKrb5Conf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosKrb5Conf").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, SUBDIRECTORY_FIELD, USER_FIELD, DOMAIN_FIELD, PASSWORD_FIELD, AGENT_ARNS_FIELD, MOUNT_OPTIONS_FIELD, AUTHENTICATION_TYPE_FIELD, DNS_IP_ADDRESSES_FIELD, KERBEROS_PRINCIPAL_FIELD, KERBEROS_KEYTAB_FIELD, KERBEROS_KRB5_CONF_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLocationSmbRequest.memberNameToFieldInitializer();
    private final String locationArn;
    private final String subdirectory;
    private final String user;
    private final String domain;
    private final String password;
    private final List<String> agentArns;
    private final SmbMountOptions mountOptions;
    private final String authenticationType;
    private final List<String> dnsIpAddresses;
    private final String kerberosPrincipal;
    private final SdkBytes kerberosKeytab;
    private final SdkBytes kerberosKrb5Conf;

    private UpdateLocationSmbRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.user = builder.user;
        this.domain = builder.domain;
        this.password = builder.password;
        this.agentArns = builder.agentArns;
        this.mountOptions = builder.mountOptions;
        this.authenticationType = builder.authenticationType;
        this.dnsIpAddresses = builder.dnsIpAddresses;
        this.kerberosPrincipal = builder.kerberosPrincipal;
        this.kerberosKeytab = builder.kerberosKeytab;
        this.kerberosKrb5Conf = builder.kerberosKrb5Conf;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final String user() {
        return this.user;
    }

    public final String domain() {
        return this.domain;
    }

    public final String password() {
        return this.password;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final SmbMountOptions mountOptions() {
        return this.mountOptions;
    }

    public final SmbAuthenticationType authenticationType() {
        return SmbAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final boolean hasDnsIpAddresses() {
        return this.dnsIpAddresses != null && !(this.dnsIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddresses() {
        return this.dnsIpAddresses;
    }

    public final String kerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public final SdkBytes kerberosKeytab() {
        return this.kerberosKeytab;
    }

    public final SdkBytes kerberosKrb5Conf() {
        return this.kerberosKrb5Conf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosKeytab());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosKrb5Conf());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationSmbRequest)) {
            return false;
        }
        UpdateLocationSmbRequest other = (UpdateLocationSmbRequest)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.password(), other.password()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && this.hasDnsIpAddresses() == other.hasDnsIpAddresses() && Objects.equals(this.dnsIpAddresses(), other.dnsIpAddresses()) && Objects.equals(this.kerberosPrincipal(), other.kerberosPrincipal()) && Objects.equals(this.kerberosKeytab(), other.kerberosKeytab()) && Objects.equals(this.kerberosKrb5Conf(), other.kerberosKrb5Conf());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationSmbRequest").add("LocationArn", (Object)this.locationArn()).add("Subdirectory", (Object)this.subdirectory()).add("User", (Object)this.user()).add("Domain", (Object)this.domain()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("MountOptions", (Object)this.mountOptions()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("DnsIpAddresses", this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null).add("KerberosPrincipal", (Object)this.kerberosPrincipal()).add("KerberosKeytab", (Object)this.kerberosKeytab()).add("KerberosKrb5Conf", (Object)this.kerberosKrb5Conf()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "DnsIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddresses()));
            }
            case "KerberosPrincipal": {
                return Optional.ofNullable(clazz.cast(this.kerberosPrincipal()));
            }
            case "KerberosKeytab": {
                return Optional.ofNullable(clazz.cast(this.kerberosKeytab()));
            }
            case "KerberosKrb5Conf": {
                return Optional.ofNullable(clazz.cast(this.kerberosKrb5Conf()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("User", USER_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("MountOptions", MOUNT_OPTIONS_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("DnsIpAddresses", DNS_IP_ADDRESSES_FIELD);
        map.put("KerberosPrincipal", KERBEROS_PRINCIPAL_FIELD);
        map.put("KerberosKeytab", KERBEROS_KEYTAB_FIELD);
        map.put("KerberosKrb5Conf", KERBEROS_KRB5_CONF_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationSmbRequest, T> g) {
        return obj -> g.apply((UpdateLocationSmbRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private String subdirectory;
        private String user;
        private String domain;
        private String password;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private SmbMountOptions mountOptions;
        private String authenticationType;
        private List<String> dnsIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String kerberosPrincipal;
        private SdkBytes kerberosKeytab;
        private SdkBytes kerberosKrb5Conf;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationSmbRequest model) {
            super(model);
            this.locationArn(model.locationArn);
            this.subdirectory(model.subdirectory);
            this.user(model.user);
            this.domain(model.domain);
            this.password(model.password);
            this.agentArns(model.agentArns);
            this.mountOptions(model.mountOptions);
            this.authenticationType(model.authenticationType);
            this.dnsIpAddresses(model.dnsIpAddresses);
            this.kerberosPrincipal(model.kerberosPrincipal);
            this.kerberosKeytab(model.kerberosKeytab);
            this.kerberosKrb5Conf(model.kerberosKrb5Conf);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final SmbMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(SmbMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(SmbMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(SmbAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final Collection<String> getDnsIpAddresses() {
            if (this.dnsIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddresses;
        }

        public final void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpListCopier.copy(dnsIpAddresses);
        }

        @Override
        public final Builder dnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpListCopier.copy(dnsIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddresses(String ... dnsIpAddresses) {
            this.dnsIpAddresses(Arrays.asList(dnsIpAddresses));
            return this;
        }

        public final String getKerberosPrincipal() {
            return this.kerberosPrincipal;
        }

        public final void setKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
        }

        @Override
        public final Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public final ByteBuffer getKerberosKeytab() {
            return this.kerberosKeytab == null ? null : this.kerberosKeytab.asByteBuffer();
        }

        public final void setKerberosKeytab(ByteBuffer kerberosKeytab) {
            this.kerberosKeytab(kerberosKeytab == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)kerberosKeytab));
        }

        @Override
        public final Builder kerberosKeytab(SdkBytes kerberosKeytab) {
            this.kerberosKeytab = kerberosKeytab;
            return this;
        }

        public final ByteBuffer getKerberosKrb5Conf() {
            return this.kerberosKrb5Conf == null ? null : this.kerberosKrb5Conf.asByteBuffer();
        }

        public final void setKerberosKrb5Conf(ByteBuffer kerberosKrb5Conf) {
            this.kerberosKrb5Conf(kerberosKrb5Conf == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)kerberosKrb5Conf));
        }

        @Override
        public final Builder kerberosKrb5Conf(SdkBytes kerberosKrb5Conf) {
            this.kerberosKrb5Conf = kerberosKrb5Conf;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationSmbRequest build() {
            return new UpdateLocationSmbRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationSmbRequest> {
        public Builder locationArn(String var1);

        public Builder subdirectory(String var1);

        public Builder user(String var1);

        public Builder domain(String var1);

        public Builder password(String var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder mountOptions(SmbMountOptions var1);

        default public Builder mountOptions(Consumer<SmbMountOptions.Builder> mountOptions) {
            return this.mountOptions((SmbMountOptions)((SmbMountOptions.Builder)SmbMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(SmbAuthenticationType var1);

        public Builder dnsIpAddresses(Collection<String> var1);

        public Builder dnsIpAddresses(String ... var1);

        public Builder kerberosPrincipal(String var1);

        public Builder kerberosKeytab(SdkBytes var1);

        public Builder kerberosKrb5Conf(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

