/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SmbVersion {
    AUTOMATIC("AUTOMATIC"),
    SMB2("SMB2"),
    SMB3("SMB3"),
    SMB1("SMB1"),
    SMB2_0("SMB2_0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SmbVersion> VALUE_MAP;
    private final String value;

    private SmbVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SmbVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SmbVersion> knownValues() {
        EnumSet<SmbVersion> knownValues = EnumSet.allOf(SmbVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SmbVersion.class, SmbVersion::toString);
    }
}

