/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.ManifestConfig;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.services.datasync.model.TaskReportConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTaskExecutionRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, StartTaskExecutionRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::taskArn)).setter(StartTaskExecutionRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Options> OVERRIDE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideOptions").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::overrideOptions)).setter(StartTaskExecutionRequest.setter(Builder::overrideOptions)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideOptions").build()}).build();
    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Includes").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::includes)).setter(StartTaskExecutionRequest.setter(Builder::includes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Excludes").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::excludes)).setter(StartTaskExecutionRequest.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManifestConfig> MANIFEST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestConfig").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::manifestConfig)).setter(StartTaskExecutionRequest.setter(Builder::manifestConfig)).constructor(ManifestConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestConfig").build()}).build();
    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskReportConfig").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::taskReportConfig)).setter(StartTaskExecutionRequest.setter(Builder::taskReportConfig)).constructor(TaskReportConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartTaskExecutionRequest.getter(StartTaskExecutionRequest::tags)).setter(StartTaskExecutionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD, OVERRIDE_OPTIONS_FIELD, INCLUDES_FIELD, EXCLUDES_FIELD, MANIFEST_CONFIG_FIELD, TASK_REPORT_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartTaskExecutionRequest.memberNameToFieldInitializer();
    private final String taskArn;
    private final Options overrideOptions;
    private final List<FilterRule> includes;
    private final List<FilterRule> excludes;
    private final ManifestConfig manifestConfig;
    private final TaskReportConfig taskReportConfig;
    private final List<TagListEntry> tags;

    private StartTaskExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.overrideOptions = builder.overrideOptions;
        this.includes = builder.includes;
        this.excludes = builder.excludes;
        this.manifestConfig = builder.manifestConfig;
        this.taskReportConfig = builder.taskReportConfig;
        this.tags = builder.tags;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final Options overrideOptions() {
        return this.overrideOptions;
    }

    public final boolean hasIncludes() {
        return this.includes != null && !(this.includes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> includes() {
        return this.includes;
    }

    public final boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> excludes() {
        return this.excludes;
    }

    public final ManifestConfig manifestConfig() {
        return this.manifestConfig;
    }

    public final TaskReportConfig taskReportConfig() {
        return this.taskReportConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludes() ? this.includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludes() ? this.excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskReportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionRequest)) {
            return false;
        }
        StartTaskExecutionRequest other = (StartTaskExecutionRequest)((Object)obj);
        return Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.overrideOptions(), other.overrideOptions()) && this.hasIncludes() == other.hasIncludes() && Objects.equals(this.includes(), other.includes()) && this.hasExcludes() == other.hasExcludes() && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.manifestConfig(), other.manifestConfig()) && Objects.equals(this.taskReportConfig(), other.taskReportConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartTaskExecutionRequest").add("TaskArn", (Object)this.taskArn()).add("OverrideOptions", (Object)this.overrideOptions()).add("Includes", this.hasIncludes() ? this.includes() : null).add("Excludes", this.hasExcludes() ? this.excludes() : null).add("ManifestConfig", (Object)this.manifestConfig()).add("TaskReportConfig", (Object)this.taskReportConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "OverrideOptions": {
                return Optional.ofNullable(clazz.cast(this.overrideOptions()));
            }
            case "Includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "ManifestConfig": {
                return Optional.ofNullable(clazz.cast(this.manifestConfig()));
            }
            case "TaskReportConfig": {
                return Optional.ofNullable(clazz.cast(this.taskReportConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("OverrideOptions", OVERRIDE_OPTIONS_FIELD);
        map.put("Includes", INCLUDES_FIELD);
        map.put("Excludes", EXCLUDES_FIELD);
        map.put("ManifestConfig", MANIFEST_CONFIG_FIELD);
        map.put("TaskReportConfig", TASK_REPORT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTaskExecutionRequest, T> g) {
        return obj -> g.apply((StartTaskExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String taskArn;
        private Options overrideOptions;
        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private ManifestConfig manifestConfig;
        private TaskReportConfig taskReportConfig;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskExecutionRequest model) {
            super(model);
            this.taskArn(model.taskArn);
            this.overrideOptions(model.overrideOptions);
            this.includes(model.includes);
            this.excludes(model.excludes);
            this.manifestConfig(model.manifestConfig);
            this.taskReportConfig(model.taskReportConfig);
            this.tags(model.tags);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Options.Builder getOverrideOptions() {
            return this.overrideOptions != null ? this.overrideOptions.toBuilder() : null;
        }

        public final void setOverrideOptions(Options.BuilderImpl overrideOptions) {
            this.overrideOptions = overrideOptions != null ? overrideOptions.build() : null;
        }

        @Override
        public final Builder overrideOptions(Options overrideOptions) {
            this.overrideOptions = overrideOptions;
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule ... includes) {
            this.includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder> ... includes) {
            this.includes(Stream.of(includes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManifestConfig.Builder getManifestConfig() {
            return this.manifestConfig != null ? this.manifestConfig.toBuilder() : null;
        }

        public final void setManifestConfig(ManifestConfig.BuilderImpl manifestConfig) {
            this.manifestConfig = manifestConfig != null ? manifestConfig.build() : null;
        }

        @Override
        public final Builder manifestConfig(ManifestConfig manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return this.taskReportConfig != null ? this.taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskExecutionRequest build() {
            return new StartTaskExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTaskExecutionRequest> {
        public Builder taskArn(String var1);

        public Builder overrideOptions(Options var1);

        default public Builder overrideOptions(Consumer<Options.Builder> overrideOptions) {
            return this.overrideOptions((Options)((Options.Builder)Options.builder().applyMutation(overrideOptions)).build());
        }

        public Builder includes(Collection<FilterRule> var1);

        public Builder includes(FilterRule ... var1);

        public Builder includes(Consumer<FilterRule.Builder> ... var1);

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder manifestConfig(ManifestConfig var1);

        default public Builder manifestConfig(Consumer<ManifestConfig.Builder> manifestConfig) {
            return this.manifestConfig((ManifestConfig)((ManifestConfig.Builder)ManifestConfig.builder().applyMutation(manifestConfig)).build());
        }

        public Builder taskReportConfig(TaskReportConfig var1);

        default public Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return this.taskReportConfig((TaskReportConfig)((TaskReportConfig.Builder)TaskReportConfig.builder().applyMutation(taskReportConfig)).build());
        }

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

