/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.PredictionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateAssetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetRequest.getter(CreateAssetRequest::clientToken)).setter(CreateAssetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAssetRequest.getter(CreateAssetRequest::description)).setter(CreateAssetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateAssetRequest.getter(CreateAssetRequest::domainIdentifier)).setter(CreateAssetRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalIdentifier").getter(CreateAssetRequest.getter(CreateAssetRequest::externalIdentifier)).setter(CreateAssetRequest.setter(Builder::externalIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build()}).build();
    private static final SdkField<List<FormInput>> FORMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsInput").getter(CreateAssetRequest.getter(CreateAssetRequest::formsInput)).setter(CreateAssetRequest.setter(Builder::formsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(CreateAssetRequest.getter(CreateAssetRequest::glossaryTerms)).setter(CreateAssetRequest.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssetRequest.getter(CreateAssetRequest::name)).setter(CreateAssetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectIdentifier").getter(CreateAssetRequest.getter(CreateAssetRequest::owningProjectIdentifier)).setter(CreateAssetRequest.setter(Builder::owningProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build()}).build();
    private static final SdkField<PredictionConfiguration> PREDICTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictionConfiguration").getter(CreateAssetRequest.getter(CreateAssetRequest::predictionConfiguration)).setter(CreateAssetRequest.setter(Builder::predictionConfiguration)).constructor(PredictionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionConfiguration").build()}).build();
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeIdentifier").getter(CreateAssetRequest.getter(CreateAssetRequest::typeIdentifier)).setter(CreateAssetRequest.setter(Builder::typeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(CreateAssetRequest.getter(CreateAssetRequest::typeRevision)).setter(CreateAssetRequest.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, EXTERNAL_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, GLOSSARY_TERMS_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, PREDICTION_CONFIGURATION_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("externalIdentifier", EXTERNAL_IDENTIFIER_FIELD);
            this.put("formsInput", FORMS_INPUT_FIELD);
            this.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
            this.put("predictionConfiguration", PREDICTION_CONFIGURATION_FIELD);
            this.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
            this.put("typeRevision", TYPE_REVISION_FIELD);
        }
    });
    private final String clientToken;
    private final String description;
    private final String domainIdentifier;
    private final String externalIdentifier;
    private final List<FormInput> formsInput;
    private final List<String> glossaryTerms;
    private final String name;
    private final String owningProjectIdentifier;
    private final PredictionConfiguration predictionConfiguration;
    private final String typeIdentifier;
    private final String typeRevision;

    private CreateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.externalIdentifier = builder.externalIdentifier;
        this.formsInput = builder.formsInput;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.predictionConfiguration = builder.predictionConfiguration;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String externalIdentifier() {
        return this.externalIdentifier;
    }

    public final boolean hasFormsInput() {
        return this.formsInput != null && !(this.formsInput instanceof SdkAutoConstructList);
    }

    public final List<FormInput> formsInput() {
        return this.formsInput;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectIdentifier() {
        return this.owningProjectIdentifier;
    }

    public final PredictionConfiguration predictionConfiguration() {
        return this.predictionConfiguration;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsInput() ? this.formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetRequest)) {
            return false;
        }
        CreateAssetRequest other = (CreateAssetRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.externalIdentifier(), other.externalIdentifier()) && this.hasFormsInput() == other.hasFormsInput() && Objects.equals(this.formsInput(), other.formsInput()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectIdentifier(), other.owningProjectIdentifier()) && Objects.equals(this.predictionConfiguration(), other.predictionConfiguration()) && Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("ExternalIdentifier", (Object)(this.externalIdentifier() == null ? null : "*** Sensitive Data Redacted ***")).add("FormsInput", (Object)(this.formsInput() == null ? null : "*** Sensitive Data Redacted ***")).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectIdentifier", (Object)this.owningProjectIdentifier()).add("PredictionConfiguration", (Object)this.predictionConfiguration()).add("TypeIdentifier", (Object)this.typeIdentifier()).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "externalIdentifier": {
                return Optional.ofNullable(clazz.cast(this.externalIdentifier()));
            }
            case "formsInput": {
                return Optional.ofNullable(clazz.cast(this.formsInput()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.owningProjectIdentifier()));
            }
            case "predictionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.predictionConfiguration()));
            }
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetRequest, T> g) {
        return obj -> g.apply((CreateAssetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainIdentifier;
        private String externalIdentifier;
        private List<FormInput> formsInput = DefaultSdkAutoConstructList.getInstance();
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String owningProjectIdentifier;
        private PredictionConfiguration predictionConfiguration;
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.externalIdentifier(model.externalIdentifier);
            this.formsInput(model.formsInput);
            this.glossaryTerms(model.glossaryTerms);
            this.name(model.name);
            this.owningProjectIdentifier(model.owningProjectIdentifier);
            this.predictionConfiguration(model.predictionConfiguration);
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getExternalIdentifier() {
            return this.externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Collection<FormInput.BuilderImpl> formsInput) {
            this.formsInput = FormInputListCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Collection<FormInput> formsInput) {
            this.formsInput = FormInputListCopier.copy(formsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(FormInput ... formsInput) {
            this.formsInput(Arrays.asList(formsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(Consumer<FormInput.Builder> ... formsInput) {
            this.formsInput(Stream.of(formsInput).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return this.owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final PredictionConfiguration.Builder getPredictionConfiguration() {
            return this.predictionConfiguration != null ? this.predictionConfiguration.toBuilder() : null;
        }

        public final void setPredictionConfiguration(PredictionConfiguration.BuilderImpl predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration != null ? predictionConfiguration.build() : null;
        }

        @Override
        public final Builder predictionConfiguration(PredictionConfiguration predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration;
            return this;
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetRequest build() {
            return new CreateAssetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder externalIdentifier(String var1);

        public Builder formsInput(Collection<FormInput> var1);

        public Builder formsInput(FormInput ... var1);

        public Builder formsInput(Consumer<FormInput.Builder> ... var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder name(String var1);

        public Builder owningProjectIdentifier(String var1);

        public Builder predictionConfiguration(PredictionConfiguration var1);

        default public Builder predictionConfiguration(Consumer<PredictionConfiguration.Builder> predictionConfiguration) {
            return this.predictionConfiguration((PredictionConfiguration)((PredictionConfiguration.Builder)PredictionConfiguration.builder().applyMutation(predictionConfiguration)).build());
        }

        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

