/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormTypeStatus;
import software.amazon.awssdk.services.datazone.model.Model;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFormTypeRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateFormTypeRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::description)).setter(CreateFormTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::domainIdentifier)).setter(CreateFormTypeRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Model> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("model").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::model)).setter(CreateFormTypeRequest.setter(Builder::model)).constructor(Model::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::name)).setter(CreateFormTypeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectIdentifier").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::owningProjectIdentifier)).setter(CreateFormTypeRequest.setter(Builder::owningProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateFormTypeRequest.getter(CreateFormTypeRequest::statusAsString)).setter(CreateFormTypeRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, MODEL_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("model", MODEL_FIELD);
            this.put("name", NAME_FIELD);
            this.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String description;
    private final String domainIdentifier;
    private final Model model;
    private final String name;
    private final String owningProjectIdentifier;
    private final String status;

    private CreateFormTypeRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.model = builder.model;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.status = builder.status;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Model model() {
        return this.model;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectIdentifier() {
        return this.owningProjectIdentifier;
    }

    public final FormTypeStatus status() {
        return FormTypeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFormTypeRequest)) {
            return false;
        }
        CreateFormTypeRequest other = (CreateFormTypeRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectIdentifier(), other.owningProjectIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFormTypeRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectIdentifier", (Object)this.owningProjectIdentifier()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.owningProjectIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFormTypeRequest, T> g) {
        return obj -> g.apply((CreateFormTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private Model model;
        private String name;
        private String owningProjectIdentifier;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFormTypeRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.model(model.model);
            this.name(model.name);
            this.owningProjectIdentifier(model.owningProjectIdentifier);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Model.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        public final void setModel(Model.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(Model model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return this.owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FormTypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFormTypeRequest build() {
            return new CreateFormTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFormTypeRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder model(Model var1);

        default public Builder model(Consumer<Model.Builder> model) {
            return this.model((Model)((Model.Builder)Model.builder().applyMutation(model)).build());
        }

        public Builder name(String var1);

        public Builder owningProjectIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(FormTypeStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

