/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DeploymentMessagesListCopier;
import software.amazon.awssdk.services.datazone.model.DeploymentStatus;
import software.amazon.awssdk.services.datazone.model.DeploymentType;
import software.amazon.awssdk.services.datazone.model.EnvironmentError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(Deployment.getter(Deployment::deploymentId)).setter(Deployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(Deployment.getter(Deployment::deploymentStatusAsString)).setter(Deployment.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(Deployment.getter(Deployment::deploymentTypeAsString)).setter(Deployment.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<EnvironmentError> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureReason").getter(Deployment.getter(Deployment::failureReason)).setter(Deployment.setter(Builder::failureReason)).constructor(EnvironmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Boolean> IS_DEPLOYMENT_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDeploymentComplete").getter(Deployment.getter(Deployment::isDeploymentComplete)).setter(Deployment.setter(Builder::isDeploymentComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDeploymentComplete").build()}).build();
    private static final SdkField<List<String>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(Deployment.getter(Deployment::messages)).setter(Deployment.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_TYPE_FIELD, FAILURE_REASON_FIELD, IS_DEPLOYMENT_COMPLETE_FIELD, MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deploymentId", DEPLOYMENT_ID_FIELD);
            this.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
            this.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
            this.put("failureReason", FAILURE_REASON_FIELD);
            this.put("isDeploymentComplete", IS_DEPLOYMENT_COMPLETE_FIELD);
            this.put("messages", MESSAGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String deploymentStatus;
    private final String deploymentType;
    private final EnvironmentError failureReason;
    private final Boolean isDeploymentComplete;
    private final List<String> messages;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.failureReason = builder.failureReason;
        this.isDeploymentComplete = builder.isDeploymentComplete;
        this.messages = builder.messages;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final EnvironmentError failureReason() {
        return this.failureReason;
    }

    public final Boolean isDeploymentComplete() {
        return this.isDeploymentComplete;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<String> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDeploymentComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.isDeploymentComplete(), other.isDeploymentComplete()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages());
    }

    public final String toString() {
        return ToString.builder((String)"Deployment").add("DeploymentId", (Object)this.deploymentId()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("FailureReason", (Object)this.failureReason()).add("IsDeploymentComplete", (Object)this.isDeploymentComplete()).add("Messages", this.hasMessages() ? this.messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "isDeploymentComplete": {
                return Optional.ofNullable(clazz.cast(this.isDeploymentComplete()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String deploymentStatus;
        private String deploymentType;
        private EnvironmentError failureReason;
        private Boolean isDeploymentComplete;
        private List<String> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.deploymentId(model.deploymentId);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentType(model.deploymentType);
            this.failureReason(model.failureReason);
            this.isDeploymentComplete(model.isDeploymentComplete);
            this.messages(model.messages);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final EnvironmentError.Builder getFailureReason() {
            return this.failureReason != null ? this.failureReason.toBuilder() : null;
        }

        public final void setFailureReason(EnvironmentError.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(EnvironmentError failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Boolean getIsDeploymentComplete() {
            return this.isDeploymentComplete;
        }

        public final void setIsDeploymentComplete(Boolean isDeploymentComplete) {
            this.isDeploymentComplete = isDeploymentComplete;
        }

        @Override
        public final Builder isDeploymentComplete(Boolean isDeploymentComplete) {
            this.isDeploymentComplete = isDeploymentComplete;
            return this;
        }

        public final Collection<String> getMessages() {
            if (this.messages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messages;
        }

        public final void setMessages(Collection<String> messages) {
            this.messages = DeploymentMessagesListCopier.copy(messages);
        }

        @Override
        public final Builder messages(Collection<String> messages) {
            this.messages = DeploymentMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(String ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder deploymentId(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder failureReason(EnvironmentError var1);

        default public Builder failureReason(Consumer<EnvironmentError.Builder> failureReason) {
            return this.failureReason((EnvironmentError)((EnvironmentError.Builder)EnvironmentError.builder().applyMutation(failureReason)).build());
        }

        public Builder isDeploymentComplete(Boolean var1);

        public Builder messages(Collection<String> var1);

        public Builder messages(String ... var1);
    }
}

