/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.Timezone;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleConfiguration> {
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schedule").getter(ScheduleConfiguration.getter(ScheduleConfiguration::schedule)).setter(ScheduleConfiguration.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(ScheduleConfiguration.getter(ScheduleConfiguration::timezoneAsString)).setter(ScheduleConfiguration.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_FIELD, TIMEZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("schedule", SCHEDULE_FIELD);
            this.put("timezone", TIMEZONE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String schedule;
    private final String timezone;

    private ScheduleConfiguration(BuilderImpl builder) {
        this.schedule = builder.schedule;
        this.timezone = builder.timezone;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final Timezone timezone() {
        return Timezone.fromValue(this.timezone);
    }

    public final String timezoneAsString() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezoneAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfiguration)) {
            return false;
        }
        ScheduleConfiguration other = (ScheduleConfiguration)obj;
        return Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.timezoneAsString(), other.timezoneAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleConfiguration").add("Schedule", (Object)this.schedule()).add("Timezone", (Object)this.timezoneAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezoneAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfiguration, T> g) {
        return obj -> g.apply((ScheduleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schedule;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfiguration model) {
            this.schedule(model.schedule);
            this.timezone(model.timezone);
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public final Builder timezone(Timezone timezone) {
            this.timezone(timezone == null ? null : timezone.toString());
            return this;
        }

        public ScheduleConfiguration build() {
            return new ScheduleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleConfiguration> {
        public Builder schedule(String var1);

        public Builder timezone(String var1);

        public Builder timezone(Timezone var1);
    }
}

