/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetEntityType {
    DOMAIN_UNIT("DOMAIN_UNIT"),
    ENVIRONMENT_BLUEPRINT_CONFIGURATION("ENVIRONMENT_BLUEPRINT_CONFIGURATION"),
    ENVIRONMENT_PROFILE("ENVIRONMENT_PROFILE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetEntityType> VALUE_MAP;
    private final String value;

    private TargetEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetEntityType> knownValues() {
        EnumSet<TargetEntityType> knownValues = EnumSet.allOf(TargetEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetEntityType.class, TargetEntityType::toString);
    }
}

