/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication configuration patch of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfigurationPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfigurationPatch.Builder, AuthenticationConfigurationPatch> {
    private static final SdkField<BasicAuthenticationCredentials> BASIC_AUTHENTICATION_CREDENTIALS_FIELD = SdkField
            .<BasicAuthenticationCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("basicAuthenticationCredentials")
            .getter(getter(AuthenticationConfigurationPatch::basicAuthenticationCredentials))
            .setter(setter(Builder::basicAuthenticationCredentials))
            .constructor(BasicAuthenticationCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthenticationCredentials")
                    .build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(AuthenticationConfigurationPatch::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASIC_AUTHENTICATION_CREDENTIALS_FIELD, SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BasicAuthenticationCredentials basicAuthenticationCredentials;

    private final String secretArn;

    private AuthenticationConfigurationPatch(BuilderImpl builder) {
        this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The basic authentication credentials of a connection.
     * </p>
     * 
     * @return The basic authentication credentials of a connection.
     */
    public final BasicAuthenticationCredentials basicAuthenticationCredentials() {
        return basicAuthenticationCredentials;
    }

    /**
     * <p>
     * The secret ARN of a connection.
     * </p>
     * 
     * @return The secret ARN of a connection.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthenticationCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationPatch)) {
            return false;
        }
        AuthenticationConfigurationPatch other = (AuthenticationConfigurationPatch) obj;
        return Objects.equals(basicAuthenticationCredentials(), other.basicAuthenticationCredentials())
                && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AuthenticationConfigurationPatch")
                .add("BasicAuthenticationCredentials",
                        basicAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "basicAuthenticationCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthenticationCredentials()));
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("basicAuthenticationCredentials", BASIC_AUTHENTICATION_CREDENTIALS_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationPatch, T> g) {
        return obj -> g.apply((AuthenticationConfigurationPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfigurationPatch> {
        /**
         * <p>
         * The basic authentication credentials of a connection.
         * </p>
         * 
         * @param basicAuthenticationCredentials
         *        The basic authentication credentials of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials);

        /**
         * <p>
         * The basic authentication credentials of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthenticationCredentials.Builder}
         * avoiding the need to create one manually via {@link BasicAuthenticationCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthenticationCredentials.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #basicAuthenticationCredentials(BasicAuthenticationCredentials)}.
         * 
         * @param basicAuthenticationCredentials
         *        a consumer that will call methods on {@link BasicAuthenticationCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthenticationCredentials(BasicAuthenticationCredentials)
         */
        default Builder basicAuthenticationCredentials(
                Consumer<BasicAuthenticationCredentials.Builder> basicAuthenticationCredentials) {
            return basicAuthenticationCredentials(BasicAuthenticationCredentials.builder()
                    .applyMutation(basicAuthenticationCredentials).build());
        }

        /**
         * <p>
         * The secret ARN of a connection.
         * </p>
         * 
         * @param secretArn
         *        The secret ARN of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private BasicAuthenticationCredentials basicAuthenticationCredentials;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationPatch model) {
            basicAuthenticationCredentials(model.basicAuthenticationCredentials);
            secretArn(model.secretArn);
        }

        public final BasicAuthenticationCredentials.Builder getBasicAuthenticationCredentials() {
            return basicAuthenticationCredentials != null ? basicAuthenticationCredentials.toBuilder() : null;
        }

        public final void setBasicAuthenticationCredentials(
                BasicAuthenticationCredentials.BuilderImpl basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials != null ? basicAuthenticationCredentials.build()
                    : null;
        }

        @Override
        public final Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public AuthenticationConfigurationPatch build() {
            return new AuthenticationConfigurationPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
