/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionPropertiesOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionPropertiesOutput.Builder, ConnectionPropertiesOutput> {
    private static final SdkField<AthenaPropertiesOutput> ATHENA_PROPERTIES_FIELD = SdkField
            .<AthenaPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("athenaProperties")
            .getter(getter(ConnectionPropertiesOutput::athenaProperties)).setter(setter(Builder::athenaProperties))
            .constructor(AthenaPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()).build();

    private static final SdkField<GluePropertiesOutput> GLUE_PROPERTIES_FIELD = SdkField
            .<GluePropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("glueProperties")
            .getter(getter(ConnectionPropertiesOutput::glueProperties)).setter(setter(Builder::glueProperties))
            .constructor(GluePropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()).build();

    private static final SdkField<HyperPodPropertiesOutput> HYPER_POD_PROPERTIES_FIELD = SdkField
            .<HyperPodPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("hyperPodProperties")
            .getter(getter(ConnectionPropertiesOutput::hyperPodProperties)).setter(setter(Builder::hyperPodProperties))
            .constructor(HyperPodPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperPodProperties").build())
            .build();

    private static final SdkField<IamPropertiesOutput> IAM_PROPERTIES_FIELD = SdkField
            .<IamPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("iamProperties")
            .getter(getter(ConnectionPropertiesOutput::iamProperties)).setter(setter(Builder::iamProperties))
            .constructor(IamPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()).build();

    private static final SdkField<RedshiftPropertiesOutput> REDSHIFT_PROPERTIES_FIELD = SdkField
            .<RedshiftPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("redshiftProperties")
            .getter(getter(ConnectionPropertiesOutput::redshiftProperties)).setter(setter(Builder::redshiftProperties))
            .constructor(RedshiftPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build())
            .build();

    private static final SdkField<SparkEmrPropertiesOutput> SPARK_EMR_PROPERTIES_FIELD = SdkField
            .<SparkEmrPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("sparkEmrProperties")
            .getter(getter(ConnectionPropertiesOutput::sparkEmrProperties)).setter(setter(Builder::sparkEmrProperties))
            .constructor(SparkEmrPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build())
            .build();

    private static final SdkField<SparkGluePropertiesOutput> SPARK_GLUE_PROPERTIES_FIELD = SdkField
            .<SparkGluePropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("sparkGlueProperties")
            .getter(getter(ConnectionPropertiesOutput::sparkGlueProperties)).setter(setter(Builder::sparkGlueProperties))
            .constructor(SparkGluePropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkGlueProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD,
            GLUE_PROPERTIES_FIELD, HYPER_POD_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD,
            SPARK_EMR_PROPERTIES_FIELD, SPARK_GLUE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AthenaPropertiesOutput athenaProperties;

    private final GluePropertiesOutput glueProperties;

    private final HyperPodPropertiesOutput hyperPodProperties;

    private final IamPropertiesOutput iamProperties;

    private final RedshiftPropertiesOutput redshiftProperties;

    private final SparkEmrPropertiesOutput sparkEmrProperties;

    private final SparkGluePropertiesOutput sparkGlueProperties;

    private final Type type;

    private ConnectionPropertiesOutput(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.hyperPodProperties = builder.hyperPodProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.sparkGlueProperties = builder.sparkGlueProperties;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @return The Amazon Athena properties of a connection.
     */
    public final AthenaPropertiesOutput athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @return The Amazon Web Services Glue properties of a connection.
     */
    public final GluePropertiesOutput glueProperties() {
        return glueProperties;
    }

    /**
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @return The hyper pod properties of a connection.
     */
    public final HyperPodPropertiesOutput hyperPodProperties() {
        return hyperPodProperties;
    }

    /**
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @return The IAM properties of a connection.
     */
    public final IamPropertiesOutput iamProperties() {
        return iamProperties;
    }

    /**
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @return The Amazon Redshift properties of a connection.
     */
    public final RedshiftPropertiesOutput redshiftProperties() {
        return redshiftProperties;
    }

    /**
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @return The Spark EMR properties of a connection.
     */
    public final SparkEmrPropertiesOutput sparkEmrProperties() {
        return sparkEmrProperties;
    }

    /**
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @return The Spark Amazon Web Services Glue properties of a connection.
     */
    public final SparkGluePropertiesOutput sparkGlueProperties() {
        return sparkGlueProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hyperPodProperties());
        hashCode = 31 * hashCode + Objects.hashCode(iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkEmrProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkGlueProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesOutput)) {
            return false;
        }
        ConnectionPropertiesOutput other = (ConnectionPropertiesOutput) obj;
        return Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(glueProperties(), other.glueProperties())
                && Objects.equals(hyperPodProperties(), other.hyperPodProperties())
                && Objects.equals(iamProperties(), other.iamProperties())
                && Objects.equals(redshiftProperties(), other.redshiftProperties())
                && Objects.equals(sparkEmrProperties(), other.sparkEmrProperties())
                && Objects.equals(sparkGlueProperties(), other.sparkGlueProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionPropertiesOutput").add("AthenaProperties", athenaProperties())
                .add("GlueProperties", glueProperties()).add("HyperPodProperties", hyperPodProperties())
                .add("IamProperties", iamProperties()).add("RedshiftProperties", redshiftProperties())
                .add("SparkEmrProperties", sparkEmrProperties()).add("SparkGlueProperties", sparkGlueProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "glueProperties":
            return Optional.ofNullable(clazz.cast(glueProperties()));
        case "hyperPodProperties":
            return Optional.ofNullable(clazz.cast(hyperPodProperties()));
        case "iamProperties":
            return Optional.ofNullable(clazz.cast(iamProperties()));
        case "redshiftProperties":
            return Optional.ofNullable(clazz.cast(redshiftProperties()));
        case "sparkEmrProperties":
            return Optional.ofNullable(clazz.cast(sparkEmrProperties()));
        case "sparkGlueProperties":
            return Optional.ofNullable(clazz.cast(sparkGlueProperties()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection.
     */
    public static ConnectionPropertiesOutput fromAthenaProperties(AthenaPropertiesOutput athenaProperties) {
        return builder().athenaProperties(athenaProperties).build();
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection.
     */
    public static ConnectionPropertiesOutput fromAthenaProperties(Consumer<AthenaPropertiesOutput.Builder> athenaProperties) {
        AthenaPropertiesOutput.Builder builder = AthenaPropertiesOutput.builder();
        athenaProperties.accept(builder);
        return fromAthenaProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesOutput fromGlueProperties(GluePropertiesOutput glueProperties) {
        return builder().glueProperties(glueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesOutput fromGlueProperties(Consumer<GluePropertiesOutput.Builder> glueProperties) {
        GluePropertiesOutput.Builder builder = GluePropertiesOutput.builder();
        glueProperties.accept(builder);
        return fromGlueProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #hyperPodProperties()} initialized to the given value.
     *
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @param hyperPodProperties
     *        The hyper pod properties of a connection.
     */
    public static ConnectionPropertiesOutput fromHyperPodProperties(HyperPodPropertiesOutput hyperPodProperties) {
        return builder().hyperPodProperties(hyperPodProperties).build();
    }

    /**
     * Create an instance of this class with {@link #hyperPodProperties()} initialized to the given value.
     *
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @param hyperPodProperties
     *        The hyper pod properties of a connection.
     */
    public static ConnectionPropertiesOutput fromHyperPodProperties(Consumer<HyperPodPropertiesOutput.Builder> hyperPodProperties) {
        HyperPodPropertiesOutput.Builder builder = HyperPodPropertiesOutput.builder();
        hyperPodProperties.accept(builder);
        return fromHyperPodProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection.
     */
    public static ConnectionPropertiesOutput fromIamProperties(IamPropertiesOutput iamProperties) {
        return builder().iamProperties(iamProperties).build();
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection.
     */
    public static ConnectionPropertiesOutput fromIamProperties(Consumer<IamPropertiesOutput.Builder> iamProperties) {
        IamPropertiesOutput.Builder builder = IamPropertiesOutput.builder();
        iamProperties.accept(builder);
        return fromIamProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection.
     */
    public static ConnectionPropertiesOutput fromRedshiftProperties(RedshiftPropertiesOutput redshiftProperties) {
        return builder().redshiftProperties(redshiftProperties).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection.
     */
    public static ConnectionPropertiesOutput fromRedshiftProperties(Consumer<RedshiftPropertiesOutput.Builder> redshiftProperties) {
        RedshiftPropertiesOutput.Builder builder = RedshiftPropertiesOutput.builder();
        redshiftProperties.accept(builder);
        return fromRedshiftProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection.
     */
    public static ConnectionPropertiesOutput fromSparkEmrProperties(SparkEmrPropertiesOutput sparkEmrProperties) {
        return builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection.
     */
    public static ConnectionPropertiesOutput fromSparkEmrProperties(Consumer<SparkEmrPropertiesOutput.Builder> sparkEmrProperties) {
        SparkEmrPropertiesOutput.Builder builder = SparkEmrPropertiesOutput.builder();
        sparkEmrProperties.accept(builder);
        return fromSparkEmrProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkGlueProperties()} initialized to the given value.
     *
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param sparkGlueProperties
     *        The Spark Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesOutput fromSparkGlueProperties(SparkGluePropertiesOutput sparkGlueProperties) {
        return builder().sparkGlueProperties(sparkGlueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkGlueProperties()} initialized to the given value.
     *
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param sparkGlueProperties
     *        The Spark Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesOutput fromSparkGlueProperties(
            Consumer<SparkGluePropertiesOutput.Builder> sparkGlueProperties) {
        SparkGluePropertiesOutput.Builder builder = SparkGluePropertiesOutput.builder();
        sparkGlueProperties.accept(builder);
        return fromSparkGlueProperties(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("glueProperties", GLUE_PROPERTIES_FIELD);
        map.put("hyperPodProperties", HYPER_POD_PROPERTIES_FIELD);
        map.put("iamProperties", IAM_PROPERTIES_FIELD);
        map.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
        map.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
        map.put("sparkGlueProperties", SPARK_GLUE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesOutput, T> g) {
        return obj -> g.apply((ConnectionPropertiesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionPropertiesOutput> {
        /**
         * <p>
         * The Amazon Athena properties of a connection.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(AthenaPropertiesOutput athenaProperties);

        /**
         * <p>
         * The Amazon Athena properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaPropertiesOutput.Builder} avoiding
         * the need to create one manually via {@link AthenaPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaPropertiesOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaProperties(AthenaPropertiesOutput)}.
         * 
         * @param athenaProperties
         *        a consumer that will call methods on {@link AthenaPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaProperties(AthenaPropertiesOutput)
         */
        default Builder athenaProperties(Consumer<AthenaPropertiesOutput.Builder> athenaProperties) {
            return athenaProperties(AthenaPropertiesOutput.builder().applyMutation(athenaProperties).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection.
         * </p>
         * 
         * @param glueProperties
         *        The Amazon Web Services Glue properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueProperties(GluePropertiesOutput glueProperties);

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link GluePropertiesOutput.Builder} avoiding
         * the need to create one manually via {@link GluePropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GluePropertiesOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #glueProperties(GluePropertiesOutput)}.
         * 
         * @param glueProperties
         *        a consumer that will call methods on {@link GluePropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueProperties(GluePropertiesOutput)
         */
        default Builder glueProperties(Consumer<GluePropertiesOutput.Builder> glueProperties) {
            return glueProperties(GluePropertiesOutput.builder().applyMutation(glueProperties).build());
        }

        /**
         * <p>
         * The hyper pod properties of a connection.
         * </p>
         * 
         * @param hyperPodProperties
         *        The hyper pod properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperPodProperties(HyperPodPropertiesOutput hyperPodProperties);

        /**
         * <p>
         * The hyper pod properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link HyperPodPropertiesOutput.Builder}
         * avoiding the need to create one manually via {@link HyperPodPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperPodPropertiesOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #hyperPodProperties(HyperPodPropertiesOutput)}.
         * 
         * @param hyperPodProperties
         *        a consumer that will call methods on {@link HyperPodPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperPodProperties(HyperPodPropertiesOutput)
         */
        default Builder hyperPodProperties(Consumer<HyperPodPropertiesOutput.Builder> hyperPodProperties) {
            return hyperPodProperties(HyperPodPropertiesOutput.builder().applyMutation(hyperPodProperties).build());
        }

        /**
         * <p>
         * The IAM properties of a connection.
         * </p>
         * 
         * @param iamProperties
         *        The IAM properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamProperties(IamPropertiesOutput iamProperties);

        /**
         * <p>
         * The IAM properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamPropertiesOutput.Builder} avoiding the
         * need to create one manually via {@link IamPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamPropertiesOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #iamProperties(IamPropertiesOutput)}.
         * 
         * @param iamProperties
         *        a consumer that will call methods on {@link IamPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamProperties(IamPropertiesOutput)
         */
        default Builder iamProperties(Consumer<IamPropertiesOutput.Builder> iamProperties) {
            return iamProperties(IamPropertiesOutput.builder().applyMutation(iamProperties).build());
        }

        /**
         * <p>
         * The Amazon Redshift properties of a connection.
         * </p>
         * 
         * @param redshiftProperties
         *        The Amazon Redshift properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftProperties(RedshiftPropertiesOutput redshiftProperties);

        /**
         * <p>
         * The Amazon Redshift properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftPropertiesOutput.Builder}
         * avoiding the need to create one manually via {@link RedshiftPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftPropertiesOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftProperties(RedshiftPropertiesOutput)}.
         * 
         * @param redshiftProperties
         *        a consumer that will call methods on {@link RedshiftPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftProperties(RedshiftPropertiesOutput)
         */
        default Builder redshiftProperties(Consumer<RedshiftPropertiesOutput.Builder> redshiftProperties) {
            return redshiftProperties(RedshiftPropertiesOutput.builder().applyMutation(redshiftProperties).build());
        }

        /**
         * <p>
         * The Spark EMR properties of a connection.
         * </p>
         * 
         * @param sparkEmrProperties
         *        The Spark EMR properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkEmrProperties(SparkEmrPropertiesOutput sparkEmrProperties);

        /**
         * <p>
         * The Spark EMR properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkEmrPropertiesOutput.Builder}
         * avoiding the need to create one manually via {@link SparkEmrPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkEmrPropertiesOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkEmrProperties(SparkEmrPropertiesOutput)}.
         * 
         * @param sparkEmrProperties
         *        a consumer that will call methods on {@link SparkEmrPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkEmrProperties(SparkEmrPropertiesOutput)
         */
        default Builder sparkEmrProperties(Consumer<SparkEmrPropertiesOutput.Builder> sparkEmrProperties) {
            return sparkEmrProperties(SparkEmrPropertiesOutput.builder().applyMutation(sparkEmrProperties).build());
        }

        /**
         * <p>
         * The Spark Amazon Web Services Glue properties of a connection.
         * </p>
         * 
         * @param sparkGlueProperties
         *        The Spark Amazon Web Services Glue properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkGlueProperties(SparkGluePropertiesOutput sparkGlueProperties);

        /**
         * <p>
         * The Spark Amazon Web Services Glue properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkGluePropertiesOutput.Builder}
         * avoiding the need to create one manually via {@link SparkGluePropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkGluePropertiesOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkGlueProperties(SparkGluePropertiesOutput)}.
         * 
         * @param sparkGlueProperties
         *        a consumer that will call methods on {@link SparkGluePropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkGlueProperties(SparkGluePropertiesOutput)
         */
        default Builder sparkGlueProperties(Consumer<SparkGluePropertiesOutput.Builder> sparkGlueProperties) {
            return sparkGlueProperties(SparkGluePropertiesOutput.builder().applyMutation(sparkGlueProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AthenaPropertiesOutput athenaProperties;

        private GluePropertiesOutput glueProperties;

        private HyperPodPropertiesOutput hyperPodProperties;

        private IamPropertiesOutput iamProperties;

        private RedshiftPropertiesOutput redshiftProperties;

        private SparkEmrPropertiesOutput sparkEmrProperties;

        private SparkGluePropertiesOutput sparkGlueProperties;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesOutput model) {
            athenaProperties(model.athenaProperties);
            glueProperties(model.glueProperties);
            hyperPodProperties(model.hyperPodProperties);
            iamProperties(model.iamProperties);
            redshiftProperties(model.redshiftProperties);
            sparkEmrProperties(model.sparkEmrProperties);
            sparkGlueProperties(model.sparkGlueProperties);
        }

        public final AthenaPropertiesOutput.Builder getAthenaProperties() {
            return athenaProperties != null ? athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesOutput.BuilderImpl athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesOutput athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesOutput.Builder getGlueProperties() {
            return glueProperties != null ? glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesOutput.BuilderImpl glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesOutput glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final HyperPodPropertiesOutput.Builder getHyperPodProperties() {
            return hyperPodProperties != null ? hyperPodProperties.toBuilder() : null;
        }

        public final void setHyperPodProperties(HyperPodPropertiesOutput.BuilderImpl hyperPodProperties) {
            Object oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties != null ? hyperPodProperties.build() : null;
            handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
        }

        @Override
        public final Builder hyperPodProperties(HyperPodPropertiesOutput hyperPodProperties) {
            Object oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties;
            handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
            return this;
        }

        public final IamPropertiesOutput.Builder getIamProperties() {
            return iamProperties != null ? iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesOutput.BuilderImpl iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesOutput iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesOutput.Builder getRedshiftProperties() {
            return redshiftProperties != null ? redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesOutput.BuilderImpl redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesOutput redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final SparkEmrPropertiesOutput.Builder getSparkEmrProperties() {
            return sparkEmrProperties != null ? sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesOutput.BuilderImpl sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesOutput sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        public final SparkGluePropertiesOutput.Builder getSparkGlueProperties() {
            return sparkGlueProperties != null ? sparkGlueProperties.toBuilder() : null;
        }

        public final void setSparkGlueProperties(SparkGluePropertiesOutput.BuilderImpl sparkGlueProperties) {
            Object oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties != null ? sparkGlueProperties.build() : null;
            handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
        }

        @Override
        public final Builder sparkGlueProperties(SparkGluePropertiesOutput sparkGlueProperties) {
            Object oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties;
            handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
            return this;
        }

        @Override
        public ConnectionPropertiesOutput build() {
            return new ConnectionPropertiesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConnectionPropertiesOutput#type()
     */
    public enum Type {
        ATHENA_PROPERTIES,

        GLUE_PROPERTIES,

        HYPER_POD_PROPERTIES,

        IAM_PROPERTIES,

        REDSHIFT_PROPERTIES,

        SPARK_EMR_PROPERTIES,

        SPARK_GLUE_PROPERTIES,

        UNKNOWN_TO_SDK_VERSION
    }
}
