/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<List<FormInput>> ASSET_FORMS_INPUT_FIELD = SdkField
            .<List<FormInput>> builder(MarshallingType.LIST)
            .memberName("assetFormsInput")
            .getter(getter(CreateDataSourceRequest::assetFormsInput))
            .setter(setter(Builder::assetFormsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsInput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DataSourceConfigurationInput> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateDataSourceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CONNECTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionIdentifier").getter(getter(CreateDataSourceRequest::connectionIdentifier))
            .setter(setter(Builder::connectionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionIdentifier").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateDataSourceRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enableSetting").getter(getter(CreateDataSourceRequest::enableSettingAsString))
            .setter(setter(Builder::enableSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(CreateDataSourceRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(CreateDataSourceRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()).build();

    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publishOnImport").getter(getter(CreateDataSourceRequest::publishOnImport))
            .setter(setter(Builder::publishOnImport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()).build();

    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField
            .<RecommendationConfiguration> builder(MarshallingType.SDK_POJO).memberName("recommendation")
            .getter(getter(CreateDataSourceRequest::recommendation)).setter(setter(Builder::recommendation))
            .constructor(RecommendationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(CreateDataSourceRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateDataSourceRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_INPUT_FIELD,
            CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, CONNECTION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD,
            ENABLE_SETTING_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROJECT_IDENTIFIER_FIELD, PUBLISH_ON_IMPORT_FIELD,
            RECOMMENDATION_FIELD, SCHEDULE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FormInput> assetFormsInput;

    private final String clientToken;

    private final DataSourceConfigurationInput configuration;

    private final String connectionIdentifier;

    private final String description;

    private final String domainIdentifier;

    private final String enableSetting;

    private final String environmentIdentifier;

    private final String name;

    private final String projectIdentifier;

    private final Boolean publishOnImport;

    private final RecommendationConfiguration recommendation;

    private final ScheduleConfiguration schedule;

    private final String type;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.assetFormsInput = builder.assetFormsInput;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.connectionIdentifier = builder.connectionIdentifier;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.enableSetting = builder.enableSetting;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.projectIdentifier = builder.projectIdentifier;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.schedule = builder.schedule;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetFormsInput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetFormsInput() {
        return assetFormsInput != null && !(assetFormsInput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata forms that are to be attached to the assets that this data source works with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetFormsInput} method.
     * </p>
     * 
     * @return The metadata forms that are to be attached to the assets that this data source works with.
     */
    public final List<FormInput> assetFormsInput() {
        return assetFormsInput;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
     * <code>redshiftRunConfiguration</code>.
     * </p>
     * 
     * @return Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code>
     *         or <code>redshiftRunConfiguration</code>.
     */
    public final DataSourceConfigurationInput configuration() {
        return configuration;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionIdentifier() {
        return connectionIdentifier;
    }

    /**
     * <p>
     * The description of the data source.
     * </p>
     * 
     * @return The description of the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where the data source is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where the data source is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(enableSetting);
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final String enableSettingAsString() {
        return enableSetting;
    }

    /**
     * <p>
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     * </p>
     * 
     * @return The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project in which you want to add this data source.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project in which you want to add this data source.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    /**
     * <p>
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically
     * published to the catalog.
     * </p>
     * 
     * @return Specifies whether the assets that this data source creates in the inventory are to be also automatically
     *         published to the catalog.
     */
    public final Boolean publishOnImport() {
        return publishOnImport;
    }

    /**
     * <p>
     * Specifies whether the business name generation is to be enabled for this data source.
     * </p>
     * 
     * @return Specifies whether the business name generation is to be enabled for this data source.
     */
    public final RecommendationConfiguration recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * The schedule of the data source runs.
     * </p>
     * 
     * @return The schedule of the data source runs.
     */
    public final ScheduleConfiguration schedule() {
        return schedule;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * 
     * @return The type of the data source.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetFormsInput() ? assetFormsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(connectionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return hasAssetFormsInput() == other.hasAssetFormsInput() && Objects.equals(assetFormsInput(), other.assetFormsInput())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(connectionIdentifier(), other.connectionIdentifier())
                && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(enableSettingAsString(), other.enableSettingAsString())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(projectIdentifier(), other.projectIdentifier())
                && Objects.equals(publishOnImport(), other.publishOnImport())
                && Objects.equals(recommendation(), other.recommendation()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest")
                .add("AssetFormsInput", assetFormsInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientToken", clientToken()).add("Configuration", configuration())
                .add("ConnectionIdentifier", connectionIdentifier())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("EnableSetting", enableSettingAsString())
                .add("EnvironmentIdentifier", environmentIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectIdentifier", projectIdentifier()).add("PublishOnImport", publishOnImport())
                .add("Recommendation", recommendation())
                .add("Schedule", schedule() == null ? null : "*** Sensitive Data Redacted ***").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetFormsInput":
            return Optional.ofNullable(clazz.cast(assetFormsInput()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "connectionIdentifier":
            return Optional.ofNullable(clazz.cast(connectionIdentifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "enableSetting":
            return Optional.ofNullable(clazz.cast(enableSettingAsString()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        case "publishOnImport":
            return Optional.ofNullable(clazz.cast(publishOnImport()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetFormsInput", ASSET_FORMS_INPUT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("connectionIdentifier", CONNECTION_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("enableSetting", ENABLE_SETTING_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        map.put("publishOnImport", PUBLISH_ON_IMPORT_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * The metadata forms that are to be attached to the assets that this data source works with.
         * </p>
         * 
         * @param assetFormsInput
         *        The metadata forms that are to be attached to the assets that this data source works with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsInput(Collection<FormInput> assetFormsInput);

        /**
         * <p>
         * The metadata forms that are to be attached to the assets that this data source works with.
         * </p>
         * 
         * @param assetFormsInput
         *        The metadata forms that are to be attached to the assets that this data source works with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsInput(FormInput... assetFormsInput);

        /**
         * <p>
         * The metadata forms that are to be attached to the assets that this data source works with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder#build()} is called immediately and
         * its result is passed to {@link #assetFormsInput(List<FormInput>)}.
         * 
         * @param assetFormsInput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetFormsInput(java.util.Collection<FormInput>)
         */
        Builder assetFormsInput(Consumer<FormInput.Builder>... assetFormsInput);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
         * <code>redshiftRunConfiguration</code>.
         * </p>
         * 
         * @param configuration
         *        Specifies the configuration of the data source. It can be set to either
         *        <code>glueRunConfiguration</code> or <code>redshiftRunConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfigurationInput configuration);

        /**
         * <p>
         * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
         * <code>redshiftRunConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(DataSourceConfigurationInput)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfigurationInput)
         */
        default Builder configuration(Consumer<DataSourceConfigurationInput.Builder> configuration) {
            return configuration(DataSourceConfigurationInput.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionIdentifier
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionIdentifier(String connectionIdentifier);

        /**
         * <p>
         * The description of the data source.
         * </p>
         * 
         * @param description
         *        The description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain where the data source is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where the data source is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(String enableSetting);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(EnableSetting enableSetting);

        /**
         * <p>
         * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         * </p>
         * 
         * @param environmentIdentifier
         *        The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the Amazon DataZone project in which you want to add this data source.
         * </p>
         * 
         * @param projectIdentifier
         *        The identifier of the Amazon DataZone project in which you want to add this data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        /**
         * <p>
         * Specifies whether the assets that this data source creates in the inventory are to be also automatically
         * published to the catalog.
         * </p>
         * 
         * @param publishOnImport
         *        Specifies whether the assets that this data source creates in the inventory are to be also
         *        automatically published to the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishOnImport(Boolean publishOnImport);

        /**
         * <p>
         * Specifies whether the business name generation is to be enabled for this data source.
         * </p>
         * 
         * @param recommendation
         *        Specifies whether the business name generation is to be enabled for this data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(RecommendationConfiguration recommendation);

        /**
         * <p>
         * Specifies whether the business name generation is to be enabled for this data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RecommendationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendation(RecommendationConfiguration)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link RecommendationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(RecommendationConfiguration)
         */
        default Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return recommendation(RecommendationConfiguration.builder().applyMutation(recommendation).build());
        }

        /**
         * <p>
         * The schedule of the data source runs.
         * </p>
         * 
         * @param schedule
         *        The schedule of the data source runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ScheduleConfiguration schedule);

        /**
         * <p>
         * The schedule of the data source runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(ScheduleConfiguration)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(ScheduleConfiguration)
         */
        default Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return schedule(ScheduleConfiguration.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<FormInput> assetFormsInput = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private DataSourceConfigurationInput configuration;

        private String connectionIdentifier;

        private String description;

        private String domainIdentifier;

        private String enableSetting;

        private String environmentIdentifier;

        private String name;

        private String projectIdentifier;

        private Boolean publishOnImport;

        private RecommendationConfiguration recommendation;

        private ScheduleConfiguration schedule;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            assetFormsInput(model.assetFormsInput);
            clientToken(model.clientToken);
            configuration(model.configuration);
            connectionIdentifier(model.connectionIdentifier);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            enableSetting(model.enableSetting);
            environmentIdentifier(model.environmentIdentifier);
            name(model.name);
            projectIdentifier(model.projectIdentifier);
            publishOnImport(model.publishOnImport);
            recommendation(model.recommendation);
            schedule(model.schedule);
            type(model.type);
        }

        public final List<FormInput.Builder> getAssetFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.assetFormsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsInput(Collection<FormInput.BuilderImpl> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copyFromBuilder(assetFormsInput);
        }

        @Override
        public final Builder assetFormsInput(Collection<FormInput> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copy(assetFormsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(FormInput... assetFormsInput) {
            assetFormsInput(Arrays.asList(assetFormsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(Consumer<FormInput.Builder>... assetFormsInput) {
            assetFormsInput(Stream.of(assetFormsInput).map(c -> FormInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataSourceConfigurationInput.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationInput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationInput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConnectionIdentifier() {
            return connectionIdentifier;
        }

        public final void setConnectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
        }

        @Override
        public final Builder connectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnableSetting() {
            return enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
