/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateListingChangeSetRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateListingChangeSetRequest.Builder, CreateListingChangeSetRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CreateListingChangeSetRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateListingChangeSetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateListingChangeSetRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(CreateListingChangeSetRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(CreateListingChangeSetRequest::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(CreateListingChangeSetRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final String clientToken;

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityRevision;

    private final String entityType;

    private CreateListingChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
    }

    /**
     * <p>
     * Specifies whether to publish or unpublish a listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to publish or unpublish a listing.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether to publish or unpublish a listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to publish or unpublish a listing.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The revision of an asset.
     * </p>
     * 
     * @return The revision of an asset.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * <p>
     * The type of an entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of an entity.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of an entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of an entity.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListingChangeSetRequest)) {
            return false;
        }
        CreateListingChangeSetRequest other = (CreateListingChangeSetRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityRevision(), other.entityRevision())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateListingChangeSetRequest").add("Action", actionAsString())
                .add("ClientToken", clientToken()).add("DomainIdentifier", domainIdentifier())
                .add("EntityIdentifier", entityIdentifier()).add("EntityRevision", entityRevision())
                .add("EntityType", entityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateListingChangeSetRequest, T> g) {
        return obj -> g.apply((CreateListingChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateListingChangeSetRequest> {
        /**
         * <p>
         * Specifies whether to publish or unpublish a listing.
         * </p>
         * 
         * @param action
         *        Specifies whether to publish or unpublish a listing.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether to publish or unpublish a listing.
         * </p>
         * 
         * @param action
         *        Specifies whether to publish or unpublish a listing.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The revision of an asset.
         * </p>
         * 
         * @param entityRevision
         *        The revision of an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The type of an entity.
         * </p>
         * 
         * @param entityType
         *        The type of an entity.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of an entity.
         * </p>
         * 
         * @param entityType
         *        The type of an entity.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String action;

        private String clientToken;

        private String domainIdentifier;

        private String entityIdentifier;

        private String entityRevision;

        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListingChangeSetRequest model) {
            super(model);
            action(model.action);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityRevision(model.entityRevision);
            entityType(model.entityType);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListingChangeSetRequest build() {
            return new CreateListingChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
