/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionGrantRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateSubscriptionGrantRequest.Builder, CreateSubscriptionGrantRequest> {
    private static final SdkField<List<AssetTargetNameMap>> ASSET_TARGET_NAMES_FIELD = SdkField
            .<List<AssetTargetNameMap>> builder(MarshallingType.LIST)
            .memberName("assetTargetNames")
            .getter(getter(CreateSubscriptionGrantRequest::assetTargetNames))
            .setter(setter(Builder::assetTargetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetTargetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetTargetNameMap> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetTargetNameMap::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSubscriptionGrantRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateSubscriptionGrantRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(CreateSubscriptionGrantRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<GrantedEntityInput> GRANTED_ENTITY_FIELD = SdkField
            .<GrantedEntityInput> builder(MarshallingType.SDK_POJO).memberName("grantedEntity")
            .getter(getter(CreateSubscriptionGrantRequest::grantedEntity)).setter(setter(Builder::grantedEntity))
            .constructor(GrantedEntityInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedEntity").build()).build();

    private static final SdkField<String> SUBSCRIPTION_TARGET_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("subscriptionTargetIdentifier")
            .getter(getter(CreateSubscriptionGrantRequest::subscriptionTargetIdentifier))
            .setter(setter(Builder::subscriptionTargetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TARGET_NAMES_FIELD,
            CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, GRANTED_ENTITY_FIELD,
            SUBSCRIPTION_TARGET_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssetTargetNameMap> assetTargetNames;

    private final String clientToken;

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final GrantedEntityInput grantedEntity;

    private final String subscriptionTargetIdentifier;

    private CreateSubscriptionGrantRequest(BuilderImpl builder) {
        super(builder);
        this.assetTargetNames = builder.assetTargetNames;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.grantedEntity = builder.grantedEntity;
        this.subscriptionTargetIdentifier = builder.subscriptionTargetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetTargetNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetTargetNames() {
        return assetTargetNames != null && !(assetTargetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the assets for which the subscription grant is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetTargetNames} method.
     * </p>
     * 
     * @return The names of the assets for which the subscription grant is created.
     */
    public final List<AssetTargetNameMap> assetTargetNames() {
        return assetTargetNames;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the subscription grant is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the subscription grant is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment in which the subscription grant is created.
     * </p>
     * 
     * @return The ID of the environment in which the subscription grant is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The entity to which the subscription is to be granted.
     * </p>
     * 
     * @return The entity to which the subscription is to be granted.
     */
    public final GrantedEntityInput grantedEntity() {
        return grantedEntity;
    }

    /**
     * <p>
     * The ID of the subscription target for which the subscription grant is created.
     * </p>
     * 
     * @return The ID of the subscription target for which the subscription grant is created.
     */
    public final String subscriptionTargetIdentifier() {
        return subscriptionTargetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetTargetNames() ? assetTargetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(grantedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTargetIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionGrantRequest)) {
            return false;
        }
        CreateSubscriptionGrantRequest other = (CreateSubscriptionGrantRequest) obj;
        return hasAssetTargetNames() == other.hasAssetTargetNames()
                && Objects.equals(assetTargetNames(), other.assetTargetNames())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier())
                && Objects.equals(grantedEntity(), other.grantedEntity())
                && Objects.equals(subscriptionTargetIdentifier(), other.subscriptionTargetIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionGrantRequest")
                .add("AssetTargetNames", hasAssetTargetNames() ? assetTargetNames() : null).add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("EnvironmentIdentifier", environmentIdentifier())
                .add("GrantedEntity", grantedEntity()).add("SubscriptionTargetIdentifier", subscriptionTargetIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetTargetNames":
            return Optional.ofNullable(clazz.cast(assetTargetNames()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "grantedEntity":
            return Optional.ofNullable(clazz.cast(grantedEntity()));
        case "subscriptionTargetIdentifier":
            return Optional.ofNullable(clazz.cast(subscriptionTargetIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetTargetNames", ASSET_TARGET_NAMES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("grantedEntity", GRANTED_ENTITY_FIELD);
        map.put("subscriptionTargetIdentifier", SUBSCRIPTION_TARGET_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionGrantRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriptionGrantRequest> {
        /**
         * <p>
         * The names of the assets for which the subscription grant is created.
         * </p>
         * 
         * @param assetTargetNames
         *        The names of the assets for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetTargetNames(Collection<AssetTargetNameMap> assetTargetNames);

        /**
         * <p>
         * The names of the assets for which the subscription grant is created.
         * </p>
         * 
         * @param assetTargetNames
         *        The names of the assets for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetTargetNames(AssetTargetNameMap... assetTargetNames);

        /**
         * <p>
         * The names of the assets for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.AssetTargetNameMap.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.AssetTargetNameMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.AssetTargetNameMap.Builder#build()} is called
         * immediately and its result is passed to {@link #assetTargetNames(List<AssetTargetNameMap>)}.
         * 
         * @param assetTargetNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.AssetTargetNameMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetTargetNames(java.util.Collection<AssetTargetNameMap>)
         */
        Builder assetTargetNames(Consumer<AssetTargetNameMap.Builder>... assetTargetNames);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the subscription grant is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment in which the subscription grant is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment in which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The entity to which the subscription is to be granted.
         * </p>
         * 
         * @param grantedEntity
         *        The entity to which the subscription is to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedEntity(GrantedEntityInput grantedEntity);

        /**
         * <p>
         * The entity to which the subscription is to be granted.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrantedEntityInput.Builder} avoiding the
         * need to create one manually via {@link GrantedEntityInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrantedEntityInput.Builder#build()} is called immediately and its
         * result is passed to {@link #grantedEntity(GrantedEntityInput)}.
         * 
         * @param grantedEntity
         *        a consumer that will call methods on {@link GrantedEntityInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantedEntity(GrantedEntityInput)
         */
        default Builder grantedEntity(Consumer<GrantedEntityInput.Builder> grantedEntity) {
            return grantedEntity(GrantedEntityInput.builder().applyMutation(grantedEntity).build());
        }

        /**
         * <p>
         * The ID of the subscription target for which the subscription grant is created.
         * </p>
         * 
         * @param subscriptionTargetIdentifier
         *        The ID of the subscription target for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetIdentifier(String subscriptionTargetIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<AssetTargetNameMap> assetTargetNames = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String domainIdentifier;

        private String environmentIdentifier;

        private GrantedEntityInput grantedEntity;

        private String subscriptionTargetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionGrantRequest model) {
            super(model);
            assetTargetNames(model.assetTargetNames);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            grantedEntity(model.grantedEntity);
            subscriptionTargetIdentifier(model.subscriptionTargetIdentifier);
        }

        public final List<AssetTargetNameMap.Builder> getAssetTargetNames() {
            List<AssetTargetNameMap.Builder> result = AssetTargetNamesCopier.copyToBuilder(this.assetTargetNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetTargetNames(Collection<AssetTargetNameMap.BuilderImpl> assetTargetNames) {
            this.assetTargetNames = AssetTargetNamesCopier.copyFromBuilder(assetTargetNames);
        }

        @Override
        public final Builder assetTargetNames(Collection<AssetTargetNameMap> assetTargetNames) {
            this.assetTargetNames = AssetTargetNamesCopier.copy(assetTargetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTargetNames(AssetTargetNameMap... assetTargetNames) {
            assetTargetNames(Arrays.asList(assetTargetNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTargetNames(Consumer<AssetTargetNameMap.Builder>... assetTargetNames) {
            assetTargetNames(Stream.of(assetTargetNames).map(c -> AssetTargetNameMap.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final GrantedEntityInput.Builder getGrantedEntity() {
            return grantedEntity != null ? grantedEntity.toBuilder() : null;
        }

        public final void setGrantedEntity(GrantedEntityInput.BuilderImpl grantedEntity) {
            this.grantedEntity = grantedEntity != null ? grantedEntity.build() : null;
        }

        @Override
        public final Builder grantedEntity(GrantedEntityInput grantedEntity) {
            this.grantedEntity = grantedEntity;
            return this;
        }

        public final String getSubscriptionTargetIdentifier() {
            return subscriptionTargetIdentifier;
        }

        public final void setSubscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
            this.subscriptionTargetIdentifier = subscriptionTargetIdentifier;
        }

        @Override
        public final Builder subscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
            this.subscriptionTargetIdentifier = subscriptionTargetIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionGrantRequest build() {
            return new CreateSubscriptionGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
