/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductItem implements SdkPojo, Serializable, ToCopyableBuilder<DataProductItem.Builder, DataProductItem> {
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(DataProductItem::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(DataProductItem::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> ITEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("itemType").getter(getter(DataProductItem::itemTypeAsString)).setter(setter(Builder::itemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemType").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(DataProductItem::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOSSARY_TERMS_FIELD,
            IDENTIFIER_FIELD, ITEM_TYPE_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> glossaryTerms;

    private final String identifier;

    private final String itemType;

    private final String revision;

    private DataProductItem(BuilderImpl builder) {
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.itemType = builder.itemType;
        this.revision = builder.revision;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the data product.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of the data product.
     * </p>
     * 
     * @return The ID of the data product.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The type of the data product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #itemType} will
     * return {@link DataProductItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #itemTypeAsString}.
     * </p>
     * 
     * @return The type of the data product.
     * @see DataProductItemType
     */
    public final DataProductItemType itemType() {
        return DataProductItemType.fromValue(itemType);
    }

    /**
     * <p>
     * The type of the data product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #itemType} will
     * return {@link DataProductItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #itemTypeAsString}.
     * </p>
     * 
     * @return The type of the data product.
     * @see DataProductItemType
     */
    public final String itemTypeAsString() {
        return itemType;
    }

    /**
     * <p>
     * The revision of the data product.
     * </p>
     * 
     * @return The revision of the data product.
     */
    public final String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(itemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductItem)) {
            return false;
        }
        DataProductItem other = (DataProductItem) obj;
        return hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(itemTypeAsString(), other.itemTypeAsString()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductItem").add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null)
                .add("Identifier", identifier()).add("ItemType", itemTypeAsString()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "itemType":
            return Optional.ofNullable(clazz.cast(itemTypeAsString()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("itemType", ITEM_TYPE_FIELD);
        map.put("revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProductItem, T> g) {
        return obj -> g.apply((DataProductItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductItem> {
        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of the data product.
         * </p>
         * 
         * @param identifier
         *        The ID of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The type of the data product.
         * </p>
         * 
         * @param itemType
         *        The type of the data product.
         * @see DataProductItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProductItemType
         */
        Builder itemType(String itemType);

        /**
         * <p>
         * The type of the data product.
         * </p>
         * 
         * @param itemType
         *        The type of the data product.
         * @see DataProductItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProductItemType
         */
        Builder itemType(DataProductItemType itemType);

        /**
         * <p>
         * The revision of the data product.
         * </p>
         * 
         * @param revision
         *        The revision of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);
    }

    static final class BuilderImpl implements Builder {
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String identifier;

        private String itemType;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductItem model) {
            glossaryTerms(model.glossaryTerms);
            identifier(model.identifier);
            itemType(model.itemType);
            revision(model.revision);
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = ItemGlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = ItemGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getItemType() {
            return itemType;
        }

        public final void setItemType(String itemType) {
            this.itemType = itemType;
        }

        @Override
        public final Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        @Override
        public final Builder itemType(DataProductItemType itemType) {
            this.itemType(itemType == null ? null : itemType.toString());
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public DataProductItem build() {
            return new DataProductItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
