/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset of the data product listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductListingItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductListingItem.Builder, DataProductListingItem> {
    private static final SdkField<DataProductListingItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<DataProductListingItemAdditionalAttributes> builder(MarshallingType.SDK_POJO).memberName("additionalAttributes")
            .getter(getter(DataProductListingItem::additionalAttributes)).setter(setter(Builder::additionalAttributes))
            .constructor(DataProductListingItemAdditionalAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DataProductListingItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DataProductListingItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(DataProductListingItem::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(DataProductListingItem::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(DataProductListingItem::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListingSummaryItem>> ITEMS_FIELD = SdkField
            .<List<ListingSummaryItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(DataProductListingItem::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListingSummaryItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListingSummaryItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LISTING_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingCreatedBy").getter(getter(DataProductListingItem::listingCreatedBy))
            .setter(setter(Builder::listingCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingCreatedBy").build()).build();

    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingId").getter(getter(DataProductListingItem::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();

    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingRevision").getter(getter(DataProductListingItem::listingRevision))
            .setter(setter(Builder::listingRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()).build();

    private static final SdkField<String> LISTING_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingUpdatedBy").getter(getter(DataProductListingItem::listingUpdatedBy))
            .setter(setter(Builder::listingUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingUpdatedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataProductListingItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(DataProductListingItem::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, GLOSSARY_TERMS_FIELD, ITEMS_FIELD,
            LISTING_CREATED_BY_FIELD, LISTING_ID_FIELD, LISTING_REVISION_FIELD, LISTING_UPDATED_BY_FIELD, NAME_FIELD,
            OWNING_PROJECT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataProductListingItemAdditionalAttributes additionalAttributes;

    private final Instant createdAt;

    private final String description;

    private final String entityId;

    private final String entityRevision;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private final List<ListingSummaryItem> items;

    private final String listingCreatedBy;

    private final String listingId;

    private final String listingRevision;

    private final String listingUpdatedBy;

    private final String name;

    private final String owningProjectId;

    private DataProductListingItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.glossaryTerms = builder.glossaryTerms;
        this.items = builder.items;
        this.listingCreatedBy = builder.listingCreatedBy;
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.listingUpdatedBy = builder.listingUpdatedBy;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
    }

    /**
     * <p>
     * The additional attributes of the asset of the data product.
     * </p>
     * 
     * @return The additional attributes of the asset of the data product.
     */
    public final DataProductListingItemAdditionalAttributes additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The timestamp at which the asset of the data product listing was created.
     * </p>
     * 
     * @return The timestamp at which the asset of the data product listing was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the asset of the asset of the data product.
     * </p>
     * 
     * @return The description of the asset of the asset of the data product.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The entity ID of the asset of the asset of the data product.
     * </p>
     * 
     * @return The entity ID of the asset of the asset of the data product.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The revision of the asset of the asset of the data product.
     * </p>
     * 
     * @return The revision of the asset of the asset of the data product.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the asset of the asset of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the asset of the asset of the data product.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data of the asset of the data product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The data of the asset of the data product.
     */
    public final List<ListingSummaryItem> items() {
        return items;
    }

    /**
     * <p>
     * The timestamp at which the listing was created.
     * </p>
     * 
     * @return The timestamp at which the listing was created.
     */
    public final String listingCreatedBy() {
        return listingCreatedBy;
    }

    /**
     * <p>
     * The ID of the listing.
     * </p>
     * 
     * @return The ID of the listing.
     */
    public final String listingId() {
        return listingId;
    }

    /**
     * <p>
     * The revision of the listing.
     * </p>
     * 
     * @return The revision of the listing.
     */
    public final String listingRevision() {
        return listingRevision;
    }

    /**
     * <p>
     * The user who updated the listing.
     * </p>
     * 
     * @return The user who updated the listing.
     */
    public final String listingUpdatedBy() {
        return listingUpdatedBy;
    }

    /**
     * <p>
     * The name of the asset of the data product.
     * </p>
     * 
     * @return The name of the asset of the data product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the owning project of the asset of the data product.
     * </p>
     * 
     * @return The ID of the owning project of the asset of the data product.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(listingCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        hashCode = 31 * hashCode + Objects.hashCode(listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(listingUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductListingItem)) {
            return false;
        }
        DataProductListingItem other = (DataProductListingItem) obj;
        return Objects.equals(additionalAttributes(), other.additionalAttributes())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(entityRevision(), other.entityRevision())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(listingCreatedBy(), other.listingCreatedBy()) && Objects.equals(listingId(), other.listingId())
                && Objects.equals(listingRevision(), other.listingRevision())
                && Objects.equals(listingUpdatedBy(), other.listingUpdatedBy()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectId(), other.owningProjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductListingItem").add("AdditionalAttributes", additionalAttributes())
                .add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("EntityId", entityId())
                .add("EntityRevision", entityRevision()).add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null)
                .add("Items", hasItems() ? items() : null).add("ListingCreatedBy", listingCreatedBy())
                .add("ListingId", listingId()).add("ListingRevision", listingRevision())
                .add("ListingUpdatedBy", listingUpdatedBy())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", owningProjectId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "listingCreatedBy":
            return Optional.ofNullable(clazz.cast(listingCreatedBy()));
        case "listingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        case "listingRevision":
            return Optional.ofNullable(clazz.cast(listingRevision()));
        case "listingUpdatedBy":
            return Optional.ofNullable(clazz.cast(listingUpdatedBy()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("listingCreatedBy", LISTING_CREATED_BY_FIELD);
        map.put("listingId", LISTING_ID_FIELD);
        map.put("listingRevision", LISTING_REVISION_FIELD);
        map.put("listingUpdatedBy", LISTING_UPDATED_BY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProductListingItem, T> g) {
        return obj -> g.apply((DataProductListingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductListingItem> {
        /**
         * <p>
         * The additional attributes of the asset of the data product.
         * </p>
         * 
         * @param additionalAttributes
         *        The additional attributes of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(DataProductListingItemAdditionalAttributes additionalAttributes);

        /**
         * <p>
         * The additional attributes of the asset of the data product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataProductListingItemAdditionalAttributes.Builder} avoiding the need to create one manually via
         * {@link DataProductListingItemAdditionalAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductListingItemAdditionalAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #additionalAttributes(DataProductListingItemAdditionalAttributes)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on {@link DataProductListingItemAdditionalAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(DataProductListingItemAdditionalAttributes)
         */
        default Builder additionalAttributes(Consumer<DataProductListingItemAdditionalAttributes.Builder> additionalAttributes) {
            return additionalAttributes(DataProductListingItemAdditionalAttributes.builder().applyMutation(additionalAttributes)
                    .build());
        }

        /**
         * <p>
         * The timestamp at which the asset of the data product listing was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the asset of the data product listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the asset of the asset of the data product.
         * </p>
         * 
         * @param description
         *        The description of the asset of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The entity ID of the asset of the asset of the data product.
         * </p>
         * 
         * @param entityId
         *        The entity ID of the asset of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The revision of the asset of the asset of the data product.
         * </p>
         * 
         * @param entityRevision
         *        The revision of the asset of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The glossary terms of the asset of the asset of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the asset of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the asset of the asset of the data product.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the asset of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * The glossary terms of the asset of the asset of the data product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);

        /**
         * <p>
         * The data of the asset of the data product.
         * </p>
         * 
         * @param items
         *        The data of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ListingSummaryItem> items);

        /**
         * <p>
         * The data of the asset of the data product.
         * </p>
         * 
         * @param items
         *        The data of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ListingSummaryItem... items);

        /**
         * <p>
         * The data of the asset of the data product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ListingSummaryItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.ListingSummaryItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ListingSummaryItem.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<ListingSummaryItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ListingSummaryItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ListingSummaryItem>)
         */
        Builder items(Consumer<ListingSummaryItem.Builder>... items);

        /**
         * <p>
         * The timestamp at which the listing was created.
         * </p>
         * 
         * @param listingCreatedBy
         *        The timestamp at which the listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingCreatedBy(String listingCreatedBy);

        /**
         * <p>
         * The ID of the listing.
         * </p>
         * 
         * @param listingId
         *        The ID of the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);

        /**
         * <p>
         * The revision of the listing.
         * </p>
         * 
         * @param listingRevision
         *        The revision of the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingRevision(String listingRevision);

        /**
         * <p>
         * The user who updated the listing.
         * </p>
         * 
         * @param listingUpdatedBy
         *        The user who updated the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingUpdatedBy(String listingUpdatedBy);

        /**
         * <p>
         * The name of the asset of the data product.
         * </p>
         * 
         * @param name
         *        The name of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the owning project of the asset of the data product.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the owning project of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);
    }

    static final class BuilderImpl implements Builder {
        private DataProductListingItemAdditionalAttributes additionalAttributes;

        private Instant createdAt;

        private String description;

        private String entityId;

        private String entityRevision;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private List<ListingSummaryItem> items = DefaultSdkAutoConstructList.getInstance();

        private String listingCreatedBy;

        private String listingId;

        private String listingRevision;

        private String listingUpdatedBy;

        private String name;

        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductListingItem model) {
            additionalAttributes(model.additionalAttributes);
            createdAt(model.createdAt);
            description(model.description);
            entityId(model.entityId);
            entityRevision(model.entityRevision);
            glossaryTerms(model.glossaryTerms);
            items(model.items);
            listingCreatedBy(model.listingCreatedBy);
            listingId(model.listingId);
            listingRevision(model.listingRevision);
            listingUpdatedBy(model.listingUpdatedBy);
            name(model.name);
            owningProjectId(model.owningProjectId);
        }

        public final DataProductListingItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return additionalAttributes != null ? additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(DataProductListingItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(DataProductListingItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListingSummaryItem.Builder> getItems() {
            List<ListingSummaryItem.Builder> result = ListingSummaryItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListingSummaryItem.BuilderImpl> items) {
            this.items = ListingSummaryItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListingSummaryItem> items) {
            this.items = ListingSummaryItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListingSummaryItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListingSummaryItem.Builder>... items) {
            items(Stream.of(items).map(c -> ListingSummaryItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getListingCreatedBy() {
            return listingCreatedBy;
        }

        public final void setListingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
        }

        @Override
        public final Builder listingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
            return this;
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getListingUpdatedBy() {
            return listingUpdatedBy;
        }

        public final void setListingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
        }

        @Override
        public final Builder listingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        @Override
        public DataProductListingItem build() {
            return new DataProductListingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
